/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutomatedReasoningPolicyVersionRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateAutomatedReasoningPolicyVersionRequest.Builder, CreateAutomatedReasoningPolicyVersionRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(CreateAutomatedReasoningPolicyVersionRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateAutomatedReasoningPolicyVersionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> LAST_UPDATED_DEFINITION_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedDefinitionHash")
            .getter(getter(CreateAutomatedReasoningPolicyVersionRequest::lastUpdatedDefinitionHash))
            .setter(setter(Builder::lastUpdatedDefinitionHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDefinitionHash").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateAutomatedReasoningPolicyVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, LAST_UPDATED_DEFINITION_HASH_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String clientRequestToken;

    private final String lastUpdatedDefinitionHash;

    private final List<Tag> tags;

    private CreateAutomatedReasoningPolicyVersionRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.lastUpdatedDefinitionHash = builder.lastUpdatedDefinitionHash;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to create a version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to create a version.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
     *         token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The hash of the current policy definition used as a concurrency token to ensure the policy hasn't been modified
     * since you last retrieved it.
     * </p>
     * 
     * @return The hash of the current policy definition used as a concurrency token to ensure the policy hasn't been
     *         modified since you last retrieved it.
     */
    public final String lastUpdatedDefinitionHash() {
        return lastUpdatedDefinitionHash;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to associate with the policy version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to associate with the policy version.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDefinitionHash());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutomatedReasoningPolicyVersionRequest)) {
            return false;
        }
        CreateAutomatedReasoningPolicyVersionRequest other = (CreateAutomatedReasoningPolicyVersionRequest) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(lastUpdatedDefinitionHash(), other.lastUpdatedDefinitionHash()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAutomatedReasoningPolicyVersionRequest").add("PolicyArn", policyArn())
                .add("ClientRequestToken", clientRequestToken()).add("LastUpdatedDefinitionHash", lastUpdatedDefinitionHash())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "lastUpdatedDefinitionHash":
            return Optional.ofNullable(clazz.cast(lastUpdatedDefinitionHash()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("lastUpdatedDefinitionHash", LAST_UPDATED_DEFINITION_HASH_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAutomatedReasoningPolicyVersionRequest, T> g) {
        return obj -> g.apply((CreateAutomatedReasoningPolicyVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAutomatedReasoningPolicyVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to create a version.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to create a version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The hash of the current policy definition used as a concurrency token to ensure the policy hasn't been
         * modified since you last retrieved it.
         * </p>
         * 
         * @param lastUpdatedDefinitionHash
         *        The hash of the current policy definition used as a concurrency token to ensure the policy hasn't been
         *        modified since you last retrieved it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDefinitionHash(String lastUpdatedDefinitionHash);

        /**
         * <p>
         * A list of tags to associate with the policy version.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to associate with the policy version.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to associate with the policy version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String policyArn;

        private String clientRequestToken;

        private String lastUpdatedDefinitionHash;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutomatedReasoningPolicyVersionRequest model) {
            super(model);
            policyArn(model.policyArn);
            clientRequestToken(model.clientRequestToken);
            lastUpdatedDefinitionHash(model.lastUpdatedDefinitionHash);
            tags(model.tags);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getLastUpdatedDefinitionHash() {
            return lastUpdatedDefinitionHash;
        }

        public final void setLastUpdatedDefinitionHash(String lastUpdatedDefinitionHash) {
            this.lastUpdatedDefinitionHash = lastUpdatedDefinitionHash;
        }

        @Override
        public final Builder lastUpdatedDefinitionHash(String lastUpdatedDefinitionHash) {
            this.lastUpdatedDefinitionHash = lastUpdatedDefinitionHash;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutomatedReasoningPolicyVersionRequest build() {
            return new CreateAutomatedReasoningPolicyVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
