/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutomatedReasoningPolicyVersionResponse extends BedrockResponse implements
        ToCopyableBuilder<CreateAutomatedReasoningPolicyVersionResponse.Builder, CreateAutomatedReasoningPolicyVersionResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(CreateAutomatedReasoningPolicyVersionResponse::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CreateAutomatedReasoningPolicyVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAutomatedReasoningPolicyVersionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAutomatedReasoningPolicyVersionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DEFINITION_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definitionHash").getter(getter(CreateAutomatedReasoningPolicyVersionResponse::definitionHash))
            .setter(setter(Builder::definitionHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionHash").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CreateAutomatedReasoningPolicyVersionResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            VERSION_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DEFINITION_HASH_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String version;

    private final String name;

    private final String description;

    private final String definitionHash;

    private final Instant createdAt;

    private CreateAutomatedReasoningPolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.version = builder.version;
        this.name = builder.name;
        this.description = builder.description;
        this.definitionHash = builder.definitionHash;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The versioned Amazon Resource Name (ARN) of the policy version.
     * </p>
     * 
     * @return The versioned Amazon Resource Name (ARN) of the policy version.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The version number of the policy version.
     * </p>
     * 
     * @return The version number of the policy version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The name of the policy version.
     * </p>
     * 
     * @return The name of the policy version.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the policy version.
     * </p>
     * 
     * @return The description of the policy version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The hash of the policy definition for this version.
     * </p>
     * 
     * @return The hash of the policy definition for this version.
     */
    public final String definitionHash() {
        return definitionHash;
    }

    /**
     * <p>
     * The timestamp when the policy version was created.
     * </p>
     * 
     * @return The timestamp when the policy version was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(definitionHash());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutomatedReasoningPolicyVersionResponse)) {
            return false;
        }
        CreateAutomatedReasoningPolicyVersionResponse other = (CreateAutomatedReasoningPolicyVersionResponse) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(version(), other.version())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(definitionHash(), other.definitionHash()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAutomatedReasoningPolicyVersionResponse").add("PolicyArn", policyArn())
                .add("Version", version()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DefinitionHash", definitionHash()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "definitionHash":
            return Optional.ofNullable(clazz.cast(definitionHash()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("definitionHash", DEFINITION_HASH_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAutomatedReasoningPolicyVersionResponse, T> g) {
        return obj -> g.apply((CreateAutomatedReasoningPolicyVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAutomatedReasoningPolicyVersionResponse> {
        /**
         * <p>
         * The versioned Amazon Resource Name (ARN) of the policy version.
         * </p>
         * 
         * @param policyArn
         *        The versioned Amazon Resource Name (ARN) of the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The version number of the policy version.
         * </p>
         * 
         * @param version
         *        The version number of the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The name of the policy version.
         * </p>
         * 
         * @param name
         *        The name of the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the policy version.
         * </p>
         * 
         * @param description
         *        The description of the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The hash of the policy definition for this version.
         * </p>
         * 
         * @param definitionHash
         *        The hash of the policy definition for this version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionHash(String definitionHash);

        /**
         * <p>
         * The timestamp when the policy version was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the policy version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String policyArn;

        private String version;

        private String name;

        private String description;

        private String definitionHash;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutomatedReasoningPolicyVersionResponse model) {
            super(model);
            policyArn(model.policyArn);
            version(model.version);
            name(model.name);
            description(model.description);
            definitionHash(model.definitionHash);
            createdAt(model.createdAt);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefinitionHash() {
            return definitionHash;
        }

        public final void setDefinitionHash(String definitionHash) {
            this.definitionHash = definitionHash;
        }

        @Override
        public final Builder definitionHash(String definitionHash) {
            this.definitionHash = definitionHash;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateAutomatedReasoningPolicyVersionResponse build() {
            return new CreateAutomatedReasoningPolicyVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
