/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGuardrailRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateGuardrailRequest.Builder, CreateGuardrailRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGuardrailRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateGuardrailRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<GuardrailTopicPolicyConfig> TOPIC_POLICY_CONFIG_FIELD = SdkField
            .<GuardrailTopicPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("topicPolicyConfig")
            .getter(getter(CreateGuardrailRequest::topicPolicyConfig)).setter(setter(Builder::topicPolicyConfig))
            .constructor(GuardrailTopicPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicyConfig").build()).build();

    private static final SdkField<GuardrailContentPolicyConfig> CONTENT_POLICY_CONFIG_FIELD = SdkField
            .<GuardrailContentPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("contentPolicyConfig")
            .getter(getter(CreateGuardrailRequest::contentPolicyConfig)).setter(setter(Builder::contentPolicyConfig))
            .constructor(GuardrailContentPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicyConfig").build())
            .build();

    private static final SdkField<GuardrailWordPolicyConfig> WORD_POLICY_CONFIG_FIELD = SdkField
            .<GuardrailWordPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("wordPolicyConfig")
            .getter(getter(CreateGuardrailRequest::wordPolicyConfig)).setter(setter(Builder::wordPolicyConfig))
            .constructor(GuardrailWordPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicyConfig").build()).build();

    private static final SdkField<GuardrailSensitiveInformationPolicyConfig> SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD = SdkField
            .<GuardrailSensitiveInformationPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sensitiveInformationPolicyConfig")
            .getter(getter(CreateGuardrailRequest::sensitiveInformationPolicyConfig))
            .setter(setter(Builder::sensitiveInformationPolicyConfig))
            .constructor(GuardrailSensitiveInformationPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicyConfig")
                    .build()).build();

    private static final SdkField<GuardrailContextualGroundingPolicyConfig> CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD = SdkField
            .<GuardrailContextualGroundingPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("contextualGroundingPolicyConfig")
            .getter(getter(CreateGuardrailRequest::contextualGroundingPolicyConfig))
            .setter(setter(Builder::contextualGroundingPolicyConfig))
            .constructor(GuardrailContextualGroundingPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicyConfig")
                    .build()).build();

    private static final SdkField<GuardrailAutomatedReasoningPolicyConfig> AUTOMATED_REASONING_POLICY_CONFIG_FIELD = SdkField
            .<GuardrailAutomatedReasoningPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("automatedReasoningPolicyConfig")
            .getter(getter(CreateGuardrailRequest::automatedReasoningPolicyConfig))
            .setter(setter(Builder::automatedReasoningPolicyConfig))
            .constructor(GuardrailAutomatedReasoningPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automatedReasoningPolicyConfig")
                    .build()).build();

    private static final SdkField<GuardrailCrossRegionConfig> CROSS_REGION_CONFIG_FIELD = SdkField
            .<GuardrailCrossRegionConfig> builder(MarshallingType.SDK_POJO).memberName("crossRegionConfig")
            .getter(getter(CreateGuardrailRequest::crossRegionConfig)).setter(setter(Builder::crossRegionConfig))
            .constructor(GuardrailCrossRegionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossRegionConfig").build()).build();

    private static final SdkField<String> BLOCKED_INPUT_MESSAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedInputMessaging").getter(getter(CreateGuardrailRequest::blockedInputMessaging))
            .setter(setter(Builder::blockedInputMessaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedInputMessaging").build())
            .build();

    private static final SdkField<String> BLOCKED_OUTPUTS_MESSAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedOutputsMessaging").getter(getter(CreateGuardrailRequest::blockedOutputsMessaging))
            .setter(setter(Builder::blockedOutputsMessaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedOutputsMessaging").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CreateGuardrailRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateGuardrailRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateGuardrailRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            TOPIC_POLICY_CONFIG_FIELD, CONTENT_POLICY_CONFIG_FIELD, WORD_POLICY_CONFIG_FIELD,
            SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD, CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD,
            AUTOMATED_REASONING_POLICY_CONFIG_FIELD, CROSS_REGION_CONFIG_FIELD, BLOCKED_INPUT_MESSAGING_FIELD,
            BLOCKED_OUTPUTS_MESSAGING_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final GuardrailTopicPolicyConfig topicPolicyConfig;

    private final GuardrailContentPolicyConfig contentPolicyConfig;

    private final GuardrailWordPolicyConfig wordPolicyConfig;

    private final GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;

    private final GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;

    private final GuardrailAutomatedReasoningPolicyConfig automatedReasoningPolicyConfig;

    private final GuardrailCrossRegionConfig crossRegionConfig;

    private final String blockedInputMessaging;

    private final String blockedOutputsMessaging;

    private final String kmsKeyId;

    private final List<Tag> tags;

    private final String clientRequestToken;

    private CreateGuardrailRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.topicPolicyConfig = builder.topicPolicyConfig;
        this.contentPolicyConfig = builder.contentPolicyConfig;
        this.wordPolicyConfig = builder.wordPolicyConfig;
        this.sensitiveInformationPolicyConfig = builder.sensitiveInformationPolicyConfig;
        this.contextualGroundingPolicyConfig = builder.contextualGroundingPolicyConfig;
        this.automatedReasoningPolicyConfig = builder.automatedReasoningPolicyConfig;
        this.crossRegionConfig = builder.crossRegionConfig;
        this.blockedInputMessaging = builder.blockedInputMessaging;
        this.blockedOutputsMessaging = builder.blockedOutputsMessaging;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name to give the guardrail.
     * </p>
     * 
     * @return The name to give the guardrail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the guardrail.
     * </p>
     * 
     * @return A description of the guardrail.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The topic policies to configure for the guardrail.
     * </p>
     * 
     * @return The topic policies to configure for the guardrail.
     */
    public final GuardrailTopicPolicyConfig topicPolicyConfig() {
        return topicPolicyConfig;
    }

    /**
     * <p>
     * The content filter policies to configure for the guardrail.
     * </p>
     * 
     * @return The content filter policies to configure for the guardrail.
     */
    public final GuardrailContentPolicyConfig contentPolicyConfig() {
        return contentPolicyConfig;
    }

    /**
     * <p>
     * The word policy you configure for the guardrail.
     * </p>
     * 
     * @return The word policy you configure for the guardrail.
     */
    public final GuardrailWordPolicyConfig wordPolicyConfig() {
        return wordPolicyConfig;
    }

    /**
     * <p>
     * The sensitive information policy to configure for the guardrail.
     * </p>
     * 
     * @return The sensitive information policy to configure for the guardrail.
     */
    public final GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig() {
        return sensitiveInformationPolicyConfig;
    }

    /**
     * <p>
     * The contextual grounding policy configuration used to create a guardrail.
     * </p>
     * 
     * @return The contextual grounding policy configuration used to create a guardrail.
     */
    public final GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig() {
        return contextualGroundingPolicyConfig;
    }

    /**
     * <p>
     * Optional configuration for integrating Automated Reasoning policies with the new guardrail.
     * </p>
     * 
     * @return Optional configuration for integrating Automated Reasoning policies with the new guardrail.
     */
    public final GuardrailAutomatedReasoningPolicyConfig automatedReasoningPolicyConfig() {
        return automatedReasoningPolicyConfig;
    }

    /**
     * <p>
     * The system-defined guardrail profile that you're using with your guardrail. Guardrail profiles define the
     * destination Amazon Web Services Regions where guardrail inference requests can be automatically routed.
     * </p>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * 
     * @return The system-defined guardrail profile that you're using with your guardrail. Guardrail profiles define the
     *         destination Amazon Web Services Regions where guardrail inference requests can be automatically
     *         routed.</p>
     *         <p>
     *         For more information, see the <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">Amazon Bedrock
     *         User Guide</a>.
     */
    public final GuardrailCrossRegionConfig crossRegionConfig() {
        return crossRegionConfig;
    }

    /**
     * <p>
     * The message to return when the guardrail blocks a prompt.
     * </p>
     * 
     * @return The message to return when the guardrail blocks a prompt.
     */
    public final String blockedInputMessaging() {
        return blockedInputMessaging;
    }

    /**
     * <p>
     * The message to return when the guardrail blocks a model response.
     * </p>
     * 
     * @return The message to return when the guardrail blocks a model response.
     */
    public final String blockedOutputsMessaging() {
        return blockedOutputsMessaging;
    }

    /**
     * <p>
     * The ARN of the KMS key that you use to encrypt the guardrail.
     * </p>
     * 
     * @return The ARN of the KMS key that you use to encrypt the guardrail.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags that you want to attach to the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that you want to attach to the guardrail.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than once. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than once. If this
     *         token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon S3 User Guide</i>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(topicPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(contentPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(wordPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(sensitiveInformationPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(contextualGroundingPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(automatedReasoningPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(crossRegionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(blockedInputMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(blockedOutputsMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGuardrailRequest)) {
            return false;
        }
        CreateGuardrailRequest other = (CreateGuardrailRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(topicPolicyConfig(), other.topicPolicyConfig())
                && Objects.equals(contentPolicyConfig(), other.contentPolicyConfig())
                && Objects.equals(wordPolicyConfig(), other.wordPolicyConfig())
                && Objects.equals(sensitiveInformationPolicyConfig(), other.sensitiveInformationPolicyConfig())
                && Objects.equals(contextualGroundingPolicyConfig(), other.contextualGroundingPolicyConfig())
                && Objects.equals(automatedReasoningPolicyConfig(), other.automatedReasoningPolicyConfig())
                && Objects.equals(crossRegionConfig(), other.crossRegionConfig())
                && Objects.equals(blockedInputMessaging(), other.blockedInputMessaging())
                && Objects.equals(blockedOutputsMessaging(), other.blockedOutputsMessaging())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGuardrailRequest").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TopicPolicyConfig", topicPolicyConfig()).add("ContentPolicyConfig", contentPolicyConfig())
                .add("WordPolicyConfig", wordPolicyConfig())
                .add("SensitiveInformationPolicyConfig", sensitiveInformationPolicyConfig())
                .add("ContextualGroundingPolicyConfig", contextualGroundingPolicyConfig())
                .add("AutomatedReasoningPolicyConfig", automatedReasoningPolicyConfig())
                .add("CrossRegionConfig", crossRegionConfig())
                .add("BlockedInputMessaging", blockedInputMessaging() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BlockedOutputsMessaging", blockedOutputsMessaging() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KmsKeyId", kmsKeyId()).add("Tags", hasTags() ? tags() : null)
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "topicPolicyConfig":
            return Optional.ofNullable(clazz.cast(topicPolicyConfig()));
        case "contentPolicyConfig":
            return Optional.ofNullable(clazz.cast(contentPolicyConfig()));
        case "wordPolicyConfig":
            return Optional.ofNullable(clazz.cast(wordPolicyConfig()));
        case "sensitiveInformationPolicyConfig":
            return Optional.ofNullable(clazz.cast(sensitiveInformationPolicyConfig()));
        case "contextualGroundingPolicyConfig":
            return Optional.ofNullable(clazz.cast(contextualGroundingPolicyConfig()));
        case "automatedReasoningPolicyConfig":
            return Optional.ofNullable(clazz.cast(automatedReasoningPolicyConfig()));
        case "crossRegionConfig":
            return Optional.ofNullable(clazz.cast(crossRegionConfig()));
        case "blockedInputMessaging":
            return Optional.ofNullable(clazz.cast(blockedInputMessaging()));
        case "blockedOutputsMessaging":
            return Optional.ofNullable(clazz.cast(blockedOutputsMessaging()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("topicPolicyConfig", TOPIC_POLICY_CONFIG_FIELD);
        map.put("contentPolicyConfig", CONTENT_POLICY_CONFIG_FIELD);
        map.put("wordPolicyConfig", WORD_POLICY_CONFIG_FIELD);
        map.put("sensitiveInformationPolicyConfig", SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD);
        map.put("contextualGroundingPolicyConfig", CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD);
        map.put("automatedReasoningPolicyConfig", AUTOMATED_REASONING_POLICY_CONFIG_FIELD);
        map.put("crossRegionConfig", CROSS_REGION_CONFIG_FIELD);
        map.put("blockedInputMessaging", BLOCKED_INPUT_MESSAGING_FIELD);
        map.put("blockedOutputsMessaging", BLOCKED_OUTPUTS_MESSAGING_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGuardrailRequest, T> g) {
        return obj -> g.apply((CreateGuardrailRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGuardrailRequest> {
        /**
         * <p>
         * The name to give the guardrail.
         * </p>
         * 
         * @param name
         *        The name to give the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the guardrail.
         * </p>
         * 
         * @param description
         *        A description of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The topic policies to configure for the guardrail.
         * </p>
         * 
         * @param topicPolicyConfig
         *        The topic policies to configure for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPolicyConfig(GuardrailTopicPolicyConfig topicPolicyConfig);

        /**
         * <p>
         * The topic policies to configure for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailTopicPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link GuardrailTopicPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailTopicPolicyConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #topicPolicyConfig(GuardrailTopicPolicyConfig)}.
         * 
         * @param topicPolicyConfig
         *        a consumer that will call methods on {@link GuardrailTopicPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicPolicyConfig(GuardrailTopicPolicyConfig)
         */
        default Builder topicPolicyConfig(Consumer<GuardrailTopicPolicyConfig.Builder> topicPolicyConfig) {
            return topicPolicyConfig(GuardrailTopicPolicyConfig.builder().applyMutation(topicPolicyConfig).build());
        }

        /**
         * <p>
         * The content filter policies to configure for the guardrail.
         * </p>
         * 
         * @param contentPolicyConfig
         *        The content filter policies to configure for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentPolicyConfig(GuardrailContentPolicyConfig contentPolicyConfig);

        /**
         * <p>
         * The content filter policies to configure for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailContentPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link GuardrailContentPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailContentPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #contentPolicyConfig(GuardrailContentPolicyConfig)}.
         * 
         * @param contentPolicyConfig
         *        a consumer that will call methods on {@link GuardrailContentPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentPolicyConfig(GuardrailContentPolicyConfig)
         */
        default Builder contentPolicyConfig(Consumer<GuardrailContentPolicyConfig.Builder> contentPolicyConfig) {
            return contentPolicyConfig(GuardrailContentPolicyConfig.builder().applyMutation(contentPolicyConfig).build());
        }

        /**
         * <p>
         * The word policy you configure for the guardrail.
         * </p>
         * 
         * @param wordPolicyConfig
         *        The word policy you configure for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordPolicyConfig(GuardrailWordPolicyConfig wordPolicyConfig);

        /**
         * <p>
         * The word policy you configure for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailWordPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link GuardrailWordPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailWordPolicyConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #wordPolicyConfig(GuardrailWordPolicyConfig)}.
         * 
         * @param wordPolicyConfig
         *        a consumer that will call methods on {@link GuardrailWordPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordPolicyConfig(GuardrailWordPolicyConfig)
         */
        default Builder wordPolicyConfig(Consumer<GuardrailWordPolicyConfig.Builder> wordPolicyConfig) {
            return wordPolicyConfig(GuardrailWordPolicyConfig.builder().applyMutation(wordPolicyConfig).build());
        }

        /**
         * <p>
         * The sensitive information policy to configure for the guardrail.
         * </p>
         * 
         * @param sensitiveInformationPolicyConfig
         *        The sensitive information policy to configure for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig);

        /**
         * <p>
         * The sensitive information policy to configure for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailSensitiveInformationPolicyConfig.Builder} avoiding the need to create one manually via
         * {@link GuardrailSensitiveInformationPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailSensitiveInformationPolicyConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig)}.
         * 
         * @param sensitiveInformationPolicyConfig
         *        a consumer that will call methods on {@link GuardrailSensitiveInformationPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig)
         */
        default Builder sensitiveInformationPolicyConfig(
                Consumer<GuardrailSensitiveInformationPolicyConfig.Builder> sensitiveInformationPolicyConfig) {
            return sensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig.builder()
                    .applyMutation(sensitiveInformationPolicyConfig).build());
        }

        /**
         * <p>
         * The contextual grounding policy configuration used to create a guardrail.
         * </p>
         * 
         * @param contextualGroundingPolicyConfig
         *        The contextual grounding policy configuration used to create a guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig);

        /**
         * <p>
         * The contextual grounding policy configuration used to create a guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailContextualGroundingPolicyConfig.Builder} avoiding the need to create one manually via
         * {@link GuardrailContextualGroundingPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailContextualGroundingPolicyConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #contextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig)}.
         * 
         * @param contextualGroundingPolicyConfig
         *        a consumer that will call methods on {@link GuardrailContextualGroundingPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig)
         */
        default Builder contextualGroundingPolicyConfig(
                Consumer<GuardrailContextualGroundingPolicyConfig.Builder> contextualGroundingPolicyConfig) {
            return contextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig.builder()
                    .applyMutation(contextualGroundingPolicyConfig).build());
        }

        /**
         * <p>
         * Optional configuration for integrating Automated Reasoning policies with the new guardrail.
         * </p>
         * 
         * @param automatedReasoningPolicyConfig
         *        Optional configuration for integrating Automated Reasoning policies with the new guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedReasoningPolicyConfig(GuardrailAutomatedReasoningPolicyConfig automatedReasoningPolicyConfig);

        /**
         * <p>
         * Optional configuration for integrating Automated Reasoning policies with the new guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningPolicyConfig.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningPolicyConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #automatedReasoningPolicyConfig(GuardrailAutomatedReasoningPolicyConfig)}.
         * 
         * @param automatedReasoningPolicyConfig
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automatedReasoningPolicyConfig(GuardrailAutomatedReasoningPolicyConfig)
         */
        default Builder automatedReasoningPolicyConfig(
                Consumer<GuardrailAutomatedReasoningPolicyConfig.Builder> automatedReasoningPolicyConfig) {
            return automatedReasoningPolicyConfig(GuardrailAutomatedReasoningPolicyConfig.builder()
                    .applyMutation(automatedReasoningPolicyConfig).build());
        }

        /**
         * <p>
         * The system-defined guardrail profile that you're using with your guardrail. Guardrail profiles define the
         * destination Amazon Web Services Regions where guardrail inference requests can be automatically routed.
         * </p>
         * <p>
         * For more information, see the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">Amazon Bedrock User
         * Guide</a>.
         * </p>
         * 
         * @param crossRegionConfig
         *        The system-defined guardrail profile that you're using with your guardrail. Guardrail profiles define
         *        the destination Amazon Web Services Regions where guardrail inference requests can be automatically
         *        routed.</p>
         *        <p>
         *        For more information, see the <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">Amazon
         *        Bedrock User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionConfig(GuardrailCrossRegionConfig crossRegionConfig);

        /**
         * <p>
         * The system-defined guardrail profile that you're using with your guardrail. Guardrail profiles define the
         * destination Amazon Web Services Regions where guardrail inference requests can be automatically routed.
         * </p>
         * <p>
         * For more information, see the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">Amazon Bedrock User
         * Guide</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailCrossRegionConfig.Builder}
         * avoiding the need to create one manually via {@link GuardrailCrossRegionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailCrossRegionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #crossRegionConfig(GuardrailCrossRegionConfig)}.
         * 
         * @param crossRegionConfig
         *        a consumer that will call methods on {@link GuardrailCrossRegionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossRegionConfig(GuardrailCrossRegionConfig)
         */
        default Builder crossRegionConfig(Consumer<GuardrailCrossRegionConfig.Builder> crossRegionConfig) {
            return crossRegionConfig(GuardrailCrossRegionConfig.builder().applyMutation(crossRegionConfig).build());
        }

        /**
         * <p>
         * The message to return when the guardrail blocks a prompt.
         * </p>
         * 
         * @param blockedInputMessaging
         *        The message to return when the guardrail blocks a prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedInputMessaging(String blockedInputMessaging);

        /**
         * <p>
         * The message to return when the guardrail blocks a model response.
         * </p>
         * 
         * @param blockedOutputsMessaging
         *        The message to return when the guardrail blocks a model response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedOutputsMessaging(String blockedOutputsMessaging);

        /**
         * <p>
         * The ARN of the KMS key that you use to encrypt the guardrail.
         * </p>
         * 
         * @param kmsKeyId
         *        The ARN of the KMS key that you use to encrypt the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The tags that you want to attach to the guardrail.
         * </p>
         * 
         * @param tags
         *        The tags that you want to attach to the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags that you want to attach to the guardrail.
         * </p>
         * 
         * @param tags
         *        The tags that you want to attach to the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags that you want to attach to the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than once. If this token
         * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon S3 User Guide</i>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than once. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon S3 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private GuardrailTopicPolicyConfig topicPolicyConfig;

        private GuardrailContentPolicyConfig contentPolicyConfig;

        private GuardrailWordPolicyConfig wordPolicyConfig;

        private GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;

        private GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;

        private GuardrailAutomatedReasoningPolicyConfig automatedReasoningPolicyConfig;

        private GuardrailCrossRegionConfig crossRegionConfig;

        private String blockedInputMessaging;

        private String blockedOutputsMessaging;

        private String kmsKeyId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGuardrailRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            topicPolicyConfig(model.topicPolicyConfig);
            contentPolicyConfig(model.contentPolicyConfig);
            wordPolicyConfig(model.wordPolicyConfig);
            sensitiveInformationPolicyConfig(model.sensitiveInformationPolicyConfig);
            contextualGroundingPolicyConfig(model.contextualGroundingPolicyConfig);
            automatedReasoningPolicyConfig(model.automatedReasoningPolicyConfig);
            crossRegionConfig(model.crossRegionConfig);
            blockedInputMessaging(model.blockedInputMessaging);
            blockedOutputsMessaging(model.blockedOutputsMessaging);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GuardrailTopicPolicyConfig.Builder getTopicPolicyConfig() {
            return topicPolicyConfig != null ? topicPolicyConfig.toBuilder() : null;
        }

        public final void setTopicPolicyConfig(GuardrailTopicPolicyConfig.BuilderImpl topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig != null ? topicPolicyConfig.build() : null;
        }

        @Override
        public final Builder topicPolicyConfig(GuardrailTopicPolicyConfig topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        public final GuardrailContentPolicyConfig.Builder getContentPolicyConfig() {
            return contentPolicyConfig != null ? contentPolicyConfig.toBuilder() : null;
        }

        public final void setContentPolicyConfig(GuardrailContentPolicyConfig.BuilderImpl contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig != null ? contentPolicyConfig.build() : null;
        }

        @Override
        public final Builder contentPolicyConfig(GuardrailContentPolicyConfig contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        public final GuardrailWordPolicyConfig.Builder getWordPolicyConfig() {
            return wordPolicyConfig != null ? wordPolicyConfig.toBuilder() : null;
        }

        public final void setWordPolicyConfig(GuardrailWordPolicyConfig.BuilderImpl wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig != null ? wordPolicyConfig.build() : null;
        }

        @Override
        public final Builder wordPolicyConfig(GuardrailWordPolicyConfig wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        public final GuardrailSensitiveInformationPolicyConfig.Builder getSensitiveInformationPolicyConfig() {
            return sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicyConfig(
                GuardrailSensitiveInformationPolicyConfig.BuilderImpl sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig
                    .build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicyConfig(
                GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        public final GuardrailContextualGroundingPolicyConfig.Builder getContextualGroundingPolicyConfig() {
            return contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig.toBuilder() : null;
        }

        public final void setContextualGroundingPolicyConfig(
                GuardrailContextualGroundingPolicyConfig.BuilderImpl contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig
                    .build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicyConfig(
                GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig;
            return this;
        }

        public final GuardrailAutomatedReasoningPolicyConfig.Builder getAutomatedReasoningPolicyConfig() {
            return automatedReasoningPolicyConfig != null ? automatedReasoningPolicyConfig.toBuilder() : null;
        }

        public final void setAutomatedReasoningPolicyConfig(
                GuardrailAutomatedReasoningPolicyConfig.BuilderImpl automatedReasoningPolicyConfig) {
            this.automatedReasoningPolicyConfig = automatedReasoningPolicyConfig != null ? automatedReasoningPolicyConfig.build()
                    : null;
        }

        @Override
        public final Builder automatedReasoningPolicyConfig(GuardrailAutomatedReasoningPolicyConfig automatedReasoningPolicyConfig) {
            this.automatedReasoningPolicyConfig = automatedReasoningPolicyConfig;
            return this;
        }

        public final GuardrailCrossRegionConfig.Builder getCrossRegionConfig() {
            return crossRegionConfig != null ? crossRegionConfig.toBuilder() : null;
        }

        public final void setCrossRegionConfig(GuardrailCrossRegionConfig.BuilderImpl crossRegionConfig) {
            this.crossRegionConfig = crossRegionConfig != null ? crossRegionConfig.build() : null;
        }

        @Override
        public final Builder crossRegionConfig(GuardrailCrossRegionConfig crossRegionConfig) {
            this.crossRegionConfig = crossRegionConfig;
            return this;
        }

        public final String getBlockedInputMessaging() {
            return blockedInputMessaging;
        }

        public final void setBlockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
        }

        @Override
        public final Builder blockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        public final String getBlockedOutputsMessaging() {
            return blockedOutputsMessaging;
        }

        public final void setBlockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
        }

        @Override
        public final Builder blockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGuardrailRequest build() {
            return new CreateGuardrailRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
