/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dimensional price rate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionalPriceRate implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionalPriceRate.Builder, DimensionalPriceRate> {
    private static final SdkField<String> DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dimension").getter(getter(DimensionalPriceRate::dimension)).setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimension").build()).build();

    private static final SdkField<String> PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("price")
            .getter(getter(DimensionalPriceRate::price)).setter(setter(Builder::price))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DimensionalPriceRate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(DimensionalPriceRate::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_FIELD, PRICE_FIELD,
            DESCRIPTION_FIELD, UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimension;

    private final String price;

    private final String description;

    private final String unit;

    private DimensionalPriceRate(BuilderImpl builder) {
        this.dimension = builder.dimension;
        this.price = builder.price;
        this.description = builder.description;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * Dimension for the price rate.
     * </p>
     * 
     * @return Dimension for the price rate.
     */
    public final String dimension() {
        return dimension;
    }

    /**
     * <p>
     * Single-dimensional rate information.
     * </p>
     * 
     * @return Single-dimensional rate information.
     */
    public final String price() {
        return price;
    }

    /**
     * <p>
     * Description of the price rate.
     * </p>
     * 
     * @return Description of the price rate.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Unit associated with the price.
     * </p>
     * 
     * @return Unit associated with the price.
     */
    public final String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimension());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionalPriceRate)) {
            return false;
        }
        DimensionalPriceRate other = (DimensionalPriceRate) obj;
        return Objects.equals(dimension(), other.dimension()) && Objects.equals(price(), other.price())
                && Objects.equals(description(), other.description()) && Objects.equals(unit(), other.unit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionalPriceRate").add("Dimension", dimension()).add("Price", price())
                .add("Description", description()).add("Unit", unit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimension":
            return Optional.ofNullable(clazz.cast(dimension()));
        case "price":
            return Optional.ofNullable(clazz.cast(price()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimension", DIMENSION_FIELD);
        map.put("price", PRICE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionalPriceRate, T> g) {
        return obj -> g.apply((DimensionalPriceRate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionalPriceRate> {
        /**
         * <p>
         * Dimension for the price rate.
         * </p>
         * 
         * @param dimension
         *        Dimension for the price rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimension(String dimension);

        /**
         * <p>
         * Single-dimensional rate information.
         * </p>
         * 
         * @param price
         *        Single-dimensional rate information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(String price);

        /**
         * <p>
         * Description of the price rate.
         * </p>
         * 
         * @param description
         *        Description of the price rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Unit associated with the price.
         * </p>
         * 
         * @param unit
         *        Unit associated with the price.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);
    }

    static final class BuilderImpl implements Builder {
        private String dimension;

        private String price;

        private String description;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionalPriceRate model) {
            dimension(model.dimension);
            price(model.price);
            description(model.description);
            unit(model.unit);
        }

        public final String getDimension() {
            return dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getPrice() {
            return price;
        }

        public final void setPrice(String price) {
            this.price = price;
        }

        @Override
        public final Builder price(String price) {
            this.price = price;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public DimensionalPriceRate build() {
            return new DimensionalPriceRate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
