/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportAutomatedReasoningPolicyVersionResponse extends BedrockResponse implements
        ToCopyableBuilder<ExportAutomatedReasoningPolicyVersionResponse.Builder, ExportAutomatedReasoningPolicyVersionResponse> {
    private static final SdkField<AutomatedReasoningPolicyDefinition> POLICY_DEFINITION_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("policyDefinition")
            .getter(getter(ExportAutomatedReasoningPolicyVersionResponse::policyDefinition))
            .setter(setter(Builder::policyDefinition))
            .constructor(AutomatedReasoningPolicyDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDefinition").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AutomatedReasoningPolicyDefinition policyDefinition;

    private ExportAutomatedReasoningPolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.policyDefinition = builder.policyDefinition;
    }

    /**
     * <p>
     * The exported policy definition containing the formal logic rules, variables, and custom variable types.
     * </p>
     * 
     * @return The exported policy definition containing the formal logic rules, variables, and custom variable types.
     */
    public final AutomatedReasoningPolicyDefinition policyDefinition() {
        return policyDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAutomatedReasoningPolicyVersionResponse)) {
            return false;
        }
        ExportAutomatedReasoningPolicyVersionResponse other = (ExportAutomatedReasoningPolicyVersionResponse) obj;
        return Objects.equals(policyDefinition(), other.policyDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportAutomatedReasoningPolicyVersionResponse").add("PolicyDefinition", policyDefinition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyDefinition":
            return Optional.ofNullable(clazz.cast(policyDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyDefinition", POLICY_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportAutomatedReasoningPolicyVersionResponse, T> g) {
        return obj -> g.apply((ExportAutomatedReasoningPolicyVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportAutomatedReasoningPolicyVersionResponse> {
        /**
         * <p>
         * The exported policy definition containing the formal logic rules, variables, and custom variable types.
         * </p>
         * 
         * @param policyDefinition
         *        The exported policy definition containing the formal logic rules, variables, and custom variable
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition);

        /**
         * <p>
         * The exported policy definition containing the formal logic rules, variables, and custom variable types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinition.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #policyDefinition(AutomatedReasoningPolicyDefinition)}.
         * 
         * @param policyDefinition
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDefinition(AutomatedReasoningPolicyDefinition)
         */
        default Builder policyDefinition(Consumer<AutomatedReasoningPolicyDefinition.Builder> policyDefinition) {
            return policyDefinition(AutomatedReasoningPolicyDefinition.builder().applyMutation(policyDefinition).build());
        }
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private AutomatedReasoningPolicyDefinition policyDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportAutomatedReasoningPolicyVersionResponse model) {
            super(model);
            policyDefinition(model.policyDefinition);
        }

        public final AutomatedReasoningPolicyDefinition.Builder getPolicyDefinition() {
            return policyDefinition != null ? policyDefinition.toBuilder() : null;
        }

        public final void setPolicyDefinition(AutomatedReasoningPolicyDefinition.BuilderImpl policyDefinition) {
            this.policyDefinition = policyDefinition != null ? policyDefinition.build() : null;
        }

        @Override
        public final Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition) {
            this.policyDefinition = policyDefinition;
            return this;
        }

        @Override
        public ExportAutomatedReasoningPolicyVersionResponse build() {
            return new ExportAutomatedReasoningPolicyVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
