/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutomatedReasoningPolicyAnnotationsResponse extends BedrockResponse implements
        ToCopyableBuilder<GetAutomatedReasoningPolicyAnnotationsResponse.Builder, GetAutomatedReasoningPolicyAnnotationsResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(GetAutomatedReasoningPolicyAnnotationsResponse::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetAutomatedReasoningPolicyAnnotationsResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildWorkflowId").getter(getter(GetAutomatedReasoningPolicyAnnotationsResponse::buildWorkflowId))
            .setter(setter(Builder::buildWorkflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildWorkflowId").build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyAnnotation>> ANNOTATIONS_FIELD = SdkField
            .<List<AutomatedReasoningPolicyAnnotation>> builder(MarshallingType.LIST)
            .memberName("annotations")
            .getter(getter(GetAutomatedReasoningPolicyAnnotationsResponse::annotations))
            .setter(setter(Builder::annotations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyAnnotation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyAnnotation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ANNOTATION_SET_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("annotationSetHash").getter(getter(GetAutomatedReasoningPolicyAnnotationsResponse::annotationSetHash))
            .setter(setter(Builder::annotationSetHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationSetHash").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetAutomatedReasoningPolicyAnnotationsResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, NAME_FIELD,
            BUILD_WORKFLOW_ID_FIELD, ANNOTATIONS_FIELD, ANNOTATION_SET_HASH_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String name;

    private final String buildWorkflowId;

    private final List<AutomatedReasoningPolicyAnnotation> annotations;

    private final String annotationSetHash;

    private final Instant updatedAt;

    private GetAutomatedReasoningPolicyAnnotationsResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.name = builder.name;
        this.buildWorkflowId = builder.buildWorkflowId;
        this.annotations = builder.annotations;
        this.annotationSetHash = builder.annotationSetHash;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The name of the Automated Reasoning policy.
     * </p>
     * 
     * @return The name of the Automated Reasoning policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier of the build workflow.
     * </p>
     * 
     * @return The unique identifier of the build workflow.
     */
    public final String buildWorkflowId() {
        return buildWorkflowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Annotations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnnotations() {
        return annotations != null && !(annotations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current set of annotations containing rules, variables, and types extracted from the source documents. These
     * can be modified before finalizing the policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotations} method.
     * </p>
     * 
     * @return The current set of annotations containing rules, variables, and types extracted from the source
     *         documents. These can be modified before finalizing the policy.
     */
    public final List<AutomatedReasoningPolicyAnnotation> annotations() {
        return annotations;
    }

    /**
     * <p>
     * A hash value representing the current state of the annotations. This is used for optimistic concurrency control
     * when updating annotations.
     * </p>
     * 
     * @return A hash value representing the current state of the annotations. This is used for optimistic concurrency
     *         control when updating annotations.
     */
    public final String annotationSetHash() {
        return annotationSetHash;
    }

    /**
     * <p>
     * The timestamp when the annotations were last updated.
     * </p>
     * 
     * @return The timestamp when the annotations were last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(buildWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotations() ? annotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(annotationSetHash());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomatedReasoningPolicyAnnotationsResponse)) {
            return false;
        }
        GetAutomatedReasoningPolicyAnnotationsResponse other = (GetAutomatedReasoningPolicyAnnotationsResponse) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(name(), other.name())
                && Objects.equals(buildWorkflowId(), other.buildWorkflowId()) && hasAnnotations() == other.hasAnnotations()
                && Objects.equals(annotations(), other.annotations())
                && Objects.equals(annotationSetHash(), other.annotationSetHash())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutomatedReasoningPolicyAnnotationsResponse").add("PolicyArn", policyArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("BuildWorkflowId", buildWorkflowId())
                .add("Annotations", hasAnnotations() ? annotations() : null).add("AnnotationSetHash", annotationSetHash())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "buildWorkflowId":
            return Optional.ofNullable(clazz.cast(buildWorkflowId()));
        case "annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        case "annotationSetHash":
            return Optional.ofNullable(clazz.cast(annotationSetHash()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        map.put("annotations", ANNOTATIONS_FIELD);
        map.put("annotationSetHash", ANNOTATION_SET_HASH_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutomatedReasoningPolicyAnnotationsResponse, T> g) {
        return obj -> g.apply((GetAutomatedReasoningPolicyAnnotationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutomatedReasoningPolicyAnnotationsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The name of the Automated Reasoning policy.
         * </p>
         * 
         * @param name
         *        The name of the Automated Reasoning policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier of the build workflow.
         * </p>
         * 
         * @param buildWorkflowId
         *        The unique identifier of the build workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildWorkflowId(String buildWorkflowId);

        /**
         * <p>
         * The current set of annotations containing rules, variables, and types extracted from the source documents.
         * These can be modified before finalizing the policy.
         * </p>
         * 
         * @param annotations
         *        The current set of annotations containing rules, variables, and types extracted from the source
         *        documents. These can be modified before finalizing the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(Collection<AutomatedReasoningPolicyAnnotation> annotations);

        /**
         * <p>
         * The current set of annotations containing rules, variables, and types extracted from the source documents.
         * These can be modified before finalizing the policy.
         * </p>
         * 
         * @param annotations
         *        The current set of annotations containing rules, variables, and types extracted from the source
         *        documents. These can be modified before finalizing the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(AutomatedReasoningPolicyAnnotation... annotations);

        /**
         * <p>
         * The current set of annotations containing rules, variables, and types extracted from the source documents.
         * These can be modified before finalizing the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation.Builder#build()} is
         * called immediately and its result is passed to {@link #annotations(List<AutomatedReasoningPolicyAnnotation>)}.
         * 
         * @param annotations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotations(java.util.Collection<AutomatedReasoningPolicyAnnotation>)
         */
        Builder annotations(Consumer<AutomatedReasoningPolicyAnnotation.Builder>... annotations);

        /**
         * <p>
         * A hash value representing the current state of the annotations. This is used for optimistic concurrency
         * control when updating annotations.
         * </p>
         * 
         * @param annotationSetHash
         *        A hash value representing the current state of the annotations. This is used for optimistic
         *        concurrency control when updating annotations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationSetHash(String annotationSetHash);

        /**
         * <p>
         * The timestamp when the annotations were last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the annotations were last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String policyArn;

        private String name;

        private String buildWorkflowId;

        private List<AutomatedReasoningPolicyAnnotation> annotations = DefaultSdkAutoConstructList.getInstance();

        private String annotationSetHash;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomatedReasoningPolicyAnnotationsResponse model) {
            super(model);
            policyArn(model.policyArn);
            name(model.name);
            buildWorkflowId(model.buildWorkflowId);
            annotations(model.annotations);
            annotationSetHash(model.annotationSetHash);
            updatedAt(model.updatedAt);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getBuildWorkflowId() {
            return buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        public final List<AutomatedReasoningPolicyAnnotation.Builder> getAnnotations() {
            List<AutomatedReasoningPolicyAnnotation.Builder> result = AutomatedReasoningPolicyAnnotationListCopier
                    .copyToBuilder(this.annotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotations(Collection<AutomatedReasoningPolicyAnnotation.BuilderImpl> annotations) {
            this.annotations = AutomatedReasoningPolicyAnnotationListCopier.copyFromBuilder(annotations);
        }

        @Override
        public final Builder annotations(Collection<AutomatedReasoningPolicyAnnotation> annotations) {
            this.annotations = AutomatedReasoningPolicyAnnotationListCopier.copy(annotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(AutomatedReasoningPolicyAnnotation... annotations) {
            annotations(Arrays.asList(annotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(Consumer<AutomatedReasoningPolicyAnnotation.Builder>... annotations) {
            annotations(Stream.of(annotations).map(c -> AutomatedReasoningPolicyAnnotation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAnnotationSetHash() {
            return annotationSetHash;
        }

        public final void setAnnotationSetHash(String annotationSetHash) {
            this.annotationSetHash = annotationSetHash;
        }

        @Override
        public final Builder annotationSetHash(String annotationSetHash) {
            this.annotationSetHash = annotationSetHash;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetAutomatedReasoningPolicyAnnotationsResponse build() {
            return new GetAutomatedReasoningPolicyAnnotationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
