/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutomatedReasoningPolicyBuildWorkflowResponse extends BedrockResponse
        implements
        ToCopyableBuilder<GetAutomatedReasoningPolicyBuildWorkflowResponse.Builder, GetAutomatedReasoningPolicyBuildWorkflowResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(GetAutomatedReasoningPolicyBuildWorkflowResponse::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildWorkflowId").getter(getter(GetAutomatedReasoningPolicyBuildWorkflowResponse::buildWorkflowId))
            .setter(setter(Builder::buildWorkflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildWorkflowId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetAutomatedReasoningPolicyBuildWorkflowResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> BUILD_WORKFLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildWorkflowType")
            .getter(getter(GetAutomatedReasoningPolicyBuildWorkflowResponse::buildWorkflowTypeAsString))
            .setter(setter(Builder::buildWorkflowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildWorkflowType").build()).build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentName").getter(getter(GetAutomatedReasoningPolicyBuildWorkflowResponse::documentName))
            .setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentName").build()).build();

    private static final SdkField<String> DOCUMENT_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentContentType")
            .getter(getter(GetAutomatedReasoningPolicyBuildWorkflowResponse::documentContentTypeAsString))
            .setter(setter(Builder::documentContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentContentType").build())
            .build();

    private static final SdkField<String> DOCUMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentDescription")
            .getter(getter(GetAutomatedReasoningPolicyBuildWorkflowResponse::documentDescription))
            .setter(setter(Builder::documentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentDescription").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetAutomatedReasoningPolicyBuildWorkflowResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetAutomatedReasoningPolicyBuildWorkflowResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            BUILD_WORKFLOW_ID_FIELD, STATUS_FIELD, BUILD_WORKFLOW_TYPE_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_CONTENT_TYPE_FIELD,
            DOCUMENT_DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String buildWorkflowId;

    private final String status;

    private final String buildWorkflowType;

    private final String documentName;

    private final String documentContentType;

    private final String documentDescription;

    private final Instant createdAt;

    private final Instant updatedAt;

    private GetAutomatedReasoningPolicyBuildWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowId = builder.buildWorkflowId;
        this.status = builder.status;
        this.buildWorkflowType = builder.buildWorkflowType;
        this.documentName = builder.documentName;
        this.documentContentType = builder.documentContentType;
        this.documentDescription = builder.documentDescription;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The unique identifier of the build workflow.
     * </p>
     * 
     * @return The unique identifier of the build workflow.
     */
    public final String buildWorkflowId() {
        return buildWorkflowId;
    }

    /**
     * <p>
     * The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED, CANCELLED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedReasoningPolicyBuildWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED, CANCELLED).
     * @see AutomatedReasoningPolicyBuildWorkflowStatus
     */
    public final AutomatedReasoningPolicyBuildWorkflowStatus status() {
        return AutomatedReasoningPolicyBuildWorkflowStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED, CANCELLED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedReasoningPolicyBuildWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED, CANCELLED).
     * @see AutomatedReasoningPolicyBuildWorkflowStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of build workflow being executed (e.g., DOCUMENT_INGESTION, POLICY_REPAIR).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildWorkflowType}
     * will return {@link AutomatedReasoningPolicyBuildWorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #buildWorkflowTypeAsString}.
     * </p>
     * 
     * @return The type of build workflow being executed (e.g., DOCUMENT_INGESTION, POLICY_REPAIR).
     * @see AutomatedReasoningPolicyBuildWorkflowType
     */
    public final AutomatedReasoningPolicyBuildWorkflowType buildWorkflowType() {
        return AutomatedReasoningPolicyBuildWorkflowType.fromValue(buildWorkflowType);
    }

    /**
     * <p>
     * The type of build workflow being executed (e.g., DOCUMENT_INGESTION, POLICY_REPAIR).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildWorkflowType}
     * will return {@link AutomatedReasoningPolicyBuildWorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #buildWorkflowTypeAsString}.
     * </p>
     * 
     * @return The type of build workflow being executed (e.g., DOCUMENT_INGESTION, POLICY_REPAIR).
     * @see AutomatedReasoningPolicyBuildWorkflowType
     */
    public final String buildWorkflowTypeAsString() {
        return buildWorkflowType;
    }

    /**
     * <p>
     * The name of the source document used in the build workflow.
     * </p>
     * 
     * @return The name of the source document used in the build workflow.
     */
    public final String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The content type of the source document (e.g., text/plain, application/pdf).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentContentType} will return
     * {@link AutomatedReasoningPolicyBuildDocumentContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #documentContentTypeAsString}.
     * </p>
     * 
     * @return The content type of the source document (e.g., text/plain, application/pdf).
     * @see AutomatedReasoningPolicyBuildDocumentContentType
     */
    public final AutomatedReasoningPolicyBuildDocumentContentType documentContentType() {
        return AutomatedReasoningPolicyBuildDocumentContentType.fromValue(documentContentType);
    }

    /**
     * <p>
     * The content type of the source document (e.g., text/plain, application/pdf).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentContentType} will return
     * {@link AutomatedReasoningPolicyBuildDocumentContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #documentContentTypeAsString}.
     * </p>
     * 
     * @return The content type of the source document (e.g., text/plain, application/pdf).
     * @see AutomatedReasoningPolicyBuildDocumentContentType
     */
    public final String documentContentTypeAsString() {
        return documentContentType;
    }

    /**
     * <p>
     * A detailed description of the document's content and how it should be used in the policy generation process.
     * </p>
     * 
     * @return A detailed description of the document's content and how it should be used in the policy generation
     *         process.
     */
    public final String documentDescription() {
        return documentDescription;
    }

    /**
     * <p>
     * The timestamp when the build workflow was created.
     * </p>
     * 
     * @return The timestamp when the build workflow was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the build workflow was last updated.
     * </p>
     * 
     * @return The timestamp when the build workflow was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(buildWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(buildWorkflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomatedReasoningPolicyBuildWorkflowResponse)) {
            return false;
        }
        GetAutomatedReasoningPolicyBuildWorkflowResponse other = (GetAutomatedReasoningPolicyBuildWorkflowResponse) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(buildWorkflowId(), other.buildWorkflowId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(buildWorkflowTypeAsString(), other.buildWorkflowTypeAsString())
                && Objects.equals(documentName(), other.documentName())
                && Objects.equals(documentContentTypeAsString(), other.documentContentTypeAsString())
                && Objects.equals(documentDescription(), other.documentDescription())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutomatedReasoningPolicyBuildWorkflowResponse").add("PolicyArn", policyArn())
                .add("BuildWorkflowId", buildWorkflowId()).add("Status", statusAsString())
                .add("BuildWorkflowType", buildWorkflowTypeAsString())
                .add("DocumentName", documentName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DocumentContentType", documentContentTypeAsString())
                .add("DocumentDescription", documentDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "buildWorkflowId":
            return Optional.ofNullable(clazz.cast(buildWorkflowId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "buildWorkflowType":
            return Optional.ofNullable(clazz.cast(buildWorkflowTypeAsString()));
        case "documentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "documentContentType":
            return Optional.ofNullable(clazz.cast(documentContentTypeAsString()));
        case "documentDescription":
            return Optional.ofNullable(clazz.cast(documentDescription()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("buildWorkflowType", BUILD_WORKFLOW_TYPE_FIELD);
        map.put("documentName", DOCUMENT_NAME_FIELD);
        map.put("documentContentType", DOCUMENT_CONTENT_TYPE_FIELD);
        map.put("documentDescription", DOCUMENT_DESCRIPTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutomatedReasoningPolicyBuildWorkflowResponse, T> g) {
        return obj -> g.apply((GetAutomatedReasoningPolicyBuildWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutomatedReasoningPolicyBuildWorkflowResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The unique identifier of the build workflow.
         * </p>
         * 
         * @param buildWorkflowId
         *        The unique identifier of the build workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildWorkflowId(String buildWorkflowId);

        /**
         * <p>
         * The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED, CANCELLED).
         * </p>
         * 
         * @param status
         *        The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED, CANCELLED).
         * @see AutomatedReasoningPolicyBuildWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildWorkflowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED, CANCELLED).
         * </p>
         * 
         * @param status
         *        The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED, CANCELLED).
         * @see AutomatedReasoningPolicyBuildWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildWorkflowStatus
         */
        Builder status(AutomatedReasoningPolicyBuildWorkflowStatus status);

        /**
         * <p>
         * The type of build workflow being executed (e.g., DOCUMENT_INGESTION, POLICY_REPAIR).
         * </p>
         * 
         * @param buildWorkflowType
         *        The type of build workflow being executed (e.g., DOCUMENT_INGESTION, POLICY_REPAIR).
         * @see AutomatedReasoningPolicyBuildWorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildWorkflowType
         */
        Builder buildWorkflowType(String buildWorkflowType);

        /**
         * <p>
         * The type of build workflow being executed (e.g., DOCUMENT_INGESTION, POLICY_REPAIR).
         * </p>
         * 
         * @param buildWorkflowType
         *        The type of build workflow being executed (e.g., DOCUMENT_INGESTION, POLICY_REPAIR).
         * @see AutomatedReasoningPolicyBuildWorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildWorkflowType
         */
        Builder buildWorkflowType(AutomatedReasoningPolicyBuildWorkflowType buildWorkflowType);

        /**
         * <p>
         * The name of the source document used in the build workflow.
         * </p>
         * 
         * @param documentName
         *        The name of the source document used in the build workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The content type of the source document (e.g., text/plain, application/pdf).
         * </p>
         * 
         * @param documentContentType
         *        The content type of the source document (e.g., text/plain, application/pdf).
         * @see AutomatedReasoningPolicyBuildDocumentContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildDocumentContentType
         */
        Builder documentContentType(String documentContentType);

        /**
         * <p>
         * The content type of the source document (e.g., text/plain, application/pdf).
         * </p>
         * 
         * @param documentContentType
         *        The content type of the source document (e.g., text/plain, application/pdf).
         * @see AutomatedReasoningPolicyBuildDocumentContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildDocumentContentType
         */
        Builder documentContentType(AutomatedReasoningPolicyBuildDocumentContentType documentContentType);

        /**
         * <p>
         * A detailed description of the document's content and how it should be used in the policy generation process.
         * </p>
         * 
         * @param documentDescription
         *        A detailed description of the document's content and how it should be used in the policy generation
         *        process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDescription(String documentDescription);

        /**
         * <p>
         * The timestamp when the build workflow was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the build workflow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the build workflow was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the build workflow was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String policyArn;

        private String buildWorkflowId;

        private String status;

        private String buildWorkflowType;

        private String documentName;

        private String documentContentType;

        private String documentDescription;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomatedReasoningPolicyBuildWorkflowResponse model) {
            super(model);
            policyArn(model.policyArn);
            buildWorkflowId(model.buildWorkflowId);
            status(model.status);
            buildWorkflowType(model.buildWorkflowType);
            documentName(model.documentName);
            documentContentType(model.documentContentType);
            documentDescription(model.documentDescription);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowId() {
            return buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutomatedReasoningPolicyBuildWorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getBuildWorkflowType() {
            return buildWorkflowType;
        }

        public final void setBuildWorkflowType(String buildWorkflowType) {
            this.buildWorkflowType = buildWorkflowType;
        }

        @Override
        public final Builder buildWorkflowType(String buildWorkflowType) {
            this.buildWorkflowType = buildWorkflowType;
            return this;
        }

        @Override
        public final Builder buildWorkflowType(AutomatedReasoningPolicyBuildWorkflowType buildWorkflowType) {
            this.buildWorkflowType(buildWorkflowType == null ? null : buildWorkflowType.toString());
            return this;
        }

        public final String getDocumentName() {
            return documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentContentType() {
            return documentContentType;
        }

        public final void setDocumentContentType(String documentContentType) {
            this.documentContentType = documentContentType;
        }

        @Override
        public final Builder documentContentType(String documentContentType) {
            this.documentContentType = documentContentType;
            return this;
        }

        @Override
        public final Builder documentContentType(AutomatedReasoningPolicyBuildDocumentContentType documentContentType) {
            this.documentContentType(documentContentType == null ? null : documentContentType.toString());
            return this;
        }

        public final String getDocumentDescription() {
            return documentDescription;
        }

        public final void setDocumentDescription(String documentDescription) {
            this.documentDescription = documentDescription;
        }

        @Override
        public final Builder documentDescription(String documentDescription) {
            this.documentDescription = documentDescription;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetAutomatedReasoningPolicyBuildWorkflowResponse build() {
            return new GetAutomatedReasoningPolicyBuildWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
