/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter configuration details for the guardrails contextual grounding filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailContextualGroundingFilterConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailContextualGroundingFilterConfig.Builder, GuardrailContextualGroundingFilterConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GuardrailContextualGroundingFilterConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("threshold").getter(getter(GuardrailContextualGroundingFilterConfig::threshold))
            .setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailContextualGroundingFilterConfig::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(GuardrailContextualGroundingFilterConfig::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, THRESHOLD_FIELD,
            ACTION_FIELD, ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Double threshold;

    private final String action;

    private final Boolean enabled;

    private GuardrailContextualGroundingFilterConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.threshold = builder.threshold;
        this.action = builder.action;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The filter details for the guardrails contextual grounding filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailContextualGroundingFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The filter details for the guardrails contextual grounding filter.
     * @see GuardrailContextualGroundingFilterType
     */
    public final GuardrailContextualGroundingFilterType type() {
        return GuardrailContextualGroundingFilterType.fromValue(type);
    }

    /**
     * <p>
     * The filter details for the guardrails contextual grounding filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailContextualGroundingFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The filter details for the guardrails contextual grounding filter.
     * @see GuardrailContextualGroundingFilterType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The threshold details for the guardrails contextual grounding filter.
     * </p>
     * 
     * @return The threshold details for the guardrails contextual grounding filter.
     */
    public final Double threshold() {
        return threshold;
    }

    /**
     * <p>
     * Specifies the action to take when content fails the contextual grounding evaluation. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailContextualGroundingAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when content fails the contextual grounding evaluation. Supported values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailContextualGroundingAction
     */
    public final GuardrailContextualGroundingAction action() {
        return GuardrailContextualGroundingAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies the action to take when content fails the contextual grounding evaluation. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailContextualGroundingAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when content fails the contextual grounding evaluation. Supported values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailContextualGroundingAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Specifies whether to enable contextual grounding evaluation. When disabled, you aren't charged for the
     * evaluation. The evaluation doesn't appear in the response.
     * </p>
     * 
     * @return Specifies whether to enable contextual grounding evaluation. When disabled, you aren't charged for the
     *         evaluation. The evaluation doesn't appear in the response.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContextualGroundingFilterConfig)) {
            return false;
        }
        GuardrailContextualGroundingFilterConfig other = (GuardrailContextualGroundingFilterConfig) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(threshold(), other.threshold())
                && Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailContextualGroundingFilterConfig").add("Type", typeAsString())
                .add("Threshold", threshold()).add("Action", actionAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("threshold", THRESHOLD_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContextualGroundingFilterConfig, T> g) {
        return obj -> g.apply((GuardrailContextualGroundingFilterConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailContextualGroundingFilterConfig> {
        /**
         * <p>
         * The filter details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param type
         *        The filter details for the guardrails contextual grounding filter.
         * @see GuardrailContextualGroundingFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContextualGroundingFilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The filter details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param type
         *        The filter details for the guardrails contextual grounding filter.
         * @see GuardrailContextualGroundingFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContextualGroundingFilterType
         */
        Builder type(GuardrailContextualGroundingFilterType type);

        /**
         * <p>
         * The threshold details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param threshold
         *        The threshold details for the guardrails contextual grounding filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * <p>
         * Specifies the action to take when content fails the contextual grounding evaluation. Supported values
         * include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        Specifies the action to take when content fails the contextual grounding evaluation. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailContextualGroundingAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContextualGroundingAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies the action to take when content fails the contextual grounding evaluation. Supported values
         * include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        Specifies the action to take when content fails the contextual grounding evaluation. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailContextualGroundingAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContextualGroundingAction
         */
        Builder action(GuardrailContextualGroundingAction action);

        /**
         * <p>
         * Specifies whether to enable contextual grounding evaluation. When disabled, you aren't charged for the
         * evaluation. The evaluation doesn't appear in the response.
         * </p>
         * 
         * @param enabled
         *        Specifies whether to enable contextual grounding evaluation. When disabled, you aren't charged for the
         *        evaluation. The evaluation doesn't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Double threshold;

        private String action;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContextualGroundingFilterConfig model) {
            type(model.type);
            threshold(model.threshold);
            action(model.action);
            enabled(model.enabled);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailContextualGroundingFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getThreshold() {
            return threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailContextualGroundingAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public GuardrailContextualGroundingFilterConfig build() {
            return new GuardrailContextualGroundingFilterConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
