/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAutomatedReasoningPoliciesResponse extends BedrockResponse implements
        ToCopyableBuilder<ListAutomatedReasoningPoliciesResponse.Builder, ListAutomatedReasoningPoliciesResponse> {
    private static final SdkField<List<AutomatedReasoningPolicySummary>> AUTOMATED_REASONING_POLICY_SUMMARIES_FIELD = SdkField
            .<List<AutomatedReasoningPolicySummary>> builder(MarshallingType.LIST)
            .memberName("automatedReasoningPolicySummaries")
            .getter(getter(ListAutomatedReasoningPoliciesResponse::automatedReasoningPolicySummaries))
            .setter(setter(Builder::automatedReasoningPolicySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automatedReasoningPolicySummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAutomatedReasoningPoliciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATED_REASONING_POLICY_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AutomatedReasoningPolicySummary> automatedReasoningPolicySummaries;

    private final String nextToken;

    private ListAutomatedReasoningPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.automatedReasoningPolicySummaries = builder.automatedReasoningPolicySummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutomatedReasoningPolicySummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAutomatedReasoningPolicySummaries() {
        return automatedReasoningPolicySummaries != null && !(automatedReasoningPolicySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Automated Reasoning policy summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutomatedReasoningPolicySummaries}
     * method.
     * </p>
     * 
     * @return A list of Automated Reasoning policy summaries.
     */
    public final List<AutomatedReasoningPolicySummary> automatedReasoningPolicySummaries() {
        return automatedReasoningPolicySummaries;
    }

    /**
     * <p>
     * The pagination token to use in a subsequent request to retrieve the next page of results.
     * </p>
     * 
     * @return The pagination token to use in a subsequent request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAutomatedReasoningPolicySummaries() ? automatedReasoningPolicySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomatedReasoningPoliciesResponse)) {
            return false;
        }
        ListAutomatedReasoningPoliciesResponse other = (ListAutomatedReasoningPoliciesResponse) obj;
        return hasAutomatedReasoningPolicySummaries() == other.hasAutomatedReasoningPolicySummaries()
                && Objects.equals(automatedReasoningPolicySummaries(), other.automatedReasoningPolicySummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListAutomatedReasoningPoliciesResponse")
                .add("AutomatedReasoningPolicySummaries",
                        hasAutomatedReasoningPolicySummaries() ? automatedReasoningPolicySummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "automatedReasoningPolicySummaries":
            return Optional.ofNullable(clazz.cast(automatedReasoningPolicySummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("automatedReasoningPolicySummaries", AUTOMATED_REASONING_POLICY_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomatedReasoningPoliciesResponse, T> g) {
        return obj -> g.apply((ListAutomatedReasoningPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAutomatedReasoningPoliciesResponse> {
        /**
         * <p>
         * A list of Automated Reasoning policy summaries.
         * </p>
         * 
         * @param automatedReasoningPolicySummaries
         *        A list of Automated Reasoning policy summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedReasoningPolicySummaries(Collection<AutomatedReasoningPolicySummary> automatedReasoningPolicySummaries);

        /**
         * <p>
         * A list of Automated Reasoning policy summaries.
         * </p>
         * 
         * @param automatedReasoningPolicySummaries
         *        A list of Automated Reasoning policy summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedReasoningPolicySummaries(AutomatedReasoningPolicySummary... automatedReasoningPolicySummaries);

        /**
         * <p>
         * A list of Automated Reasoning policy summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicySummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicySummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #automatedReasoningPolicySummaries(List<AutomatedReasoningPolicySummary>)}.
         * 
         * @param automatedReasoningPolicySummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automatedReasoningPolicySummaries(java.util.Collection<AutomatedReasoningPolicySummary>)
         */
        Builder automatedReasoningPolicySummaries(
                Consumer<AutomatedReasoningPolicySummary.Builder>... automatedReasoningPolicySummaries);

        /**
         * <p>
         * The pagination token to use in a subsequent request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use in a subsequent request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private List<AutomatedReasoningPolicySummary> automatedReasoningPolicySummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomatedReasoningPoliciesResponse model) {
            super(model);
            automatedReasoningPolicySummaries(model.automatedReasoningPolicySummaries);
            nextToken(model.nextToken);
        }

        public final List<AutomatedReasoningPolicySummary.Builder> getAutomatedReasoningPolicySummaries() {
            List<AutomatedReasoningPolicySummary.Builder> result = AutomatedReasoningPolicySummariesCopier
                    .copyToBuilder(this.automatedReasoningPolicySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomatedReasoningPolicySummaries(
                Collection<AutomatedReasoningPolicySummary.BuilderImpl> automatedReasoningPolicySummaries) {
            this.automatedReasoningPolicySummaries = AutomatedReasoningPolicySummariesCopier
                    .copyFromBuilder(automatedReasoningPolicySummaries);
        }

        @Override
        public final Builder automatedReasoningPolicySummaries(
                Collection<AutomatedReasoningPolicySummary> automatedReasoningPolicySummaries) {
            this.automatedReasoningPolicySummaries = AutomatedReasoningPolicySummariesCopier
                    .copy(automatedReasoningPolicySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automatedReasoningPolicySummaries(
                AutomatedReasoningPolicySummary... automatedReasoningPolicySummaries) {
            automatedReasoningPolicySummaries(Arrays.asList(automatedReasoningPolicySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automatedReasoningPolicySummaries(
                Consumer<AutomatedReasoningPolicySummary.Builder>... automatedReasoningPolicySummaries) {
            automatedReasoningPolicySummaries(Stream.of(automatedReasoningPolicySummaries)
                    .map(c -> AutomatedReasoningPolicySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomatedReasoningPoliciesResponse build() {
            return new ListAutomatedReasoningPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
