/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAutomatedReasoningPolicyRequest extends BedrockRequest implements
        ToCopyableBuilder<UpdateAutomatedReasoningPolicyRequest.Builder, UpdateAutomatedReasoningPolicyRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(UpdateAutomatedReasoningPolicyRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDefinition> POLICY_DEFINITION_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinition> builder(MarshallingType.SDK_POJO).memberName("policyDefinition")
            .getter(getter(UpdateAutomatedReasoningPolicyRequest::policyDefinition)).setter(setter(Builder::policyDefinition))
            .constructor(AutomatedReasoningPolicyDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDefinition").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAutomatedReasoningPolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAutomatedReasoningPolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            POLICY_DEFINITION_FIELD, NAME_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final AutomatedReasoningPolicyDefinition policyDefinition;

    private final String name;

    private final String description;

    private UpdateAutomatedReasoningPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.policyDefinition = builder.policyDefinition;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy to update. This must be the ARN of a draft
     * policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy to update. This must be the ARN of a
     *         draft policy.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The updated policy definition containing the formal logic rules, variables, and types.
     * </p>
     * 
     * @return The updated policy definition containing the formal logic rules, variables, and types.
     */
    public final AutomatedReasoningPolicyDefinition policyDefinition() {
        return policyDefinition;
    }

    /**
     * <p>
     * The updated name for the Automated Reasoning policy.
     * </p>
     * 
     * @return The updated name for the Automated Reasoning policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated description for the Automated Reasoning policy.
     * </p>
     * 
     * @return The updated description for the Automated Reasoning policy.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedReasoningPolicyRequest)) {
            return false;
        }
        UpdateAutomatedReasoningPolicyRequest other = (UpdateAutomatedReasoningPolicyRequest) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(policyDefinition(), other.policyDefinition())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAutomatedReasoningPolicyRequest").add("PolicyArn", policyArn())
                .add("PolicyDefinition", policyDefinition())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "policyDefinition":
            return Optional.ofNullable(clazz.cast(policyDefinition()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("policyDefinition", POLICY_DEFINITION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedReasoningPolicyRequest, T> g) {
        return obj -> g.apply((UpdateAutomatedReasoningPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAutomatedReasoningPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy to update. This must be the ARN of a draft
         * policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy to update. This must be the ARN of a
         *        draft policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The updated policy definition containing the formal logic rules, variables, and types.
         * </p>
         * 
         * @param policyDefinition
         *        The updated policy definition containing the formal logic rules, variables, and types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition);

        /**
         * <p>
         * The updated policy definition containing the formal logic rules, variables, and types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinition.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #policyDefinition(AutomatedReasoningPolicyDefinition)}.
         * 
         * @param policyDefinition
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDefinition(AutomatedReasoningPolicyDefinition)
         */
        default Builder policyDefinition(Consumer<AutomatedReasoningPolicyDefinition.Builder> policyDefinition) {
            return policyDefinition(AutomatedReasoningPolicyDefinition.builder().applyMutation(policyDefinition).build());
        }

        /**
         * <p>
         * The updated name for the Automated Reasoning policy.
         * </p>
         * 
         * @param name
         *        The updated name for the Automated Reasoning policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated description for the Automated Reasoning policy.
         * </p>
         * 
         * @param description
         *        The updated description for the Automated Reasoning policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String policyArn;

        private AutomatedReasoningPolicyDefinition policyDefinition;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedReasoningPolicyRequest model) {
            super(model);
            policyArn(model.policyArn);
            policyDefinition(model.policyDefinition);
            name(model.name);
            description(model.description);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final AutomatedReasoningPolicyDefinition.Builder getPolicyDefinition() {
            return policyDefinition != null ? policyDefinition.toBuilder() : null;
        }

        public final void setPolicyDefinition(AutomatedReasoningPolicyDefinition.BuilderImpl policyDefinition) {
            this.policyDefinition = policyDefinition != null ? policyDefinition.build() : null;
        }

        @Override
        public final Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition) {
            this.policyDefinition = policyDefinition;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomatedReasoningPolicyRequest build() {
            return new UpdateAutomatedReasoningPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
