/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAutomatedReasoningPolicyTestCaseRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, DeleteAutomatedReasoningPolicyTestCaseRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(DeleteAutomatedReasoningPolicyTestCaseRequest.getter(DeleteAutomatedReasoningPolicyTestCaseRequest::policyArn)).setter(DeleteAutomatedReasoningPolicyTestCaseRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()}).build();
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseId").getter(DeleteAutomatedReasoningPolicyTestCaseRequest.getter(DeleteAutomatedReasoningPolicyTestCaseRequest::testCaseId)).setter(DeleteAutomatedReasoningPolicyTestCaseRequest.setter(Builder::testCaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("testCaseId").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(DeleteAutomatedReasoningPolicyTestCaseRequest.getter(DeleteAutomatedReasoningPolicyTestCaseRequest::lastUpdatedAt)).setter(DeleteAutomatedReasoningPolicyTestCaseRequest.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, TEST_CASE_ID_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAutomatedReasoningPolicyTestCaseRequest.memberNameToFieldInitializer();
    private final String policyArn;
    private final String testCaseId;
    private final Instant lastUpdatedAt;

    private DeleteAutomatedReasoningPolicyTestCaseRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.testCaseId = builder.testCaseId;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String testCaseId() {
        return this.testCaseId;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAutomatedReasoningPolicyTestCaseRequest)) {
            return false;
        }
        DeleteAutomatedReasoningPolicyTestCaseRequest other = (DeleteAutomatedReasoningPolicyTestCaseRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.testCaseId(), other.testCaseId()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAutomatedReasoningPolicyTestCaseRequest").add("PolicyArn", (Object)this.policyArn()).add("TestCaseId", (Object)this.testCaseId()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "testCaseId": {
                return Optional.ofNullable(clazz.cast(this.testCaseId()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("updatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAutomatedReasoningPolicyTestCaseRequest, T> g) {
        return obj -> g.apply((DeleteAutomatedReasoningPolicyTestCaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String testCaseId;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAutomatedReasoningPolicyTestCaseRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.testCaseId(model.testCaseId);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getTestCaseId() {
            return this.testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAutomatedReasoningPolicyTestCaseRequest build() {
            return new DeleteAutomatedReasoningPolicyTestCaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAutomatedReasoningPolicyTestCaseRequest> {
        public Builder policyArn(String var1);

        public Builder testCaseId(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

