/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.GuardrailAutomatedReasoningPolicyPoliciesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailAutomatedReasoningPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailAutomatedReasoningPolicy> {
    private static final SdkField<List<String>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policies").getter(GuardrailAutomatedReasoningPolicy.getter(GuardrailAutomatedReasoningPolicy::policies)).setter(GuardrailAutomatedReasoningPolicy.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> CONFIDENCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("confidenceThreshold").getter(GuardrailAutomatedReasoningPolicy.getter(GuardrailAutomatedReasoningPolicy::confidenceThreshold)).setter(GuardrailAutomatedReasoningPolicy.setter(Builder::confidenceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD, CONFIDENCE_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailAutomatedReasoningPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> policies;
    private final Double confidenceThreshold;

    private GuardrailAutomatedReasoningPolicy(BuilderImpl builder) {
        this.policies = builder.policies;
        this.confidenceThreshold = builder.confidenceThreshold;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<String> policies() {
        return this.policies;
    }

    public final Double confidenceThreshold() {
        return this.confidenceThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningPolicy)) {
            return false;
        }
        GuardrailAutomatedReasoningPolicy other = (GuardrailAutomatedReasoningPolicy)obj;
        return this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.confidenceThreshold(), other.confidenceThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailAutomatedReasoningPolicy").add("Policies", this.hasPolicies() ? this.policies() : null).add("ConfidenceThreshold", (Object)this.confidenceThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "confidenceThreshold": {
                return Optional.ofNullable(clazz.cast(this.confidenceThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policies", POLICIES_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningPolicy, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> policies = DefaultSdkAutoConstructList.getInstance();
        private Double confidenceThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningPolicy model) {
            this.policies(model.policies);
            this.confidenceThreshold(model.confidenceThreshold);
        }

        public final Collection<String> getPolicies() {
            if (this.policies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policies;
        }

        public final void setPolicies(Collection<String> policies) {
            this.policies = GuardrailAutomatedReasoningPolicyPoliciesListCopier.copy(policies);
        }

        @Override
        public final Builder policies(Collection<String> policies) {
            this.policies = GuardrailAutomatedReasoningPolicyPoliciesListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(String ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        public final Double getConfidenceThreshold() {
            return this.confidenceThreshold;
        }

        public final void setConfidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        public GuardrailAutomatedReasoningPolicy build() {
            return new GuardrailAutomatedReasoningPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailAutomatedReasoningPolicy> {
        public Builder policies(Collection<String> var1);

        public Builder policies(String ... var1);

        public Builder confidenceThreshold(Double var1);
    }
}

