/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationCustomMetricSource;
import software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationCustomMetricsCopier;
import software.amazon.awssdk.services.bedrock.model.CustomMetricEvaluatorModelConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedEvaluationCustomMetricConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedEvaluationCustomMetricConfig> {
    private static final SdkField<List<AutomatedEvaluationCustomMetricSource>> CUSTOM_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customMetrics").getter(AutomatedEvaluationCustomMetricConfig.getter(AutomatedEvaluationCustomMetricConfig::customMetrics)).setter(AutomatedEvaluationCustomMetricConfig.setter(Builder::customMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedEvaluationCustomMetricSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomMetricEvaluatorModelConfig> EVALUATOR_MODEL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("evaluatorModelConfig").getter(AutomatedEvaluationCustomMetricConfig.getter(AutomatedEvaluationCustomMetricConfig::evaluatorModelConfig)).setter(AutomatedEvaluationCustomMetricConfig.setter(Builder::evaluatorModelConfig)).constructor(CustomMetricEvaluatorModelConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorModelConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_METRICS_FIELD, EVALUATOR_MODEL_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedEvaluationCustomMetricConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AutomatedEvaluationCustomMetricSource> customMetrics;
    private final CustomMetricEvaluatorModelConfig evaluatorModelConfig;

    private AutomatedEvaluationCustomMetricConfig(BuilderImpl builder) {
        this.customMetrics = builder.customMetrics;
        this.evaluatorModelConfig = builder.evaluatorModelConfig;
    }

    public final boolean hasCustomMetrics() {
        return this.customMetrics != null && !(this.customMetrics instanceof SdkAutoConstructList);
    }

    public final List<AutomatedEvaluationCustomMetricSource> customMetrics() {
        return this.customMetrics;
    }

    public final CustomMetricEvaluatorModelConfig evaluatorModelConfig() {
        return this.evaluatorModelConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomMetrics() ? this.customMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorModelConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedEvaluationCustomMetricConfig)) {
            return false;
        }
        AutomatedEvaluationCustomMetricConfig other = (AutomatedEvaluationCustomMetricConfig)obj;
        return this.hasCustomMetrics() == other.hasCustomMetrics() && Objects.equals(this.customMetrics(), other.customMetrics()) && Objects.equals(this.evaluatorModelConfig(), other.evaluatorModelConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedEvaluationCustomMetricConfig").add("CustomMetrics", this.hasCustomMetrics() ? this.customMetrics() : null).add("EvaluatorModelConfig", (Object)this.evaluatorModelConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customMetrics": {
                return Optional.ofNullable(clazz.cast(this.customMetrics()));
            }
            case "evaluatorModelConfig": {
                return Optional.ofNullable(clazz.cast(this.evaluatorModelConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customMetrics", CUSTOM_METRICS_FIELD);
        map.put("evaluatorModelConfig", EVALUATOR_MODEL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedEvaluationCustomMetricConfig, T> g) {
        return obj -> g.apply((AutomatedEvaluationCustomMetricConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AutomatedEvaluationCustomMetricSource> customMetrics = DefaultSdkAutoConstructList.getInstance();
        private CustomMetricEvaluatorModelConfig evaluatorModelConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedEvaluationCustomMetricConfig model) {
            this.customMetrics(model.customMetrics);
            this.evaluatorModelConfig(model.evaluatorModelConfig);
        }

        public final List<AutomatedEvaluationCustomMetricSource.Builder> getCustomMetrics() {
            List<AutomatedEvaluationCustomMetricSource.Builder> result = AutomatedEvaluationCustomMetricsCopier.copyToBuilder(this.customMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomMetrics(Collection<AutomatedEvaluationCustomMetricSource.BuilderImpl> customMetrics) {
            this.customMetrics = AutomatedEvaluationCustomMetricsCopier.copyFromBuilder(customMetrics);
        }

        @Override
        public final Builder customMetrics(Collection<AutomatedEvaluationCustomMetricSource> customMetrics) {
            this.customMetrics = AutomatedEvaluationCustomMetricsCopier.copy(customMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMetrics(AutomatedEvaluationCustomMetricSource ... customMetrics) {
            this.customMetrics(Arrays.asList(customMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMetrics(Consumer<AutomatedEvaluationCustomMetricSource.Builder> ... customMetrics) {
            this.customMetrics(Stream.of(customMetrics).map(c -> (AutomatedEvaluationCustomMetricSource)((AutomatedEvaluationCustomMetricSource.Builder)AutomatedEvaluationCustomMetricSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CustomMetricEvaluatorModelConfig.Builder getEvaluatorModelConfig() {
            return this.evaluatorModelConfig != null ? this.evaluatorModelConfig.toBuilder() : null;
        }

        public final void setEvaluatorModelConfig(CustomMetricEvaluatorModelConfig.BuilderImpl evaluatorModelConfig) {
            this.evaluatorModelConfig = evaluatorModelConfig != null ? evaluatorModelConfig.build() : null;
        }

        @Override
        public final Builder evaluatorModelConfig(CustomMetricEvaluatorModelConfig evaluatorModelConfig) {
            this.evaluatorModelConfig = evaluatorModelConfig;
            return this;
        }

        public AutomatedEvaluationCustomMetricConfig build() {
            return new AutomatedEvaluationCustomMetricConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedEvaluationCustomMetricConfig> {
        public Builder customMetrics(Collection<AutomatedEvaluationCustomMetricSource> var1);

        public Builder customMetrics(AutomatedEvaluationCustomMetricSource ... var1);

        public Builder customMetrics(Consumer<AutomatedEvaluationCustomMetricSource.Builder> ... var1);

        public Builder evaluatorModelConfig(CustomMetricEvaluatorModelConfig var1);

        default public Builder evaluatorModelConfig(Consumer<CustomMetricEvaluatorModelConfig.Builder> evaluatorModelConfig) {
            return this.evaluatorModelConfig((CustomMetricEvaluatorModelConfig)((CustomMetricEvaluatorModelConfig.Builder)CustomMetricEvaluatorModelConfig.builder().applyMutation(evaluatorModelConfig)).build());
        }
    }
}

