/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotationListCopier;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutomatedReasoningPolicyAnnotationsRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, UpdateAutomatedReasoningPolicyAnnotationsRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(UpdateAutomatedReasoningPolicyAnnotationsRequest.getter(UpdateAutomatedReasoningPolicyAnnotationsRequest::policyArn)).setter(UpdateAutomatedReasoningPolicyAnnotationsRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()}).build();
    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildWorkflowId").getter(UpdateAutomatedReasoningPolicyAnnotationsRequest.getter(UpdateAutomatedReasoningPolicyAnnotationsRequest::buildWorkflowId)).setter(UpdateAutomatedReasoningPolicyAnnotationsRequest.setter(Builder::buildWorkflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("buildWorkflowId").build()}).build();
    private static final SdkField<List<AutomatedReasoningPolicyAnnotation>> ANNOTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("annotations").getter(UpdateAutomatedReasoningPolicyAnnotationsRequest.getter(UpdateAutomatedReasoningPolicyAnnotationsRequest::annotations)).setter(UpdateAutomatedReasoningPolicyAnnotationsRequest.setter(Builder::annotations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyAnnotation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_UPDATED_ANNOTATION_SET_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedAnnotationSetHash").getter(UpdateAutomatedReasoningPolicyAnnotationsRequest.getter(UpdateAutomatedReasoningPolicyAnnotationsRequest::lastUpdatedAnnotationSetHash)).setter(UpdateAutomatedReasoningPolicyAnnotationsRequest.setter(Builder::lastUpdatedAnnotationSetHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAnnotationSetHash").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, BUILD_WORKFLOW_ID_FIELD, ANNOTATIONS_FIELD, LAST_UPDATED_ANNOTATION_SET_HASH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAutomatedReasoningPolicyAnnotationsRequest.memberNameToFieldInitializer();
    private final String policyArn;
    private final String buildWorkflowId;
    private final List<AutomatedReasoningPolicyAnnotation> annotations;
    private final String lastUpdatedAnnotationSetHash;

    private UpdateAutomatedReasoningPolicyAnnotationsRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowId = builder.buildWorkflowId;
        this.annotations = builder.annotations;
        this.lastUpdatedAnnotationSetHash = builder.lastUpdatedAnnotationSetHash;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String buildWorkflowId() {
        return this.buildWorkflowId;
    }

    public final boolean hasAnnotations() {
        return this.annotations != null && !(this.annotations instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyAnnotation> annotations() {
        return this.annotations;
    }

    public final String lastUpdatedAnnotationSetHash() {
        return this.lastUpdatedAnnotationSetHash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotations() ? this.annotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAnnotationSetHash());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedReasoningPolicyAnnotationsRequest)) {
            return false;
        }
        UpdateAutomatedReasoningPolicyAnnotationsRequest other = (UpdateAutomatedReasoningPolicyAnnotationsRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.buildWorkflowId(), other.buildWorkflowId()) && this.hasAnnotations() == other.hasAnnotations() && Objects.equals(this.annotations(), other.annotations()) && Objects.equals(this.lastUpdatedAnnotationSetHash(), other.lastUpdatedAnnotationSetHash());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAutomatedReasoningPolicyAnnotationsRequest").add("PolicyArn", (Object)this.policyArn()).add("BuildWorkflowId", (Object)this.buildWorkflowId()).add("Annotations", this.hasAnnotations() ? this.annotations() : null).add("LastUpdatedAnnotationSetHash", (Object)this.lastUpdatedAnnotationSetHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "buildWorkflowId": {
                return Optional.ofNullable(clazz.cast(this.buildWorkflowId()));
            }
            case "annotations": {
                return Optional.ofNullable(clazz.cast(this.annotations()));
            }
            case "lastUpdatedAnnotationSetHash": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAnnotationSetHash()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        map.put("annotations", ANNOTATIONS_FIELD);
        map.put("lastUpdatedAnnotationSetHash", LAST_UPDATED_ANNOTATION_SET_HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedReasoningPolicyAnnotationsRequest, T> g) {
        return obj -> g.apply((UpdateAutomatedReasoningPolicyAnnotationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String buildWorkflowId;
        private List<AutomatedReasoningPolicyAnnotation> annotations = DefaultSdkAutoConstructList.getInstance();
        private String lastUpdatedAnnotationSetHash;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedReasoningPolicyAnnotationsRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.buildWorkflowId(model.buildWorkflowId);
            this.annotations(model.annotations);
            this.lastUpdatedAnnotationSetHash(model.lastUpdatedAnnotationSetHash);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowId() {
            return this.buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        public final List<AutomatedReasoningPolicyAnnotation.Builder> getAnnotations() {
            List<AutomatedReasoningPolicyAnnotation.Builder> result = AutomatedReasoningPolicyAnnotationListCopier.copyToBuilder(this.annotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotations(Collection<AutomatedReasoningPolicyAnnotation.BuilderImpl> annotations) {
            this.annotations = AutomatedReasoningPolicyAnnotationListCopier.copyFromBuilder(annotations);
        }

        @Override
        public final Builder annotations(Collection<AutomatedReasoningPolicyAnnotation> annotations) {
            this.annotations = AutomatedReasoningPolicyAnnotationListCopier.copy(annotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(AutomatedReasoningPolicyAnnotation ... annotations) {
            this.annotations(Arrays.asList(annotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(Consumer<AutomatedReasoningPolicyAnnotation.Builder> ... annotations) {
            this.annotations(Stream.of(annotations).map(c -> (AutomatedReasoningPolicyAnnotation)((AutomatedReasoningPolicyAnnotation.Builder)AutomatedReasoningPolicyAnnotation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLastUpdatedAnnotationSetHash() {
            return this.lastUpdatedAnnotationSetHash;
        }

        public final void setLastUpdatedAnnotationSetHash(String lastUpdatedAnnotationSetHash) {
            this.lastUpdatedAnnotationSetHash = lastUpdatedAnnotationSetHash;
        }

        @Override
        public final Builder lastUpdatedAnnotationSetHash(String lastUpdatedAnnotationSetHash) {
            this.lastUpdatedAnnotationSetHash = lastUpdatedAnnotationSetHash;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomatedReasoningPolicyAnnotationsRequest build() {
            return new UpdateAutomatedReasoningPolicyAnnotationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAutomatedReasoningPolicyAnnotationsRequest> {
        public Builder policyArn(String var1);

        public Builder buildWorkflowId(String var1);

        public Builder annotations(Collection<AutomatedReasoningPolicyAnnotation> var1);

        public Builder annotations(AutomatedReasoningPolicyAnnotation ... var1);

        public Builder annotations(Consumer<AutomatedReasoningPolicyAnnotation.Builder> ... var1);

        public Builder lastUpdatedAnnotationSetHash(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

