/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single step in the policy build process, containing context about what was being processed and any
 * messages or results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyBuildStep implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyBuildStep.Builder, AutomatedReasoningPolicyBuildStep> {
    private static final SdkField<AutomatedReasoningPolicyBuildStepContext> CONTEXT_FIELD = SdkField
            .<AutomatedReasoningPolicyBuildStepContext> builder(MarshallingType.SDK_POJO).memberName("context")
            .getter(getter(AutomatedReasoningPolicyBuildStep::context)).setter(setter(Builder::context))
            .constructor(AutomatedReasoningPolicyBuildStepContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDefinitionElement> PRIOR_ELEMENT_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinitionElement> builder(MarshallingType.SDK_POJO).memberName("priorElement")
            .getter(getter(AutomatedReasoningPolicyBuildStep::priorElement)).setter(setter(Builder::priorElement))
            .constructor(AutomatedReasoningPolicyDefinitionElement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priorElement").build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyBuildStepMessage>> MESSAGES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyBuildStepMessage>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(AutomatedReasoningPolicyBuildStep::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyBuildStepMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyBuildStepMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_FIELD,
            PRIOR_ELEMENT_FIELD, MESSAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyBuildStepContext context;

    private final AutomatedReasoningPolicyDefinitionElement priorElement;

    private final List<AutomatedReasoningPolicyBuildStepMessage> messages;

    private AutomatedReasoningPolicyBuildStep(BuilderImpl builder) {
        this.context = builder.context;
        this.priorElement = builder.priorElement;
        this.messages = builder.messages;
    }

    /**
     * <p>
     * Contextual information about what was being processed during this build step, such as the type of operation or
     * the source material being analyzed.
     * </p>
     * 
     * @return Contextual information about what was being processed during this build step, such as the type of
     *         operation or the source material being analyzed.
     */
    public final AutomatedReasoningPolicyBuildStepContext context() {
        return context;
    }

    /**
     * <p>
     * Reference to the previous element or step in the build process, helping to trace the sequence of operations.
     * </p>
     * 
     * @return Reference to the previous element or step in the build process, helping to trace the sequence of
     *         operations.
     */
    public final AutomatedReasoningPolicyDefinitionElement priorElement() {
        return priorElement;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of messages generated during this build step, including informational messages, warnings, and error
     * details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return A list of messages generated during this build step, including informational messages, warnings, and
     *         error details.
     */
    public final List<AutomatedReasoningPolicyBuildStepMessage> messages() {
        return messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(priorElement());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildStep)) {
            return false;
        }
        AutomatedReasoningPolicyBuildStep other = (AutomatedReasoningPolicyBuildStep) obj;
        return Objects.equals(context(), other.context()) && Objects.equals(priorElement(), other.priorElement())
                && hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyBuildStep").add("Context", context())
                .add("PriorElement", priorElement()).add("Messages", hasMessages() ? messages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "priorElement":
            return Optional.ofNullable(clazz.cast(priorElement()));
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("context", CONTEXT_FIELD);
        map.put("priorElement", PRIOR_ELEMENT_FIELD);
        map.put("messages", MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildStep, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyBuildStep> {
        /**
         * <p>
         * Contextual information about what was being processed during this build step, such as the type of operation
         * or the source material being analyzed.
         * </p>
         * 
         * @param context
         *        Contextual information about what was being processed during this build step, such as the type of
         *        operation or the source material being analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(AutomatedReasoningPolicyBuildStepContext context);

        /**
         * <p>
         * Contextual information about what was being processed during this build step, such as the type of operation
         * or the source material being analyzed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyBuildStepContext.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyBuildStepContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyBuildStepContext.Builder#build()} is
         * called immediately and its result is passed to {@link #context(AutomatedReasoningPolicyBuildStepContext)}.
         * 
         * @param context
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyBuildStepContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #context(AutomatedReasoningPolicyBuildStepContext)
         */
        default Builder context(Consumer<AutomatedReasoningPolicyBuildStepContext.Builder> context) {
            return context(AutomatedReasoningPolicyBuildStepContext.builder().applyMutation(context).build());
        }

        /**
         * <p>
         * Reference to the previous element or step in the build process, helping to trace the sequence of operations.
         * </p>
         * 
         * @param priorElement
         *        Reference to the previous element or step in the build process, helping to trace the sequence of
         *        operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priorElement(AutomatedReasoningPolicyDefinitionElement priorElement);

        /**
         * <p>
         * Reference to the previous element or step in the build process, helping to trace the sequence of operations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinitionElement.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinitionElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinitionElement.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #priorElement(AutomatedReasoningPolicyDefinitionElement)}.
         * 
         * @param priorElement
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinitionElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #priorElement(AutomatedReasoningPolicyDefinitionElement)
         */
        default Builder priorElement(Consumer<AutomatedReasoningPolicyDefinitionElement.Builder> priorElement) {
            return priorElement(AutomatedReasoningPolicyDefinitionElement.builder().applyMutation(priorElement).build());
        }

        /**
         * <p>
         * A list of messages generated during this build step, including informational messages, warnings, and error
         * details.
         * </p>
         * 
         * @param messages
         *        A list of messages generated during this build step, including informational messages, warnings, and
         *        error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<AutomatedReasoningPolicyBuildStepMessage> messages);

        /**
         * <p>
         * A list of messages generated during this build step, including informational messages, warnings, and error
         * details.
         * </p>
         * 
         * @param messages
         *        A list of messages generated during this build step, including informational messages, warnings, and
         *        error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(AutomatedReasoningPolicyBuildStepMessage... messages);

        /**
         * <p>
         * A list of messages generated during this build step, including informational messages, warnings, and error
         * details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStepMessage.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStepMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStepMessage.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #messages(List<AutomatedReasoningPolicyBuildStepMessage>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStepMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<AutomatedReasoningPolicyBuildStepMessage>)
         */
        Builder messages(Consumer<AutomatedReasoningPolicyBuildStepMessage.Builder>... messages);
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyBuildStepContext context;

        private AutomatedReasoningPolicyDefinitionElement priorElement;

        private List<AutomatedReasoningPolicyBuildStepMessage> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildStep model) {
            context(model.context);
            priorElement(model.priorElement);
            messages(model.messages);
        }

        public final AutomatedReasoningPolicyBuildStepContext.Builder getContext() {
            return context != null ? context.toBuilder() : null;
        }

        public final void setContext(AutomatedReasoningPolicyBuildStepContext.BuilderImpl context) {
            this.context = context != null ? context.build() : null;
        }

        @Override
        public final Builder context(AutomatedReasoningPolicyBuildStepContext context) {
            this.context = context;
            return this;
        }

        public final AutomatedReasoningPolicyDefinitionElement.Builder getPriorElement() {
            return priorElement != null ? priorElement.toBuilder() : null;
        }

        public final void setPriorElement(AutomatedReasoningPolicyDefinitionElement.BuilderImpl priorElement) {
            this.priorElement = priorElement != null ? priorElement.build() : null;
        }

        @Override
        public final Builder priorElement(AutomatedReasoningPolicyDefinitionElement priorElement) {
            this.priorElement = priorElement;
            return this;
        }

        public final List<AutomatedReasoningPolicyBuildStepMessage.Builder> getMessages() {
            List<AutomatedReasoningPolicyBuildStepMessage.Builder> result = AutomatedReasoningPolicyBuildStepMessageListCopier
                    .copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<AutomatedReasoningPolicyBuildStepMessage.BuilderImpl> messages) {
            this.messages = AutomatedReasoningPolicyBuildStepMessageListCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<AutomatedReasoningPolicyBuildStepMessage> messages) {
            this.messages = AutomatedReasoningPolicyBuildStepMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AutomatedReasoningPolicyBuildStepMessage... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<AutomatedReasoningPolicyBuildStepMessage.Builder>... messages) {
            messages(Stream.of(messages).map(c -> AutomatedReasoningPolicyBuildStepMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedReasoningPolicyBuildStep build() {
            return new AutomatedReasoningPolicyBuildStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
