/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides context about what type of operation was being performed during a build step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyBuildStepContext implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyBuildStepContext.Builder, AutomatedReasoningPolicyBuildStepContext> {
    private static final SdkField<AutomatedReasoningPolicyPlanning> PLANNING_FIELD = SdkField
            .<AutomatedReasoningPolicyPlanning> builder(MarshallingType.SDK_POJO).memberName("planning")
            .getter(getter(AutomatedReasoningPolicyBuildStepContext::planning)).setter(setter(Builder::planning))
            .constructor(AutomatedReasoningPolicyPlanning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planning").build()).build();

    private static final SdkField<AutomatedReasoningPolicyMutation> MUTATION_FIELD = SdkField
            .<AutomatedReasoningPolicyMutation> builder(MarshallingType.SDK_POJO).memberName("mutation")
            .getter(getter(AutomatedReasoningPolicyBuildStepContext::mutation)).setter(setter(Builder::mutation))
            .constructor(AutomatedReasoningPolicyMutation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PLANNING_FIELD, MUTATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyPlanning planning;

    private final AutomatedReasoningPolicyMutation mutation;

    private final Type type;

    private AutomatedReasoningPolicyBuildStepContext(BuilderImpl builder) {
        this.planning = builder.planning;
        this.mutation = builder.mutation;
        this.type = builder.type;
    }

    /**
     * <p>
     * Indicates that this build step was part of the planning phase, where the system determines what operations to
     * perform.
     * </p>
     * 
     * @return Indicates that this build step was part of the planning phase, where the system determines what
     *         operations to perform.
     */
    public final AutomatedReasoningPolicyPlanning planning() {
        return planning;
    }

    /**
     * <p>
     * Indicates that this build step involved modifying the policy structure, such as adding or updating rules,
     * variables, or types.
     * </p>
     * 
     * @return Indicates that this build step involved modifying the policy structure, such as adding or updating rules,
     *         variables, or types.
     */
    public final AutomatedReasoningPolicyMutation mutation() {
        return mutation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(planning());
        hashCode = 31 * hashCode + Objects.hashCode(mutation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildStepContext)) {
            return false;
        }
        AutomatedReasoningPolicyBuildStepContext other = (AutomatedReasoningPolicyBuildStepContext) obj;
        return Objects.equals(planning(), other.planning()) && Objects.equals(mutation(), other.mutation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyBuildStepContext").add("Planning", planning())
                .add("Mutation", mutation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "planning":
            return Optional.ofNullable(clazz.cast(planning()));
        case "mutation":
            return Optional.ofNullable(clazz.cast(mutation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #planning()} initialized to the given value.
     *
     * <p>
     * Indicates that this build step was part of the planning phase, where the system determines what operations to
     * perform.
     * </p>
     * 
     * @param planning
     *        Indicates that this build step was part of the planning phase, where the system determines what operations
     *        to perform.
     */
    public static AutomatedReasoningPolicyBuildStepContext fromPlanning(AutomatedReasoningPolicyPlanning planning) {
        return builder().planning(planning).build();
    }

    /**
     * Create an instance of this class with {@link #planning()} initialized to the given value.
     *
     * <p>
     * Indicates that this build step was part of the planning phase, where the system determines what operations to
     * perform.
     * </p>
     * 
     * @param planning
     *        Indicates that this build step was part of the planning phase, where the system determines what operations
     *        to perform.
     */
    public static AutomatedReasoningPolicyBuildStepContext fromPlanning(
            Consumer<AutomatedReasoningPolicyPlanning.Builder> planning) {
        AutomatedReasoningPolicyPlanning.Builder builder = AutomatedReasoningPolicyPlanning.builder();
        planning.accept(builder);
        return fromPlanning(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mutation()} initialized to the given value.
     *
     * <p>
     * Indicates that this build step involved modifying the policy structure, such as adding or updating rules,
     * variables, or types.
     * </p>
     * 
     * @param mutation
     *        Indicates that this build step involved modifying the policy structure, such as adding or updating rules,
     *        variables, or types.
     */
    public static AutomatedReasoningPolicyBuildStepContext fromMutation(AutomatedReasoningPolicyMutation mutation) {
        return builder().mutation(mutation).build();
    }

    /**
     * Create an instance of this class with {@link #mutation()} initialized to the given value.
     *
     * <p>
     * Indicates that this build step involved modifying the policy structure, such as adding or updating rules,
     * variables, or types.
     * </p>
     * 
     * @param mutation
     *        Indicates that this build step involved modifying the policy structure, such as adding or updating rules,
     *        variables, or types.
     */
    public static AutomatedReasoningPolicyBuildStepContext fromMutation(
            Consumer<AutomatedReasoningPolicyMutation.Builder> mutation) {
        AutomatedReasoningPolicyMutation.Builder builder = AutomatedReasoningPolicyMutation.builder();
        mutation.accept(builder);
        return fromMutation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("planning", PLANNING_FIELD);
        map.put("mutation", MUTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildStepContext, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildStepContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyBuildStepContext> {
        /**
         * <p>
         * Indicates that this build step was part of the planning phase, where the system determines what operations to
         * perform.
         * </p>
         * 
         * @param planning
         *        Indicates that this build step was part of the planning phase, where the system determines what
         *        operations to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planning(AutomatedReasoningPolicyPlanning planning);

        /**
         * <p>
         * Indicates that this build step was part of the planning phase, where the system determines what operations to
         * perform.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedReasoningPolicyPlanning.Builder}
         * avoiding the need to create one manually via {@link AutomatedReasoningPolicyPlanning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyPlanning.Builder#build()} is called
         * immediately and its result is passed to {@link #planning(AutomatedReasoningPolicyPlanning)}.
         * 
         * @param planning
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyPlanning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #planning(AutomatedReasoningPolicyPlanning)
         */
        default Builder planning(Consumer<AutomatedReasoningPolicyPlanning.Builder> planning) {
            return planning(AutomatedReasoningPolicyPlanning.builder().applyMutation(planning).build());
        }

        /**
         * <p>
         * Indicates that this build step involved modifying the policy structure, such as adding or updating rules,
         * variables, or types.
         * </p>
         * 
         * @param mutation
         *        Indicates that this build step involved modifying the policy structure, such as adding or updating
         *        rules, variables, or types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutation(AutomatedReasoningPolicyMutation mutation);

        /**
         * <p>
         * Indicates that this build step involved modifying the policy structure, such as adding or updating rules,
         * variables, or types.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedReasoningPolicyMutation.Builder}
         * avoiding the need to create one manually via {@link AutomatedReasoningPolicyMutation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyMutation.Builder#build()} is called
         * immediately and its result is passed to {@link #mutation(AutomatedReasoningPolicyMutation)}.
         * 
         * @param mutation
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyMutation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mutation(AutomatedReasoningPolicyMutation)
         */
        default Builder mutation(Consumer<AutomatedReasoningPolicyMutation.Builder> mutation) {
            return mutation(AutomatedReasoningPolicyMutation.builder().applyMutation(mutation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyPlanning planning;

        private AutomatedReasoningPolicyMutation mutation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildStepContext model) {
            planning(model.planning);
            mutation(model.mutation);
        }

        public final AutomatedReasoningPolicyPlanning.Builder getPlanning() {
            return planning != null ? planning.toBuilder() : null;
        }

        public final void setPlanning(AutomatedReasoningPolicyPlanning.BuilderImpl planning) {
            Object oldValue = this.planning;
            this.planning = planning != null ? planning.build() : null;
            handleUnionValueChange(Type.PLANNING, oldValue, this.planning);
        }

        @Override
        public final Builder planning(AutomatedReasoningPolicyPlanning planning) {
            Object oldValue = this.planning;
            this.planning = planning;
            handleUnionValueChange(Type.PLANNING, oldValue, this.planning);
            return this;
        }

        public final AutomatedReasoningPolicyMutation.Builder getMutation() {
            return mutation != null ? mutation.toBuilder() : null;
        }

        public final void setMutation(AutomatedReasoningPolicyMutation.BuilderImpl mutation) {
            Object oldValue = this.mutation;
            this.mutation = mutation != null ? mutation.build() : null;
            handleUnionValueChange(Type.MUTATION, oldValue, this.mutation);
        }

        @Override
        public final Builder mutation(AutomatedReasoningPolicyMutation mutation) {
            Object oldValue = this.mutation;
            this.mutation = mutation;
            handleUnionValueChange(Type.MUTATION, oldValue, this.mutation);
            return this;
        }

        @Override
        public AutomatedReasoningPolicyBuildStepContext build() {
            return new AutomatedReasoningPolicyBuildStepContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutomatedReasoningPolicyBuildStepContext#type()
     */
    public enum Type {
        PLANNING,

        MUTATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
