/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of testing an Automated Reasoning policy against various scenarios and validation checks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyTestResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyTestResult.Builder, AutomatedReasoningPolicyTestResult> {
    private static final SdkField<AutomatedReasoningPolicyTestCase> TEST_CASE_FIELD = SdkField
            .<AutomatedReasoningPolicyTestCase> builder(MarshallingType.SDK_POJO).memberName("testCase")
            .getter(getter(AutomatedReasoningPolicyTestResult::testCase)).setter(setter(Builder::testCase))
            .constructor(AutomatedReasoningPolicyTestCase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCase").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(AutomatedReasoningPolicyTestResult::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<String> TEST_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testRunStatus").getter(getter(AutomatedReasoningPolicyTestResult::testRunStatusAsString))
            .setter(setter(Builder::testRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunStatus").build()).build();

    private static final SdkField<List<AutomatedReasoningCheckFinding>> TEST_FINDINGS_FIELD = SdkField
            .<List<AutomatedReasoningCheckFinding>> builder(MarshallingType.LIST)
            .memberName("testFindings")
            .getter(getter(AutomatedReasoningPolicyTestResult::testFindings))
            .setter(setter(Builder::testFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningCheckFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningCheckFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEST_RUN_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testRunResult").getter(getter(AutomatedReasoningPolicyTestResult::testRunResultAsString))
            .setter(setter(Builder::testRunResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunResult").build()).build();

    private static final SdkField<String> AGGREGATED_TEST_FINDINGS_RESULT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("aggregatedTestFindingsResult")
            .getter(getter(AutomatedReasoningPolicyTestResult::aggregatedTestFindingsResultAsString))
            .setter(setter(Builder::aggregatedTestFindingsResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedTestFindingsResult")
                    .build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AutomatedReasoningPolicyTestResult::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_FIELD,
            POLICY_ARN_FIELD, TEST_RUN_STATUS_FIELD, TEST_FINDINGS_FIELD, TEST_RUN_RESULT_FIELD,
            AGGREGATED_TEST_FINDINGS_RESULT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyTestCase testCase;

    private final String policyArn;

    private final String testRunStatus;

    private final List<AutomatedReasoningCheckFinding> testFindings;

    private final String testRunResult;

    private final String aggregatedTestFindingsResult;

    private final Instant updatedAt;

    private AutomatedReasoningPolicyTestResult(BuilderImpl builder) {
        this.testCase = builder.testCase;
        this.policyArn = builder.policyArn;
        this.testRunStatus = builder.testRunStatus;
        this.testFindings = builder.testFindings;
        this.testRunResult = builder.testRunResult;
        this.aggregatedTestFindingsResult = builder.aggregatedTestFindingsResult;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The test case that was executed, including the input content, expected results, and configuration parameters used
     * during validation.
     * </p>
     * 
     * @return The test case that was executed, including the input content, expected results, and configuration
     *         parameters used during validation.
     */
    public final AutomatedReasoningPolicyTestCase testCase() {
        return testCase;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy that was tested.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy that was tested.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The overall status of the test run (e.g., COMPLETED, FAILED, IN_PROGRESS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testRunStatus}
     * will return {@link AutomatedReasoningPolicyTestRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #testRunStatusAsString}.
     * </p>
     * 
     * @return The overall status of the test run (e.g., COMPLETED, FAILED, IN_PROGRESS).
     * @see AutomatedReasoningPolicyTestRunStatus
     */
    public final AutomatedReasoningPolicyTestRunStatus testRunStatus() {
        return AutomatedReasoningPolicyTestRunStatus.fromValue(testRunStatus);
    }

    /**
     * <p>
     * The overall status of the test run (e.g., COMPLETED, FAILED, IN_PROGRESS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testRunStatus}
     * will return {@link AutomatedReasoningPolicyTestRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #testRunStatusAsString}.
     * </p>
     * 
     * @return The overall status of the test run (e.g., COMPLETED, FAILED, IN_PROGRESS).
     * @see AutomatedReasoningPolicyTestRunStatus
     */
    public final String testRunStatusAsString() {
        return testRunStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestFindings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTestFindings() {
        return testFindings != null && !(testFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Detailed findings from the test run, including any issues, violations, or unexpected behaviors discovered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestFindings} method.
     * </p>
     * 
     * @return Detailed findings from the test run, including any issues, violations, or unexpected behaviors
     *         discovered.
     */
    public final List<AutomatedReasoningCheckFinding> testFindings() {
        return testFindings;
    }

    /**
     * <p>
     * The overall result of the test run, indicating whether the policy passed or failed validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testRunResult}
     * will return {@link AutomatedReasoningPolicyTestRunResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #testRunResultAsString}.
     * </p>
     * 
     * @return The overall result of the test run, indicating whether the policy passed or failed validation.
     * @see AutomatedReasoningPolicyTestRunResult
     */
    public final AutomatedReasoningPolicyTestRunResult testRunResult() {
        return AutomatedReasoningPolicyTestRunResult.fromValue(testRunResult);
    }

    /**
     * <p>
     * The overall result of the test run, indicating whether the policy passed or failed validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testRunResult}
     * will return {@link AutomatedReasoningPolicyTestRunResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #testRunResultAsString}.
     * </p>
     * 
     * @return The overall result of the test run, indicating whether the policy passed or failed validation.
     * @see AutomatedReasoningPolicyTestRunResult
     */
    public final String testRunResultAsString() {
        return testRunResult;
    }

    /**
     * <p>
     * A summary of all test findings, aggregated to provide an overall assessment of policy quality and correctness.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregatedTestFindingsResult} will return {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #aggregatedTestFindingsResultAsString}.
     * </p>
     * 
     * @return A summary of all test findings, aggregated to provide an overall assessment of policy quality and
     *         correctness.
     * @see AutomatedReasoningCheckResult
     */
    public final AutomatedReasoningCheckResult aggregatedTestFindingsResult() {
        return AutomatedReasoningCheckResult.fromValue(aggregatedTestFindingsResult);
    }

    /**
     * <p>
     * A summary of all test findings, aggregated to provide an overall assessment of policy quality and correctness.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregatedTestFindingsResult} will return {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #aggregatedTestFindingsResultAsString}.
     * </p>
     * 
     * @return A summary of all test findings, aggregated to provide an overall assessment of policy quality and
     *         correctness.
     * @see AutomatedReasoningCheckResult
     */
    public final String aggregatedTestFindingsResultAsString() {
        return aggregatedTestFindingsResult;
    }

    /**
     * <p>
     * The timestamp when the test results were last updated.
     * </p>
     * 
     * @return The timestamp when the test results were last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testCase());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(testRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTestFindings() ? testFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(testRunResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregatedTestFindingsResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyTestResult)) {
            return false;
        }
        AutomatedReasoningPolicyTestResult other = (AutomatedReasoningPolicyTestResult) obj;
        return Objects.equals(testCase(), other.testCase()) && Objects.equals(policyArn(), other.policyArn())
                && Objects.equals(testRunStatusAsString(), other.testRunStatusAsString())
                && hasTestFindings() == other.hasTestFindings() && Objects.equals(testFindings(), other.testFindings())
                && Objects.equals(testRunResultAsString(), other.testRunResultAsString())
                && Objects.equals(aggregatedTestFindingsResultAsString(), other.aggregatedTestFindingsResultAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyTestResult").add("TestCase", testCase()).add("PolicyArn", policyArn())
                .add("TestRunStatus", testRunStatusAsString()).add("TestFindings", hasTestFindings() ? testFindings() : null)
                .add("TestRunResult", testRunResultAsString())
                .add("AggregatedTestFindingsResult", aggregatedTestFindingsResultAsString()).add("UpdatedAt", updatedAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCase":
            return Optional.ofNullable(clazz.cast(testCase()));
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "testRunStatus":
            return Optional.ofNullable(clazz.cast(testRunStatusAsString()));
        case "testFindings":
            return Optional.ofNullable(clazz.cast(testFindings()));
        case "testRunResult":
            return Optional.ofNullable(clazz.cast(testRunResultAsString()));
        case "aggregatedTestFindingsResult":
            return Optional.ofNullable(clazz.cast(aggregatedTestFindingsResultAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testCase", TEST_CASE_FIELD);
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("testRunStatus", TEST_RUN_STATUS_FIELD);
        map.put("testFindings", TEST_FINDINGS_FIELD);
        map.put("testRunResult", TEST_RUN_RESULT_FIELD);
        map.put("aggregatedTestFindingsResult", AGGREGATED_TEST_FINDINGS_RESULT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyTestResult, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyTestResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyTestResult> {
        /**
         * <p>
         * The test case that was executed, including the input content, expected results, and configuration parameters
         * used during validation.
         * </p>
         * 
         * @param testCase
         *        The test case that was executed, including the input content, expected results, and configuration
         *        parameters used during validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCase(AutomatedReasoningPolicyTestCase testCase);

        /**
         * <p>
         * The test case that was executed, including the input content, expected results, and configuration parameters
         * used during validation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedReasoningPolicyTestCase.Builder}
         * avoiding the need to create one manually via {@link AutomatedReasoningPolicyTestCase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyTestCase.Builder#build()} is called
         * immediately and its result is passed to {@link #testCase(AutomatedReasoningPolicyTestCase)}.
         * 
         * @param testCase
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyTestCase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testCase(AutomatedReasoningPolicyTestCase)
         */
        default Builder testCase(Consumer<AutomatedReasoningPolicyTestCase.Builder> testCase) {
            return testCase(AutomatedReasoningPolicyTestCase.builder().applyMutation(testCase).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy that was tested.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy that was tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The overall status of the test run (e.g., COMPLETED, FAILED, IN_PROGRESS).
         * </p>
         * 
         * @param testRunStatus
         *        The overall status of the test run (e.g., COMPLETED, FAILED, IN_PROGRESS).
         * @see AutomatedReasoningPolicyTestRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyTestRunStatus
         */
        Builder testRunStatus(String testRunStatus);

        /**
         * <p>
         * The overall status of the test run (e.g., COMPLETED, FAILED, IN_PROGRESS).
         * </p>
         * 
         * @param testRunStatus
         *        The overall status of the test run (e.g., COMPLETED, FAILED, IN_PROGRESS).
         * @see AutomatedReasoningPolicyTestRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyTestRunStatus
         */
        Builder testRunStatus(AutomatedReasoningPolicyTestRunStatus testRunStatus);

        /**
         * <p>
         * Detailed findings from the test run, including any issues, violations, or unexpected behaviors discovered.
         * </p>
         * 
         * @param testFindings
         *        Detailed findings from the test run, including any issues, violations, or unexpected behaviors
         *        discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testFindings(Collection<AutomatedReasoningCheckFinding> testFindings);

        /**
         * <p>
         * Detailed findings from the test run, including any issues, violations, or unexpected behaviors discovered.
         * </p>
         * 
         * @param testFindings
         *        Detailed findings from the test run, including any issues, violations, or unexpected behaviors
         *        discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testFindings(AutomatedReasoningCheckFinding... testFindings);

        /**
         * <p>
         * Detailed findings from the test run, including any issues, violations, or unexpected behaviors discovered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckFinding.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckFinding.Builder#build()} is
         * called immediately and its result is passed to {@link #testFindings(List<AutomatedReasoningCheckFinding>)}.
         * 
         * @param testFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testFindings(java.util.Collection<AutomatedReasoningCheckFinding>)
         */
        Builder testFindings(Consumer<AutomatedReasoningCheckFinding.Builder>... testFindings);

        /**
         * <p>
         * The overall result of the test run, indicating whether the policy passed or failed validation.
         * </p>
         * 
         * @param testRunResult
         *        The overall result of the test run, indicating whether the policy passed or failed validation.
         * @see AutomatedReasoningPolicyTestRunResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyTestRunResult
         */
        Builder testRunResult(String testRunResult);

        /**
         * <p>
         * The overall result of the test run, indicating whether the policy passed or failed validation.
         * </p>
         * 
         * @param testRunResult
         *        The overall result of the test run, indicating whether the policy passed or failed validation.
         * @see AutomatedReasoningPolicyTestRunResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyTestRunResult
         */
        Builder testRunResult(AutomatedReasoningPolicyTestRunResult testRunResult);

        /**
         * <p>
         * A summary of all test findings, aggregated to provide an overall assessment of policy quality and
         * correctness.
         * </p>
         * 
         * @param aggregatedTestFindingsResult
         *        A summary of all test findings, aggregated to provide an overall assessment of policy quality and
         *        correctness.
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder aggregatedTestFindingsResult(String aggregatedTestFindingsResult);

        /**
         * <p>
         * A summary of all test findings, aggregated to provide an overall assessment of policy quality and
         * correctness.
         * </p>
         * 
         * @param aggregatedTestFindingsResult
         *        A summary of all test findings, aggregated to provide an overall assessment of policy quality and
         *        correctness.
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder aggregatedTestFindingsResult(AutomatedReasoningCheckResult aggregatedTestFindingsResult);

        /**
         * <p>
         * The timestamp when the test results were last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the test results were last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyTestCase testCase;

        private String policyArn;

        private String testRunStatus;

        private List<AutomatedReasoningCheckFinding> testFindings = DefaultSdkAutoConstructList.getInstance();

        private String testRunResult;

        private String aggregatedTestFindingsResult;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyTestResult model) {
            testCase(model.testCase);
            policyArn(model.policyArn);
            testRunStatus(model.testRunStatus);
            testFindings(model.testFindings);
            testRunResult(model.testRunResult);
            aggregatedTestFindingsResult(model.aggregatedTestFindingsResult);
            updatedAt(model.updatedAt);
        }

        public final AutomatedReasoningPolicyTestCase.Builder getTestCase() {
            return testCase != null ? testCase.toBuilder() : null;
        }

        public final void setTestCase(AutomatedReasoningPolicyTestCase.BuilderImpl testCase) {
            this.testCase = testCase != null ? testCase.build() : null;
        }

        @Override
        public final Builder testCase(AutomatedReasoningPolicyTestCase testCase) {
            this.testCase = testCase;
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getTestRunStatus() {
            return testRunStatus;
        }

        public final void setTestRunStatus(String testRunStatus) {
            this.testRunStatus = testRunStatus;
        }

        @Override
        public final Builder testRunStatus(String testRunStatus) {
            this.testRunStatus = testRunStatus;
            return this;
        }

        @Override
        public final Builder testRunStatus(AutomatedReasoningPolicyTestRunStatus testRunStatus) {
            this.testRunStatus(testRunStatus == null ? null : testRunStatus.toString());
            return this;
        }

        public final List<AutomatedReasoningCheckFinding.Builder> getTestFindings() {
            List<AutomatedReasoningCheckFinding.Builder> result = AutomatedReasoningCheckFindingListCopier
                    .copyToBuilder(this.testFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestFindings(Collection<AutomatedReasoningCheckFinding.BuilderImpl> testFindings) {
            this.testFindings = AutomatedReasoningCheckFindingListCopier.copyFromBuilder(testFindings);
        }

        @Override
        public final Builder testFindings(Collection<AutomatedReasoningCheckFinding> testFindings) {
            this.testFindings = AutomatedReasoningCheckFindingListCopier.copy(testFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testFindings(AutomatedReasoningCheckFinding... testFindings) {
            testFindings(Arrays.asList(testFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testFindings(Consumer<AutomatedReasoningCheckFinding.Builder>... testFindings) {
            testFindings(Stream.of(testFindings).map(c -> AutomatedReasoningCheckFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTestRunResult() {
            return testRunResult;
        }

        public final void setTestRunResult(String testRunResult) {
            this.testRunResult = testRunResult;
        }

        @Override
        public final Builder testRunResult(String testRunResult) {
            this.testRunResult = testRunResult;
            return this;
        }

        @Override
        public final Builder testRunResult(AutomatedReasoningPolicyTestRunResult testRunResult) {
            this.testRunResult(testRunResult == null ? null : testRunResult.toString());
            return this;
        }

        public final String getAggregatedTestFindingsResult() {
            return aggregatedTestFindingsResult;
        }

        public final void setAggregatedTestFindingsResult(String aggregatedTestFindingsResult) {
            this.aggregatedTestFindingsResult = aggregatedTestFindingsResult;
        }

        @Override
        public final Builder aggregatedTestFindingsResult(String aggregatedTestFindingsResult) {
            this.aggregatedTestFindingsResult = aggregatedTestFindingsResult;
            return this;
        }

        @Override
        public final Builder aggregatedTestFindingsResult(AutomatedReasoningCheckResult aggregatedTestFindingsResult) {
            this.aggregatedTestFindingsResult(aggregatedTestFindingsResult == null ? null : aggregatedTestFindingsResult
                    .toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyTestResult build() {
            return new AutomatedReasoningPolicyTestResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
