/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An annotation for managing values within custom types, including adding, updating, or removing specific type values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyTypeValueAnnotation implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyTypeValueAnnotation.Builder, AutomatedReasoningPolicyTypeValueAnnotation> {
    private static final SdkField<AutomatedReasoningPolicyAddTypeValue> ADD_TYPE_VALUE_FIELD = SdkField
            .<AutomatedReasoningPolicyAddTypeValue> builder(MarshallingType.SDK_POJO).memberName("addTypeValue")
            .getter(getter(AutomatedReasoningPolicyTypeValueAnnotation::addTypeValue)).setter(setter(Builder::addTypeValue))
            .constructor(AutomatedReasoningPolicyAddTypeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addTypeValue").build()).build();

    private static final SdkField<AutomatedReasoningPolicyUpdateTypeValue> UPDATE_TYPE_VALUE_FIELD = SdkField
            .<AutomatedReasoningPolicyUpdateTypeValue> builder(MarshallingType.SDK_POJO).memberName("updateTypeValue")
            .getter(getter(AutomatedReasoningPolicyTypeValueAnnotation::updateTypeValue))
            .setter(setter(Builder::updateTypeValue)).constructor(AutomatedReasoningPolicyUpdateTypeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTypeValue").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDeleteTypeValue> DELETE_TYPE_VALUE_FIELD = SdkField
            .<AutomatedReasoningPolicyDeleteTypeValue> builder(MarshallingType.SDK_POJO).memberName("deleteTypeValue")
            .getter(getter(AutomatedReasoningPolicyTypeValueAnnotation::deleteTypeValue))
            .setter(setter(Builder::deleteTypeValue)).constructor(AutomatedReasoningPolicyDeleteTypeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteTypeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_TYPE_VALUE_FIELD,
            UPDATE_TYPE_VALUE_FIELD, DELETE_TYPE_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyAddTypeValue addTypeValue;

    private final AutomatedReasoningPolicyUpdateTypeValue updateTypeValue;

    private final AutomatedReasoningPolicyDeleteTypeValue deleteTypeValue;

    private final Type type;

    private AutomatedReasoningPolicyTypeValueAnnotation(BuilderImpl builder) {
        this.addTypeValue = builder.addTypeValue;
        this.updateTypeValue = builder.updateTypeValue;
        this.deleteTypeValue = builder.deleteTypeValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * An operation to add a new value to an existing custom type.
     * </p>
     * 
     * @return An operation to add a new value to an existing custom type.
     */
    public final AutomatedReasoningPolicyAddTypeValue addTypeValue() {
        return addTypeValue;
    }

    /**
     * <p>
     * An operation to modify an existing value within a custom type.
     * </p>
     * 
     * @return An operation to modify an existing value within a custom type.
     */
    public final AutomatedReasoningPolicyUpdateTypeValue updateTypeValue() {
        return updateTypeValue;
    }

    /**
     * <p>
     * An operation to remove a value from an existing custom type.
     * </p>
     * 
     * @return An operation to remove a value from an existing custom type.
     */
    public final AutomatedReasoningPolicyDeleteTypeValue deleteTypeValue() {
        return deleteTypeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addTypeValue());
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeValue());
        hashCode = 31 * hashCode + Objects.hashCode(deleteTypeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyTypeValueAnnotation)) {
            return false;
        }
        AutomatedReasoningPolicyTypeValueAnnotation other = (AutomatedReasoningPolicyTypeValueAnnotation) obj;
        return Objects.equals(addTypeValue(), other.addTypeValue()) && Objects.equals(updateTypeValue(), other.updateTypeValue())
                && Objects.equals(deleteTypeValue(), other.deleteTypeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyTypeValueAnnotation").add("AddTypeValue", addTypeValue())
                .add("UpdateTypeValue", updateTypeValue()).add("DeleteTypeValue", deleteTypeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addTypeValue":
            return Optional.ofNullable(clazz.cast(addTypeValue()));
        case "updateTypeValue":
            return Optional.ofNullable(clazz.cast(updateTypeValue()));
        case "deleteTypeValue":
            return Optional.ofNullable(clazz.cast(deleteTypeValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #addTypeValue()} initialized to the given value.
     *
     * <p>
     * An operation to add a new value to an existing custom type.
     * </p>
     * 
     * @param addTypeValue
     *        An operation to add a new value to an existing custom type.
     */
    public static AutomatedReasoningPolicyTypeValueAnnotation fromAddTypeValue(AutomatedReasoningPolicyAddTypeValue addTypeValue) {
        return builder().addTypeValue(addTypeValue).build();
    }

    /**
     * Create an instance of this class with {@link #addTypeValue()} initialized to the given value.
     *
     * <p>
     * An operation to add a new value to an existing custom type.
     * </p>
     * 
     * @param addTypeValue
     *        An operation to add a new value to an existing custom type.
     */
    public static AutomatedReasoningPolicyTypeValueAnnotation fromAddTypeValue(
            Consumer<AutomatedReasoningPolicyAddTypeValue.Builder> addTypeValue) {
        AutomatedReasoningPolicyAddTypeValue.Builder builder = AutomatedReasoningPolicyAddTypeValue.builder();
        addTypeValue.accept(builder);
        return fromAddTypeValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #updateTypeValue()} initialized to the given value.
     *
     * <p>
     * An operation to modify an existing value within a custom type.
     * </p>
     * 
     * @param updateTypeValue
     *        An operation to modify an existing value within a custom type.
     */
    public static AutomatedReasoningPolicyTypeValueAnnotation fromUpdateTypeValue(
            AutomatedReasoningPolicyUpdateTypeValue updateTypeValue) {
        return builder().updateTypeValue(updateTypeValue).build();
    }

    /**
     * Create an instance of this class with {@link #updateTypeValue()} initialized to the given value.
     *
     * <p>
     * An operation to modify an existing value within a custom type.
     * </p>
     * 
     * @param updateTypeValue
     *        An operation to modify an existing value within a custom type.
     */
    public static AutomatedReasoningPolicyTypeValueAnnotation fromUpdateTypeValue(
            Consumer<AutomatedReasoningPolicyUpdateTypeValue.Builder> updateTypeValue) {
        AutomatedReasoningPolicyUpdateTypeValue.Builder builder = AutomatedReasoningPolicyUpdateTypeValue.builder();
        updateTypeValue.accept(builder);
        return fromUpdateTypeValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deleteTypeValue()} initialized to the given value.
     *
     * <p>
     * An operation to remove a value from an existing custom type.
     * </p>
     * 
     * @param deleteTypeValue
     *        An operation to remove a value from an existing custom type.
     */
    public static AutomatedReasoningPolicyTypeValueAnnotation fromDeleteTypeValue(
            AutomatedReasoningPolicyDeleteTypeValue deleteTypeValue) {
        return builder().deleteTypeValue(deleteTypeValue).build();
    }

    /**
     * Create an instance of this class with {@link #deleteTypeValue()} initialized to the given value.
     *
     * <p>
     * An operation to remove a value from an existing custom type.
     * </p>
     * 
     * @param deleteTypeValue
     *        An operation to remove a value from an existing custom type.
     */
    public static AutomatedReasoningPolicyTypeValueAnnotation fromDeleteTypeValue(
            Consumer<AutomatedReasoningPolicyDeleteTypeValue.Builder> deleteTypeValue) {
        AutomatedReasoningPolicyDeleteTypeValue.Builder builder = AutomatedReasoningPolicyDeleteTypeValue.builder();
        deleteTypeValue.accept(builder);
        return fromDeleteTypeValue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addTypeValue", ADD_TYPE_VALUE_FIELD);
        map.put("updateTypeValue", UPDATE_TYPE_VALUE_FIELD);
        map.put("deleteTypeValue", DELETE_TYPE_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyTypeValueAnnotation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyTypeValueAnnotation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyTypeValueAnnotation> {
        /**
         * <p>
         * An operation to add a new value to an existing custom type.
         * </p>
         * 
         * @param addTypeValue
         *        An operation to add a new value to an existing custom type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTypeValue(AutomatedReasoningPolicyAddTypeValue addTypeValue);

        /**
         * <p>
         * An operation to add a new value to an existing custom type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyAddTypeValue.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyAddTypeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyAddTypeValue.Builder#build()} is called
         * immediately and its result is passed to {@link #addTypeValue(AutomatedReasoningPolicyAddTypeValue)}.
         * 
         * @param addTypeValue
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyAddTypeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addTypeValue(AutomatedReasoningPolicyAddTypeValue)
         */
        default Builder addTypeValue(Consumer<AutomatedReasoningPolicyAddTypeValue.Builder> addTypeValue) {
            return addTypeValue(AutomatedReasoningPolicyAddTypeValue.builder().applyMutation(addTypeValue).build());
        }

        /**
         * <p>
         * An operation to modify an existing value within a custom type.
         * </p>
         * 
         * @param updateTypeValue
         *        An operation to modify an existing value within a custom type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTypeValue(AutomatedReasoningPolicyUpdateTypeValue updateTypeValue);

        /**
         * <p>
         * An operation to modify an existing value within a custom type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyUpdateTypeValue.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyUpdateTypeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyUpdateTypeValue.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #updateTypeValue(AutomatedReasoningPolicyUpdateTypeValue)}.
         * 
         * @param updateTypeValue
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyUpdateTypeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateTypeValue(AutomatedReasoningPolicyUpdateTypeValue)
         */
        default Builder updateTypeValue(Consumer<AutomatedReasoningPolicyUpdateTypeValue.Builder> updateTypeValue) {
            return updateTypeValue(AutomatedReasoningPolicyUpdateTypeValue.builder().applyMutation(updateTypeValue).build());
        }

        /**
         * <p>
         * An operation to remove a value from an existing custom type.
         * </p>
         * 
         * @param deleteTypeValue
         *        An operation to remove a value from an existing custom type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteTypeValue(AutomatedReasoningPolicyDeleteTypeValue deleteTypeValue);

        /**
         * <p>
         * An operation to remove a value from an existing custom type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDeleteTypeValue.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDeleteTypeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDeleteTypeValue.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deleteTypeValue(AutomatedReasoningPolicyDeleteTypeValue)}.
         * 
         * @param deleteTypeValue
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDeleteTypeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteTypeValue(AutomatedReasoningPolicyDeleteTypeValue)
         */
        default Builder deleteTypeValue(Consumer<AutomatedReasoningPolicyDeleteTypeValue.Builder> deleteTypeValue) {
            return deleteTypeValue(AutomatedReasoningPolicyDeleteTypeValue.builder().applyMutation(deleteTypeValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyAddTypeValue addTypeValue;

        private AutomatedReasoningPolicyUpdateTypeValue updateTypeValue;

        private AutomatedReasoningPolicyDeleteTypeValue deleteTypeValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyTypeValueAnnotation model) {
            addTypeValue(model.addTypeValue);
            updateTypeValue(model.updateTypeValue);
            deleteTypeValue(model.deleteTypeValue);
        }

        public final AutomatedReasoningPolicyAddTypeValue.Builder getAddTypeValue() {
            return addTypeValue != null ? addTypeValue.toBuilder() : null;
        }

        public final void setAddTypeValue(AutomatedReasoningPolicyAddTypeValue.BuilderImpl addTypeValue) {
            Object oldValue = this.addTypeValue;
            this.addTypeValue = addTypeValue != null ? addTypeValue.build() : null;
            handleUnionValueChange(Type.ADD_TYPE_VALUE, oldValue, this.addTypeValue);
        }

        @Override
        public final Builder addTypeValue(AutomatedReasoningPolicyAddTypeValue addTypeValue) {
            Object oldValue = this.addTypeValue;
            this.addTypeValue = addTypeValue;
            handleUnionValueChange(Type.ADD_TYPE_VALUE, oldValue, this.addTypeValue);
            return this;
        }

        public final AutomatedReasoningPolicyUpdateTypeValue.Builder getUpdateTypeValue() {
            return updateTypeValue != null ? updateTypeValue.toBuilder() : null;
        }

        public final void setUpdateTypeValue(AutomatedReasoningPolicyUpdateTypeValue.BuilderImpl updateTypeValue) {
            Object oldValue = this.updateTypeValue;
            this.updateTypeValue = updateTypeValue != null ? updateTypeValue.build() : null;
            handleUnionValueChange(Type.UPDATE_TYPE_VALUE, oldValue, this.updateTypeValue);
        }

        @Override
        public final Builder updateTypeValue(AutomatedReasoningPolicyUpdateTypeValue updateTypeValue) {
            Object oldValue = this.updateTypeValue;
            this.updateTypeValue = updateTypeValue;
            handleUnionValueChange(Type.UPDATE_TYPE_VALUE, oldValue, this.updateTypeValue);
            return this;
        }

        public final AutomatedReasoningPolicyDeleteTypeValue.Builder getDeleteTypeValue() {
            return deleteTypeValue != null ? deleteTypeValue.toBuilder() : null;
        }

        public final void setDeleteTypeValue(AutomatedReasoningPolicyDeleteTypeValue.BuilderImpl deleteTypeValue) {
            Object oldValue = this.deleteTypeValue;
            this.deleteTypeValue = deleteTypeValue != null ? deleteTypeValue.build() : null;
            handleUnionValueChange(Type.DELETE_TYPE_VALUE, oldValue, this.deleteTypeValue);
        }

        @Override
        public final Builder deleteTypeValue(AutomatedReasoningPolicyDeleteTypeValue deleteTypeValue) {
            Object oldValue = this.deleteTypeValue;
            this.deleteTypeValue = deleteTypeValue;
            handleUnionValueChange(Type.DELETE_TYPE_VALUE, oldValue, this.deleteTypeValue);
            return this;
        }

        @Override
        public AutomatedReasoningPolicyTypeValueAnnotation build() {
            return new AutomatedReasoningPolicyTypeValueAnnotation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutomatedReasoningPolicyTypeValueAnnotation#type()
     */
    public enum Type {
        ADD_TYPE_VALUE,

        UPDATE_TYPE_VALUE,

        DELETE_TYPE_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
