/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An annotation for updating the policy based on feedback about how specific rules performed during testing or
 * real-world usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation.Builder, AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation> {
    private static final SdkField<List<String>> RULE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ruleIds")
            .getter(getter(AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation::ruleIds))
            .setter(setter(Builder::ruleIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FEEDBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("feedback").getter(getter(AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation::feedback))
            .setter(setter(Builder::feedback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RULE_IDS_FIELD, FEEDBACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> ruleIds;

    private final String feedback;

    private AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation(BuilderImpl builder) {
        this.ruleIds = builder.ruleIds;
        this.feedback = builder.feedback;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRuleIds() {
        return ruleIds != null && !(ruleIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of rule identifiers that the feedback applies to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleIds} method.
     * </p>
     * 
     * @return The list of rule identifiers that the feedback applies to.
     */
    public final List<String> ruleIds() {
        return ruleIds;
    }

    /**
     * <p>
     * The feedback information about rule performance, including suggestions for improvements or corrections.
     * </p>
     * 
     * @return The feedback information about rule performance, including suggestions for improvements or corrections.
     */
    public final String feedback() {
        return feedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleIds() ? ruleIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(feedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation)) {
            return false;
        }
        AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation other = (AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation) obj;
        return hasRuleIds() == other.hasRuleIds() && Objects.equals(ruleIds(), other.ruleIds())
                && Objects.equals(feedback(), other.feedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation")
                .add("RuleIds", hasRuleIds() ? ruleIds() : null)
                .add("Feedback", feedback() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleIds":
            return Optional.ofNullable(clazz.cast(ruleIds()));
        case "feedback":
            return Optional.ofNullable(clazz.cast(feedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleIds", RULE_IDS_FIELD);
        map.put("feedback", FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation> {
        /**
         * <p>
         * The list of rule identifiers that the feedback applies to.
         * </p>
         * 
         * @param ruleIds
         *        The list of rule identifiers that the feedback applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleIds(Collection<String> ruleIds);

        /**
         * <p>
         * The list of rule identifiers that the feedback applies to.
         * </p>
         * 
         * @param ruleIds
         *        The list of rule identifiers that the feedback applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleIds(String... ruleIds);

        /**
         * <p>
         * The feedback information about rule performance, including suggestions for improvements or corrections.
         * </p>
         * 
         * @param feedback
         *        The feedback information about rule performance, including suggestions for improvements or
         *        corrections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedback(String feedback);
    }

    static final class BuilderImpl implements Builder {
        private List<String> ruleIds = DefaultSdkAutoConstructList.getInstance();

        private String feedback;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation model) {
            ruleIds(model.ruleIds);
            feedback(model.feedback);
        }

        public final Collection<String> getRuleIds() {
            if (ruleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleIds;
        }

        public final void setRuleIds(Collection<String> ruleIds) {
            this.ruleIds = AutomatedReasoningPolicyDefinitionRuleIdListCopier.copy(ruleIds);
        }

        @Override
        public final Builder ruleIds(Collection<String> ruleIds) {
            this.ruleIds = AutomatedReasoningPolicyDefinitionRuleIdListCopier.copy(ruleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleIds(String... ruleIds) {
            ruleIds(Arrays.asList(ruleIds));
            return this;
        }

        public final String getFeedback() {
            return feedback;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation build() {
            return new AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
