/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelCustomizationJobRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateModelCustomizationJobRequest.Builder, CreateModelCustomizationJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(CreateModelCustomizationJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> CUSTOM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customModelName").getter(getter(CreateModelCustomizationJobRequest::customModelName))
            .setter(setter(Builder::customModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateModelCustomizationJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateModelCustomizationJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> BASE_MODEL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baseModelIdentifier").getter(getter(CreateModelCustomizationJobRequest::baseModelIdentifier))
            .setter(setter(Builder::baseModelIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelIdentifier").build())
            .build();

    private static final SdkField<String> CUSTOMIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customizationType").getter(getter(CreateModelCustomizationJobRequest::customizationTypeAsString))
            .setter(setter(Builder::customizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationType").build()).build();

    private static final SdkField<String> CUSTOM_MODEL_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customModelKmsKeyId").getter(getter(CreateModelCustomizationJobRequest::customModelKmsKeyId))
            .setter(setter(Builder::customModelKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelKmsKeyId").build())
            .build();

    private static final SdkField<List<Tag>> JOB_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("jobTags")
            .getter(getter(CreateModelCustomizationJobRequest::jobTags))
            .setter(setter(Builder::jobTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> CUSTOM_MODEL_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("customModelTags")
            .getter(getter(CreateModelCustomizationJobRequest::customModelTags))
            .setter(setter(Builder::customModelTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TrainingDataConfig> TRAINING_DATA_CONFIG_FIELD = SdkField
            .<TrainingDataConfig> builder(MarshallingType.SDK_POJO).memberName("trainingDataConfig")
            .getter(getter(CreateModelCustomizationJobRequest::trainingDataConfig)).setter(setter(Builder::trainingDataConfig))
            .constructor(TrainingDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataConfig").build())
            .build();

    private static final SdkField<ValidationDataConfig> VALIDATION_DATA_CONFIG_FIELD = SdkField
            .<ValidationDataConfig> builder(MarshallingType.SDK_POJO).memberName("validationDataConfig")
            .getter(getter(CreateModelCustomizationJobRequest::validationDataConfig))
            .setter(setter(Builder::validationDataConfig)).constructor(ValidationDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationDataConfig").build())
            .build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(CreateModelCustomizationJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("hyperParameters")
            .getter(getter(CreateModelCustomizationJobRequest::hyperParameters))
            .setter(setter(Builder::hyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(CreateModelCustomizationJobRequest::vpcConfig))
            .setter(setter(Builder::vpcConfig)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<CustomizationConfig> CUSTOMIZATION_CONFIG_FIELD = SdkField
            .<CustomizationConfig> builder(MarshallingType.SDK_POJO).memberName("customizationConfig")
            .getter(getter(CreateModelCustomizationJobRequest::customizationConfig)).setter(setter(Builder::customizationConfig))
            .constructor(CustomizationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            CUSTOM_MODEL_NAME_FIELD, ROLE_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, BASE_MODEL_IDENTIFIER_FIELD,
            CUSTOMIZATION_TYPE_FIELD, CUSTOM_MODEL_KMS_KEY_ID_FIELD, JOB_TAGS_FIELD, CUSTOM_MODEL_TAGS_FIELD,
            TRAINING_DATA_CONFIG_FIELD, VALIDATION_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, HYPER_PARAMETERS_FIELD,
            VPC_CONFIG_FIELD, CUSTOMIZATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobName;

    private final String customModelName;

    private final String roleArn;

    private final String clientRequestToken;

    private final String baseModelIdentifier;

    private final String customizationType;

    private final String customModelKmsKeyId;

    private final List<Tag> jobTags;

    private final List<Tag> customModelTags;

    private final TrainingDataConfig trainingDataConfig;

    private final ValidationDataConfig validationDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final Map<String, String> hyperParameters;

    private final VpcConfig vpcConfig;

    private final CustomizationConfig customizationConfig;

    private CreateModelCustomizationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.customModelName = builder.customModelName;
        this.roleArn = builder.roleArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.baseModelIdentifier = builder.baseModelIdentifier;
        this.customizationType = builder.customizationType;
        this.customModelKmsKeyId = builder.customModelKmsKeyId;
        this.jobTags = builder.jobTags;
        this.customModelTags = builder.customModelTags;
        this.trainingDataConfig = builder.trainingDataConfig;
        this.validationDataConfig = builder.validationDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.hyperParameters = builder.hyperParameters;
        this.vpcConfig = builder.vpcConfig;
        this.customizationConfig = builder.customizationConfig;
    }

    /**
     * <p>
     * A name for the fine-tuning job.
     * </p>
     * 
     * @return A name for the fine-tuning job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * A name for the resulting custom model.
     * </p>
     * 
     * @return A name for the resulting custom model.
     */
    public final String customModelName() {
        return customModelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on your
     * behalf. For example, during model training, Amazon Bedrock needs your permission to read input data from an S3
     * bucket, write model artifacts to an S3 bucket. To pass this role to Amazon Bedrock, the caller of this API must
     * have the <code>iam:PassRole</code> permission.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on
     *         your behalf. For example, during model training, Amazon Bedrock needs your permission to read input data
     *         from an S3 bucket, write model artifacts to an S3 bucket. To pass this role to Amazon Bedrock, the caller
     *         of this API must have the <code>iam:PassRole</code> permission.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Name of the base model.
     * </p>
     * 
     * @return Name of the base model.
     */
    public final String baseModelIdentifier() {
        return baseModelIdentifier;
    }

    /**
     * <p>
     * The customization type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customizationType}
     * will return {@link CustomizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customizationTypeAsString}.
     * </p>
     * 
     * @return The customization type.
     * @see CustomizationType
     */
    public final CustomizationType customizationType() {
        return CustomizationType.fromValue(customizationType);
    }

    /**
     * <p>
     * The customization type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customizationType}
     * will return {@link CustomizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customizationTypeAsString}.
     * </p>
     * 
     * @return The customization type.
     * @see CustomizationType
     */
    public final String customizationTypeAsString() {
        return customizationType;
    }

    /**
     * <p>
     * The custom model is encrypted at rest using this key.
     * </p>
     * 
     * @return The custom model is encrypted at rest using this key.
     */
    public final String customModelKmsKeyId() {
        return customModelKmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobTags() {
        return jobTags != null && !(jobTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to attach to the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobTags} method.
     * </p>
     * 
     * @return Tags to attach to the job.
     */
    public final List<Tag> jobTags() {
        return jobTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomModelTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomModelTags() {
        return customModelTags != null && !(customModelTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to attach to the resulting custom model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomModelTags} method.
     * </p>
     * 
     * @return Tags to attach to the resulting custom model.
     */
    public final List<Tag> customModelTags() {
        return customModelTags;
    }

    /**
     * <p>
     * Information about the training dataset.
     * </p>
     * 
     * @return Information about the training dataset.
     */
    public final TrainingDataConfig trainingDataConfig() {
        return trainingDataConfig;
    }

    /**
     * <p>
     * Information about the validation dataset.
     * </p>
     * 
     * @return Information about the validation dataset.
     */
    public final ValidationDataConfig validationDataConfig() {
        return validationDataConfig;
    }

    /**
     * <p>
     * S3 location for the output data.
     * </p>
     * 
     * @return S3 location for the output data.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the HyperParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHyperParameters() {
        return hyperParameters != null && !(hyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Parameters related to tuning the model. For details on the format for different models, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model
     * hyperparameters</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHyperParameters} method.
     * </p>
     * 
     * @return Parameters related to tuning the model. For details on the format for different models, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model
     *         hyperparameters</a>.
     */
    public final Map<String, String> hyperParameters() {
        return hyperParameters;
    }

    /**
     * <p>
     * The configuration of the Virtual Private Cloud (VPC) that contains the resources that you're using for this job.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/vpc-model-customization.html">Protect your model
     * customization jobs using a VPC</a>.
     * </p>
     * 
     * @return The configuration of the Virtual Private Cloud (VPC) that contains the resources that you're using for
     *         this job. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/vpc-model-customization.html">Protect your
     *         model customization jobs using a VPC</a>.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The customization configuration for the model customization job.
     * </p>
     * 
     * @return The customization configuration for the model customization job.
     */
    public final CustomizationConfig customizationConfig() {
        return customizationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(customModelName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(customizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customModelKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTags() ? jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomModelTags() ? customModelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(validationDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperParameters() ? hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(customizationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelCustomizationJobRequest)) {
            return false;
        }
        CreateModelCustomizationJobRequest other = (CreateModelCustomizationJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(customModelName(), other.customModelName())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(baseModelIdentifier(), other.baseModelIdentifier())
                && Objects.equals(customizationTypeAsString(), other.customizationTypeAsString())
                && Objects.equals(customModelKmsKeyId(), other.customModelKmsKeyId()) && hasJobTags() == other.hasJobTags()
                && Objects.equals(jobTags(), other.jobTags()) && hasCustomModelTags() == other.hasCustomModelTags()
                && Objects.equals(customModelTags(), other.customModelTags())
                && Objects.equals(trainingDataConfig(), other.trainingDataConfig())
                && Objects.equals(validationDataConfig(), other.validationDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && hasHyperParameters() == other.hasHyperParameters()
                && Objects.equals(hyperParameters(), other.hyperParameters()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(customizationConfig(), other.customizationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelCustomizationJobRequest").add("JobName", jobName())
                .add("CustomModelName", customModelName()).add("RoleArn", roleArn())
                .add("ClientRequestToken", clientRequestToken()).add("BaseModelIdentifier", baseModelIdentifier())
                .add("CustomizationType", customizationTypeAsString()).add("CustomModelKmsKeyId", customModelKmsKeyId())
                .add("JobTags", hasJobTags() ? jobTags() : null)
                .add("CustomModelTags", hasCustomModelTags() ? customModelTags() : null)
                .add("TrainingDataConfig", trainingDataConfig()).add("ValidationDataConfig", validationDataConfig())
                .add("OutputDataConfig", outputDataConfig())
                .add("HyperParameters", hasHyperParameters() ? hyperParameters() : null).add("VpcConfig", vpcConfig())
                .add("CustomizationConfig", customizationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "customModelName":
            return Optional.ofNullable(clazz.cast(customModelName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "baseModelIdentifier":
            return Optional.ofNullable(clazz.cast(baseModelIdentifier()));
        case "customizationType":
            return Optional.ofNullable(clazz.cast(customizationTypeAsString()));
        case "customModelKmsKeyId":
            return Optional.ofNullable(clazz.cast(customModelKmsKeyId()));
        case "jobTags":
            return Optional.ofNullable(clazz.cast(jobTags()));
        case "customModelTags":
            return Optional.ofNullable(clazz.cast(customModelTags()));
        case "trainingDataConfig":
            return Optional.ofNullable(clazz.cast(trainingDataConfig()));
        case "validationDataConfig":
            return Optional.ofNullable(clazz.cast(validationDataConfig()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "hyperParameters":
            return Optional.ofNullable(clazz.cast(hyperParameters()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "customizationConfig":
            return Optional.ofNullable(clazz.cast(customizationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("customModelName", CUSTOM_MODEL_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("baseModelIdentifier", BASE_MODEL_IDENTIFIER_FIELD);
        map.put("customizationType", CUSTOMIZATION_TYPE_FIELD);
        map.put("customModelKmsKeyId", CUSTOM_MODEL_KMS_KEY_ID_FIELD);
        map.put("jobTags", JOB_TAGS_FIELD);
        map.put("customModelTags", CUSTOM_MODEL_TAGS_FIELD);
        map.put("trainingDataConfig", TRAINING_DATA_CONFIG_FIELD);
        map.put("validationDataConfig", VALIDATION_DATA_CONFIG_FIELD);
        map.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        map.put("hyperParameters", HYPER_PARAMETERS_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("customizationConfig", CUSTOMIZATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateModelCustomizationJobRequest, T> g) {
        return obj -> g.apply((CreateModelCustomizationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateModelCustomizationJobRequest> {
        /**
         * <p>
         * A name for the fine-tuning job.
         * </p>
         * 
         * @param jobName
         *        A name for the fine-tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * A name for the resulting custom model.
         * </p>
         * 
         * @param customModelName
         *        A name for the resulting custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelName(String customModelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on your
         * behalf. For example, during model training, Amazon Bedrock needs your permission to read input data from an
         * S3 bucket, write model artifacts to an S3 bucket. To pass this role to Amazon Bedrock, the caller of this API
         * must have the <code>iam:PassRole</code> permission.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks
         *        on your behalf. For example, during model training, Amazon Bedrock needs your permission to read input
         *        data from an S3 bucket, write model artifacts to an S3 bucket. To pass this role to Amazon Bedrock,
         *        the caller of this API must have the <code>iam:PassRole</code> permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Name of the base model.
         * </p>
         * 
         * @param baseModelIdentifier
         *        Name of the base model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseModelIdentifier(String baseModelIdentifier);

        /**
         * <p>
         * The customization type.
         * </p>
         * 
         * @param customizationType
         *        The customization type.
         * @see CustomizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationType
         */
        Builder customizationType(String customizationType);

        /**
         * <p>
         * The customization type.
         * </p>
         * 
         * @param customizationType
         *        The customization type.
         * @see CustomizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationType
         */
        Builder customizationType(CustomizationType customizationType);

        /**
         * <p>
         * The custom model is encrypted at rest using this key.
         * </p>
         * 
         * @param customModelKmsKeyId
         *        The custom model is encrypted at rest using this key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelKmsKeyId(String customModelKmsKeyId);

        /**
         * <p>
         * Tags to attach to the job.
         * </p>
         * 
         * @param jobTags
         *        Tags to attach to the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Collection<Tag> jobTags);

        /**
         * <p>
         * Tags to attach to the job.
         * </p>
         * 
         * @param jobTags
         *        Tags to attach to the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Tag... jobTags);

        /**
         * <p>
         * Tags to attach to the job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #jobTags(List<Tag>)}.
         * 
         * @param jobTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTags(java.util.Collection<Tag>)
         */
        Builder jobTags(Consumer<Tag.Builder>... jobTags);

        /**
         * <p>
         * Tags to attach to the resulting custom model.
         * </p>
         * 
         * @param customModelTags
         *        Tags to attach to the resulting custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelTags(Collection<Tag> customModelTags);

        /**
         * <p>
         * Tags to attach to the resulting custom model.
         * </p>
         * 
         * @param customModelTags
         *        Tags to attach to the resulting custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelTags(Tag... customModelTags);

        /**
         * <p>
         * Tags to attach to the resulting custom model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #customModelTags(List<Tag>)}.
         * 
         * @param customModelTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customModelTags(java.util.Collection<Tag>)
         */
        Builder customModelTags(Consumer<Tag.Builder>... customModelTags);

        /**
         * <p>
         * Information about the training dataset.
         * </p>
         * 
         * @param trainingDataConfig
         *        Information about the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataConfig(TrainingDataConfig trainingDataConfig);

        /**
         * <p>
         * Information about the training dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingDataConfig.Builder} avoiding the
         * need to create one manually via {@link TrainingDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingDataConfig(TrainingDataConfig)}.
         * 
         * @param trainingDataConfig
         *        a consumer that will call methods on {@link TrainingDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingDataConfig(TrainingDataConfig)
         */
        default Builder trainingDataConfig(Consumer<TrainingDataConfig.Builder> trainingDataConfig) {
            return trainingDataConfig(TrainingDataConfig.builder().applyMutation(trainingDataConfig).build());
        }

        /**
         * <p>
         * Information about the validation dataset.
         * </p>
         * 
         * @param validationDataConfig
         *        Information about the validation dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationDataConfig(ValidationDataConfig validationDataConfig);

        /**
         * <p>
         * Information about the validation dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidationDataConfig.Builder} avoiding
         * the need to create one manually via {@link ValidationDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationDataConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #validationDataConfig(ValidationDataConfig)}.
         * 
         * @param validationDataConfig
         *        a consumer that will call methods on {@link ValidationDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationDataConfig(ValidationDataConfig)
         */
        default Builder validationDataConfig(Consumer<ValidationDataConfig.Builder> validationDataConfig) {
            return validationDataConfig(ValidationDataConfig.builder().applyMutation(validationDataConfig).build());
        }

        /**
         * <p>
         * S3 location for the output data.
         * </p>
         * 
         * @param outputDataConfig
         *        S3 location for the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * S3 location for the output data.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * Parameters related to tuning the model. For details on the format for different models, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model
         * hyperparameters</a>.
         * </p>
         * 
         * @param hyperParameters
         *        Parameters related to tuning the model. For details on the format for different models, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model
         *        hyperparameters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameters(Map<String, String> hyperParameters);

        /**
         * <p>
         * The configuration of the Virtual Private Cloud (VPC) that contains the resources that you're using for this
         * job. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/vpc-model-customization.html">Protect your model
         * customization jobs using a VPC</a>.
         * </p>
         * 
         * @param vpcConfig
         *        The configuration of the Virtual Private Cloud (VPC) that contains the resources that you're using for
         *        this job. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/vpc-model-customization.html">Protect your
         *        model customization jobs using a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The configuration of the Virtual Private Cloud (VPC) that contains the resources that you're using for this
         * job. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/vpc-model-customization.html">Protect your model
         * customization jobs using a VPC</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The customization configuration for the model customization job.
         * </p>
         * 
         * @param customizationConfig
         *        The customization configuration for the model customization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizationConfig(CustomizationConfig customizationConfig);

        /**
         * <p>
         * The customization configuration for the model customization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomizationConfig.Builder} avoiding the
         * need to create one manually via {@link CustomizationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomizationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #customizationConfig(CustomizationConfig)}.
         * 
         * @param customizationConfig
         *        a consumer that will call methods on {@link CustomizationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizationConfig(CustomizationConfig)
         */
        default Builder customizationConfig(Consumer<CustomizationConfig.Builder> customizationConfig) {
            return customizationConfig(CustomizationConfig.builder().applyMutation(customizationConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String jobName;

        private String customModelName;

        private String roleArn;

        private String clientRequestToken;

        private String baseModelIdentifier;

        private String customizationType;

        private String customModelKmsKeyId;

        private List<Tag> jobTags = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> customModelTags = DefaultSdkAutoConstructList.getInstance();

        private TrainingDataConfig trainingDataConfig;

        private ValidationDataConfig validationDataConfig;

        private OutputDataConfig outputDataConfig;

        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private VpcConfig vpcConfig;

        private CustomizationConfig customizationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelCustomizationJobRequest model) {
            super(model);
            jobName(model.jobName);
            customModelName(model.customModelName);
            roleArn(model.roleArn);
            clientRequestToken(model.clientRequestToken);
            baseModelIdentifier(model.baseModelIdentifier);
            customizationType(model.customizationType);
            customModelKmsKeyId(model.customModelKmsKeyId);
            jobTags(model.jobTags);
            customModelTags(model.customModelTags);
            trainingDataConfig(model.trainingDataConfig);
            validationDataConfig(model.validationDataConfig);
            outputDataConfig(model.outputDataConfig);
            hyperParameters(model.hyperParameters);
            vpcConfig(model.vpcConfig);
            customizationConfig(model.customizationConfig);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getCustomModelName() {
            return customModelName;
        }

        public final void setCustomModelName(String customModelName) {
            this.customModelName = customModelName;
        }

        @Override
        public final Builder customModelName(String customModelName) {
            this.customModelName = customModelName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getBaseModelIdentifier() {
            return baseModelIdentifier;
        }

        public final void setBaseModelIdentifier(String baseModelIdentifier) {
            this.baseModelIdentifier = baseModelIdentifier;
        }

        @Override
        public final Builder baseModelIdentifier(String baseModelIdentifier) {
            this.baseModelIdentifier = baseModelIdentifier;
            return this;
        }

        public final String getCustomizationType() {
            return customizationType;
        }

        public final void setCustomizationType(String customizationType) {
            this.customizationType = customizationType;
        }

        @Override
        public final Builder customizationType(String customizationType) {
            this.customizationType = customizationType;
            return this;
        }

        @Override
        public final Builder customizationType(CustomizationType customizationType) {
            this.customizationType(customizationType == null ? null : customizationType.toString());
            return this;
        }

        public final String getCustomModelKmsKeyId() {
            return customModelKmsKeyId;
        }

        public final void setCustomModelKmsKeyId(String customModelKmsKeyId) {
            this.customModelKmsKeyId = customModelKmsKeyId;
        }

        @Override
        public final Builder customModelKmsKeyId(String customModelKmsKeyId) {
            this.customModelKmsKeyId = customModelKmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getJobTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<Tag.BuilderImpl> jobTags) {
            this.jobTags = TagListCopier.copyFromBuilder(jobTags);
        }

        @Override
        public final Builder jobTags(Collection<Tag> jobTags) {
            this.jobTags = TagListCopier.copy(jobTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Tag... jobTags) {
            jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Consumer<Tag.Builder>... jobTags) {
            jobTags(Stream.of(jobTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getCustomModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.customModelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomModelTags(Collection<Tag.BuilderImpl> customModelTags) {
            this.customModelTags = TagListCopier.copyFromBuilder(customModelTags);
        }

        @Override
        public final Builder customModelTags(Collection<Tag> customModelTags) {
            this.customModelTags = TagListCopier.copy(customModelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customModelTags(Tag... customModelTags) {
            customModelTags(Arrays.asList(customModelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customModelTags(Consumer<Tag.Builder>... customModelTags) {
            customModelTags(Stream.of(customModelTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TrainingDataConfig.Builder getTrainingDataConfig() {
            return trainingDataConfig != null ? trainingDataConfig.toBuilder() : null;
        }

        public final void setTrainingDataConfig(TrainingDataConfig.BuilderImpl trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig != null ? trainingDataConfig.build() : null;
        }

        @Override
        public final Builder trainingDataConfig(TrainingDataConfig trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig;
            return this;
        }

        public final ValidationDataConfig.Builder getValidationDataConfig() {
            return validationDataConfig != null ? validationDataConfig.toBuilder() : null;
        }

        public final void setValidationDataConfig(ValidationDataConfig.BuilderImpl validationDataConfig) {
            this.validationDataConfig = validationDataConfig != null ? validationDataConfig.build() : null;
        }

        @Override
        public final Builder validationDataConfig(ValidationDataConfig validationDataConfig) {
            this.validationDataConfig = validationDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final CustomizationConfig.Builder getCustomizationConfig() {
            return customizationConfig != null ? customizationConfig.toBuilder() : null;
        }

        public final void setCustomizationConfig(CustomizationConfig.BuilderImpl customizationConfig) {
            this.customizationConfig = customizationConfig != null ? customizationConfig.build() : null;
        }

        @Override
        public final Builder customizationConfig(CustomizationConfig customizationConfig) {
            this.customizationConfig = customizationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelCustomizationJobRequest build() {
            return new CreateModelCustomizationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
