/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAutomatedReasoningPolicyBuildWorkflowRequest extends BedrockRequest
        implements
        ToCopyableBuilder<DeleteAutomatedReasoningPolicyBuildWorkflowRequest.Builder, DeleteAutomatedReasoningPolicyBuildWorkflowRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(DeleteAutomatedReasoningPolicyBuildWorkflowRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()).build();

    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildWorkflowId").getter(getter(DeleteAutomatedReasoningPolicyBuildWorkflowRequest::buildWorkflowId))
            .setter(setter(Builder::buildWorkflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("buildWorkflowId").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(DeleteAutomatedReasoningPolicyBuildWorkflowRequest::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            BUILD_WORKFLOW_ID_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String buildWorkflowId;

    private final Instant lastUpdatedAt;

    private DeleteAutomatedReasoningPolicyBuildWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowId = builder.buildWorkflowId;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy whose build workflow you want to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy whose build workflow you want to delete.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The unique identifier of the build workflow to delete.
     * </p>
     * 
     * @return The unique identifier of the build workflow to delete.
     */
    public final String buildWorkflowId() {
        return buildWorkflowId;
    }

    /**
     * <p>
     * The timestamp when the build workflow was last updated. This is used for optimistic concurrency control to
     * prevent accidental deletion of workflows that have been modified.
     * </p>
     * 
     * @return The timestamp when the build workflow was last updated. This is used for optimistic concurrency control
     *         to prevent accidental deletion of workflows that have been modified.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(buildWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAutomatedReasoningPolicyBuildWorkflowRequest)) {
            return false;
        }
        DeleteAutomatedReasoningPolicyBuildWorkflowRequest other = (DeleteAutomatedReasoningPolicyBuildWorkflowRequest) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(buildWorkflowId(), other.buildWorkflowId())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAutomatedReasoningPolicyBuildWorkflowRequest").add("PolicyArn", policyArn())
                .add("BuildWorkflowId", buildWorkflowId()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "buildWorkflowId":
            return Optional.ofNullable(clazz.cast(buildWorkflowId()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        map.put("updatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAutomatedReasoningPolicyBuildWorkflowRequest, T> g) {
        return obj -> g.apply((DeleteAutomatedReasoningPolicyBuildWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAutomatedReasoningPolicyBuildWorkflowRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy whose build workflow you want to delete.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy whose build workflow you want to
         *        delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The unique identifier of the build workflow to delete.
         * </p>
         * 
         * @param buildWorkflowId
         *        The unique identifier of the build workflow to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildWorkflowId(String buildWorkflowId);

        /**
         * <p>
         * The timestamp when the build workflow was last updated. This is used for optimistic concurrency control to
         * prevent accidental deletion of workflows that have been modified.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the build workflow was last updated. This is used for optimistic concurrency
         *        control to prevent accidental deletion of workflows that have been modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String policyArn;

        private String buildWorkflowId;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAutomatedReasoningPolicyBuildWorkflowRequest model) {
            super(model);
            policyArn(model.policyArn);
            buildWorkflowId(model.buildWorkflowId);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowId() {
            return buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAutomatedReasoningPolicyBuildWorkflowRequest build() {
            return new DeleteAutomatedReasoningPolicyBuildWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
