/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutomatedReasoningPolicyTestResultRequest extends BedrockRequest implements
        ToCopyableBuilder<GetAutomatedReasoningPolicyTestResultRequest.Builder, GetAutomatedReasoningPolicyTestResultRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(GetAutomatedReasoningPolicyTestResultRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()).build();

    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildWorkflowId").getter(getter(GetAutomatedReasoningPolicyTestResultRequest::buildWorkflowId))
            .setter(setter(Builder::buildWorkflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("buildWorkflowId").build()).build();

    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(GetAutomatedReasoningPolicyTestResultRequest::testCaseId))
            .setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testCaseId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            BUILD_WORKFLOW_ID_FIELD, TEST_CASE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String buildWorkflowId;

    private final String testCaseId;

    private GetAutomatedReasoningPolicyTestResultRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowId = builder.buildWorkflowId;
        this.testCaseId = builder.testCaseId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The build workflow identifier. The build workflow must display a <code>COMPLETED</code> status to get results.
     * </p>
     * 
     * @return The build workflow identifier. The build workflow must display a <code>COMPLETED</code> status to get
     *         results.
     */
    public final String buildWorkflowId() {
        return buildWorkflowId;
    }

    /**
     * <p>
     * The unique identifier of the test for which to retrieve results.
     * </p>
     * 
     * @return The unique identifier of the test for which to retrieve results.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(buildWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomatedReasoningPolicyTestResultRequest)) {
            return false;
        }
        GetAutomatedReasoningPolicyTestResultRequest other = (GetAutomatedReasoningPolicyTestResultRequest) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(buildWorkflowId(), other.buildWorkflowId())
                && Objects.equals(testCaseId(), other.testCaseId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutomatedReasoningPolicyTestResultRequest").add("PolicyArn", policyArn())
                .add("BuildWorkflowId", buildWorkflowId()).add("TestCaseId", testCaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "buildWorkflowId":
            return Optional.ofNullable(clazz.cast(buildWorkflowId()));
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutomatedReasoningPolicyTestResultRequest, T> g) {
        return obj -> g.apply((GetAutomatedReasoningPolicyTestResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutomatedReasoningPolicyTestResultRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The build workflow identifier. The build workflow must display a <code>COMPLETED</code> status to get
         * results.
         * </p>
         * 
         * @param buildWorkflowId
         *        The build workflow identifier. The build workflow must display a <code>COMPLETED</code> status to get
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildWorkflowId(String buildWorkflowId);

        /**
         * <p>
         * The unique identifier of the test for which to retrieve results.
         * </p>
         * 
         * @param testCaseId
         *        The unique identifier of the test for which to retrieve results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String policyArn;

        private String buildWorkflowId;

        private String testCaseId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomatedReasoningPolicyTestResultRequest model) {
            super(model);
            policyArn(model.policyArn);
            buildWorkflowId(model.buildWorkflowId);
            testCaseId(model.testCaseId);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowId() {
            return buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAutomatedReasoningPolicyTestResultRequest build() {
            return new GetAutomatedReasoningPolicyTestResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
