/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutomatedReasoningPolicyTestResultResponse extends BedrockResponse implements
        ToCopyableBuilder<GetAutomatedReasoningPolicyTestResultResponse.Builder, GetAutomatedReasoningPolicyTestResultResponse> {
    private static final SdkField<AutomatedReasoningPolicyTestResult> TEST_RESULT_FIELD = SdkField
            .<AutomatedReasoningPolicyTestResult> builder(MarshallingType.SDK_POJO).memberName("testResult")
            .getter(getter(GetAutomatedReasoningPolicyTestResultResponse::testResult)).setter(setter(Builder::testResult))
            .constructor(AutomatedReasoningPolicyTestResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AutomatedReasoningPolicyTestResult testResult;

    private GetAutomatedReasoningPolicyTestResultResponse(BuilderImpl builder) {
        super(builder);
        this.testResult = builder.testResult;
    }

    /**
     * <p>
     * The test result containing validation findings, execution status, and detailed analysis.
     * </p>
     * 
     * @return The test result containing validation findings, execution status, and detailed analysis.
     */
    public final AutomatedReasoningPolicyTestResult testResult() {
        return testResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomatedReasoningPolicyTestResultResponse)) {
            return false;
        }
        GetAutomatedReasoningPolicyTestResultResponse other = (GetAutomatedReasoningPolicyTestResultResponse) obj;
        return Objects.equals(testResult(), other.testResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutomatedReasoningPolicyTestResultResponse").add("TestResult", testResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testResult":
            return Optional.ofNullable(clazz.cast(testResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testResult", TEST_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutomatedReasoningPolicyTestResultResponse, T> g) {
        return obj -> g.apply((GetAutomatedReasoningPolicyTestResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutomatedReasoningPolicyTestResultResponse> {
        /**
         * <p>
         * The test result containing validation findings, execution status, and detailed analysis.
         * </p>
         * 
         * @param testResult
         *        The test result containing validation findings, execution status, and detailed analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testResult(AutomatedReasoningPolicyTestResult testResult);

        /**
         * <p>
         * The test result containing validation findings, execution status, and detailed analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyTestResult.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyTestResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyTestResult.Builder#build()} is called
         * immediately and its result is passed to {@link #testResult(AutomatedReasoningPolicyTestResult)}.
         * 
         * @param testResult
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyTestResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testResult(AutomatedReasoningPolicyTestResult)
         */
        default Builder testResult(Consumer<AutomatedReasoningPolicyTestResult.Builder> testResult) {
            return testResult(AutomatedReasoningPolicyTestResult.builder().applyMutation(testResult).build());
        }
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private AutomatedReasoningPolicyTestResult testResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomatedReasoningPolicyTestResultResponse model) {
            super(model);
            testResult(model.testResult);
        }

        public final AutomatedReasoningPolicyTestResult.Builder getTestResult() {
            return testResult != null ? testResult.toBuilder() : null;
        }

        public final void setTestResult(AutomatedReasoningPolicyTestResult.BuilderImpl testResult) {
            this.testResult = testResult != null ? testResult.build() : null;
        }

        @Override
        public final Builder testResult(AutomatedReasoningPolicyTestResult testResult) {
            this.testResult = testResult;
            return this;
        }

        @Override
        public GetAutomatedReasoningPolicyTestResultResponse build() {
            return new GetAutomatedReasoningPolicyTestResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
