/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFoundationModelAgreementOffersRequest extends BedrockRequest implements
        ToCopyableBuilder<ListFoundationModelAgreementOffersRequest.Builder, ListFoundationModelAgreementOffersRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(ListFoundationModelAgreementOffersRequest::modelId))
            .setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()).build();

    private static final SdkField<String> OFFER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offerType").getter(getter(ListFoundationModelAgreementOffersRequest::offerTypeAsString))
            .setter(setter(Builder::offerType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("offerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD,
            OFFER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelId;

    private final String offerType;

    private ListFoundationModelAgreementOffersRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.offerType = builder.offerType;
    }

    /**
     * <p>
     * Model Id of the foundation model.
     * </p>
     * 
     * @return Model Id of the foundation model.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * Type of offer associated with the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offerType} will
     * return {@link OfferType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offerTypeAsString}.
     * </p>
     * 
     * @return Type of offer associated with the model.
     * @see OfferType
     */
    public final OfferType offerType() {
        return OfferType.fromValue(offerType);
    }

    /**
     * <p>
     * Type of offer associated with the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offerType} will
     * return {@link OfferType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offerTypeAsString}.
     * </p>
     * 
     * @return Type of offer associated with the model.
     * @see OfferType
     */
    public final String offerTypeAsString() {
        return offerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(offerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoundationModelAgreementOffersRequest)) {
            return false;
        }
        ListFoundationModelAgreementOffersRequest other = (ListFoundationModelAgreementOffersRequest) obj;
        return Objects.equals(modelId(), other.modelId()) && Objects.equals(offerTypeAsString(), other.offerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFoundationModelAgreementOffersRequest").add("ModelId", modelId())
                .add("OfferType", offerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "offerType":
            return Optional.ofNullable(clazz.cast(offerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelId", MODEL_ID_FIELD);
        map.put("offerType", OFFER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFoundationModelAgreementOffersRequest, T> g) {
        return obj -> g.apply((ListFoundationModelAgreementOffersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFoundationModelAgreementOffersRequest> {
        /**
         * <p>
         * Model Id of the foundation model.
         * </p>
         * 
         * @param modelId
         *        Model Id of the foundation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * Type of offer associated with the model.
         * </p>
         * 
         * @param offerType
         *        Type of offer associated with the model.
         * @see OfferType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferType
         */
        Builder offerType(String offerType);

        /**
         * <p>
         * Type of offer associated with the model.
         * </p>
         * 
         * @param offerType
         *        Type of offer associated with the model.
         * @see OfferType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferType
         */
        Builder offerType(OfferType offerType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String modelId;

        private String offerType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoundationModelAgreementOffersRequest model) {
            super(model);
            modelId(model.modelId);
            offerType(model.offerType);
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getOfferType() {
            return offerType;
        }

        public final void setOfferType(String offerType) {
            this.offerType = offerType;
        }

        @Override
        public final Builder offerType(String offerType) {
            this.offerType = offerType;
            return this;
        }

        @Override
        public final Builder offerType(OfferType offerType) {
            this.offerType(offerType == null ? null : offerType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFoundationModelAgreementOffersRequest build() {
            return new ListFoundationModelAgreementOffersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
