/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration of the S3 location of the output data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelInvocationJobOutputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelInvocationJobOutputDataConfig.Builder, ModelInvocationJobOutputDataConfig> {
    private static final SdkField<ModelInvocationJobS3OutputDataConfig> S3_OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<ModelInvocationJobS3OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("s3OutputDataConfig")
            .getter(getter(ModelInvocationJobOutputDataConfig::s3OutputDataConfig)).setter(setter(Builder::s3OutputDataConfig))
            .constructor(ModelInvocationJobS3OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputDataConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_DATA_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ModelInvocationJobS3OutputDataConfig s3OutputDataConfig;

    private final Type type;

    private ModelInvocationJobOutputDataConfig(BuilderImpl builder) {
        this.s3OutputDataConfig = builder.s3OutputDataConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains the configuration of the S3 location of the output data.
     * </p>
     * 
     * @return Contains the configuration of the S3 location of the output data.
     */
    public final ModelInvocationJobS3OutputDataConfig s3OutputDataConfig() {
        return s3OutputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputDataConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInvocationJobOutputDataConfig)) {
            return false;
        }
        ModelInvocationJobOutputDataConfig other = (ModelInvocationJobOutputDataConfig) obj;
        return Objects.equals(s3OutputDataConfig(), other.s3OutputDataConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelInvocationJobOutputDataConfig").add("S3OutputDataConfig", s3OutputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3OutputDataConfig":
            return Optional.ofNullable(clazz.cast(s3OutputDataConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3OutputDataConfig()} initialized to the given value.
     *
     * <p>
     * Contains the configuration of the S3 location of the output data.
     * </p>
     * 
     * @param s3OutputDataConfig
     *        Contains the configuration of the S3 location of the output data.
     */
    public static ModelInvocationJobOutputDataConfig fromS3OutputDataConfig(
            ModelInvocationJobS3OutputDataConfig s3OutputDataConfig) {
        return builder().s3OutputDataConfig(s3OutputDataConfig).build();
    }

    /**
     * Create an instance of this class with {@link #s3OutputDataConfig()} initialized to the given value.
     *
     * <p>
     * Contains the configuration of the S3 location of the output data.
     * </p>
     * 
     * @param s3OutputDataConfig
     *        Contains the configuration of the S3 location of the output data.
     */
    public static ModelInvocationJobOutputDataConfig fromS3OutputDataConfig(
            Consumer<ModelInvocationJobS3OutputDataConfig.Builder> s3OutputDataConfig) {
        ModelInvocationJobS3OutputDataConfig.Builder builder = ModelInvocationJobS3OutputDataConfig.builder();
        s3OutputDataConfig.accept(builder);
        return fromS3OutputDataConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3OutputDataConfig", S3_OUTPUT_DATA_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelInvocationJobOutputDataConfig, T> g) {
        return obj -> g.apply((ModelInvocationJobOutputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelInvocationJobOutputDataConfig> {
        /**
         * <p>
         * Contains the configuration of the S3 location of the output data.
         * </p>
         * 
         * @param s3OutputDataConfig
         *        Contains the configuration of the S3 location of the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputDataConfig(ModelInvocationJobS3OutputDataConfig s3OutputDataConfig);

        /**
         * <p>
         * Contains the configuration of the S3 location of the output data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModelInvocationJobS3OutputDataConfig.Builder} avoiding the need to create one manually via
         * {@link ModelInvocationJobS3OutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInvocationJobS3OutputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #s3OutputDataConfig(ModelInvocationJobS3OutputDataConfig)}.
         * 
         * @param s3OutputDataConfig
         *        a consumer that will call methods on {@link ModelInvocationJobS3OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3OutputDataConfig(ModelInvocationJobS3OutputDataConfig)
         */
        default Builder s3OutputDataConfig(Consumer<ModelInvocationJobS3OutputDataConfig.Builder> s3OutputDataConfig) {
            return s3OutputDataConfig(ModelInvocationJobS3OutputDataConfig.builder().applyMutation(s3OutputDataConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModelInvocationJobS3OutputDataConfig s3OutputDataConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInvocationJobOutputDataConfig model) {
            s3OutputDataConfig(model.s3OutputDataConfig);
        }

        public final ModelInvocationJobS3OutputDataConfig.Builder getS3OutputDataConfig() {
            return s3OutputDataConfig != null ? s3OutputDataConfig.toBuilder() : null;
        }

        public final void setS3OutputDataConfig(ModelInvocationJobS3OutputDataConfig.BuilderImpl s3OutputDataConfig) {
            Object oldValue = this.s3OutputDataConfig;
            this.s3OutputDataConfig = s3OutputDataConfig != null ? s3OutputDataConfig.build() : null;
            handleUnionValueChange(Type.S3_OUTPUT_DATA_CONFIG, oldValue, this.s3OutputDataConfig);
        }

        @Override
        public final Builder s3OutputDataConfig(ModelInvocationJobS3OutputDataConfig s3OutputDataConfig) {
            Object oldValue = this.s3OutputDataConfig;
            this.s3OutputDataConfig = s3OutputDataConfig;
            handleUnionValueChange(Type.S3_OUTPUT_DATA_CONFIG, oldValue, this.s3OutputDataConfig);
            return this;
        }

        @Override
        public ModelInvocationJobOutputDataConfig build() {
            return new ModelInvocationJobOutputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ModelInvocationJobOutputDataConfig#type()
     */
    public enum Type {
        S3_OUTPUT_DATA_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
