/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An offer dictates usage terms for the model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Offer implements SdkPojo, Serializable, ToCopyableBuilder<Offer.Builder, Offer> {
    private static final SdkField<String> OFFER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offerId").getter(getter(Offer::offerId)).setter(setter(Builder::offerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offerId").build()).build();

    private static final SdkField<String> OFFER_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offerToken").getter(getter(Offer::offerToken)).setter(setter(Builder::offerToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offerToken").build()).build();

    private static final SdkField<TermDetails> TERM_DETAILS_FIELD = SdkField.<TermDetails> builder(MarshallingType.SDK_POJO)
            .memberName("termDetails").getter(getter(Offer::termDetails)).setter(setter(Builder::termDetails))
            .constructor(TermDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFER_ID_FIELD,
            OFFER_TOKEN_FIELD, TERM_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String offerId;

    private final String offerToken;

    private final TermDetails termDetails;

    private Offer(BuilderImpl builder) {
        this.offerId = builder.offerId;
        this.offerToken = builder.offerToken;
        this.termDetails = builder.termDetails;
    }

    /**
     * <p>
     * Offer Id for a model offer.
     * </p>
     * 
     * @return Offer Id for a model offer.
     */
    public final String offerId() {
        return offerId;
    }

    /**
     * <p>
     * Offer token.
     * </p>
     * 
     * @return Offer token.
     */
    public final String offerToken() {
        return offerToken;
    }

    /**
     * <p>
     * Details about the terms of the offer.
     * </p>
     * 
     * @return Details about the terms of the offer.
     */
    public final TermDetails termDetails() {
        return termDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offerId());
        hashCode = 31 * hashCode + Objects.hashCode(offerToken());
        hashCode = 31 * hashCode + Objects.hashCode(termDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offer)) {
            return false;
        }
        Offer other = (Offer) obj;
        return Objects.equals(offerId(), other.offerId()) && Objects.equals(offerToken(), other.offerToken())
                && Objects.equals(termDetails(), other.termDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Offer").add("OfferId", offerId()).add("OfferToken", offerToken())
                .add("TermDetails", termDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offerId":
            return Optional.ofNullable(clazz.cast(offerId()));
        case "offerToken":
            return Optional.ofNullable(clazz.cast(offerToken()));
        case "termDetails":
            return Optional.ofNullable(clazz.cast(termDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("offerId", OFFER_ID_FIELD);
        map.put("offerToken", OFFER_TOKEN_FIELD);
        map.put("termDetails", TERM_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Offer, T> g) {
        return obj -> g.apply((Offer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Offer> {
        /**
         * <p>
         * Offer Id for a model offer.
         * </p>
         * 
         * @param offerId
         *        Offer Id for a model offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerId(String offerId);

        /**
         * <p>
         * Offer token.
         * </p>
         * 
         * @param offerToken
         *        Offer token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerToken(String offerToken);

        /**
         * <p>
         * Details about the terms of the offer.
         * </p>
         * 
         * @param termDetails
         *        Details about the terms of the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termDetails(TermDetails termDetails);

        /**
         * <p>
         * Details about the terms of the offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TermDetails.Builder} avoiding the need to
         * create one manually via {@link TermDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TermDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #termDetails(TermDetails)}.
         * 
         * @param termDetails
         *        a consumer that will call methods on {@link TermDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #termDetails(TermDetails)
         */
        default Builder termDetails(Consumer<TermDetails.Builder> termDetails) {
            return termDetails(TermDetails.builder().applyMutation(termDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String offerId;

        private String offerToken;

        private TermDetails termDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Offer model) {
            offerId(model.offerId);
            offerToken(model.offerToken);
            termDetails(model.termDetails);
        }

        public final String getOfferId() {
            return offerId;
        }

        public final void setOfferId(String offerId) {
            this.offerId = offerId;
        }

        @Override
        public final Builder offerId(String offerId) {
            this.offerId = offerId;
            return this;
        }

        public final String getOfferToken() {
            return offerToken;
        }

        public final void setOfferToken(String offerToken) {
            this.offerToken = offerToken;
        }

        @Override
        public final Builder offerToken(String offerToken) {
            this.offerToken = offerToken;
            return this;
        }

        public final TermDetails.Builder getTermDetails() {
            return termDetails != null ? termDetails.toBuilder() : null;
        }

        public final void setTermDetails(TermDetails.BuilderImpl termDetails) {
            this.termDetails = termDetails != null ? termDetails.build() : null;
        }

        @Override
        public final Builder termDetails(TermDetails termDetails) {
            this.termDetails = termDetails;
            return this;
        }

        @Override
        public Offer build() {
            return new Offer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
