/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.CustomModelDeploymentStatus;
import software.amazon.awssdk.services.bedrock.model.SortModelsBy;
import software.amazon.awssdk.services.bedrock.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomModelDeploymentsRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, ListCustomModelDeploymentsRequest> {
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdBefore").getter(ListCustomModelDeploymentsRequest.getter(ListCustomModelDeploymentsRequest::createdBefore)).setter(ListCustomModelDeploymentsRequest.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAfter").getter(ListCustomModelDeploymentsRequest.getter(ListCustomModelDeploymentsRequest::createdAfter)).setter(ListCustomModelDeploymentsRequest.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nameContains").getter(ListCustomModelDeploymentsRequest.getter(ListCustomModelDeploymentsRequest::nameContains)).setter(ListCustomModelDeploymentsRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nameContains").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListCustomModelDeploymentsRequest.getter(ListCustomModelDeploymentsRequest::maxResults)).setter(ListCustomModelDeploymentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCustomModelDeploymentsRequest.getter(ListCustomModelDeploymentsRequest::nextToken)).setter(ListCustomModelDeploymentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(ListCustomModelDeploymentsRequest.getter(ListCustomModelDeploymentsRequest::sortByAsString)).setter(ListCustomModelDeploymentsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ListCustomModelDeploymentsRequest.getter(ListCustomModelDeploymentsRequest::sortOrderAsString)).setter(ListCustomModelDeploymentsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()}).build();
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusEquals").getter(ListCustomModelDeploymentsRequest.getter(ListCustomModelDeploymentsRequest::statusEqualsAsString)).setter(ListCustomModelDeploymentsRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statusEquals").build()}).build();
    private static final SdkField<String> MODEL_ARN_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArnEquals").getter(ListCustomModelDeploymentsRequest.getter(ListCustomModelDeploymentsRequest::modelArnEquals)).setter(ListCustomModelDeploymentsRequest.setter(Builder::modelArnEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("modelArnEquals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD, NAME_CONTAINS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, STATUS_EQUALS_FIELD, MODEL_ARN_EQUALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCustomModelDeploymentsRequest.memberNameToFieldInitializer();
    private final Instant createdBefore;
    private final Instant createdAfter;
    private final String nameContains;
    private final Integer maxResults;
    private final String nextToken;
    private final String sortBy;
    private final String sortOrder;
    private final String statusEquals;
    private final String modelArnEquals;

    private ListCustomModelDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
        this.nameContains = builder.nameContains;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.statusEquals = builder.statusEquals;
        this.modelArnEquals = builder.modelArnEquals;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final String nameContains() {
        return this.nameContains;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final SortModelsBy sortBy() {
        return SortModelsBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final CustomModelDeploymentStatus statusEquals() {
        return CustomModelDeploymentStatus.fromValue(this.statusEquals);
    }

    public final String statusEqualsAsString() {
        return this.statusEquals;
    }

    public final String modelArnEquals() {
        return this.modelArnEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArnEquals());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomModelDeploymentsRequest)) {
            return false;
        }
        ListCustomModelDeploymentsRequest other = (ListCustomModelDeploymentsRequest)((Object)obj);
        return Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString()) && Objects.equals(this.modelArnEquals(), other.modelArnEquals());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomModelDeploymentsRequest").add("CreatedBefore", (Object)this.createdBefore()).add("CreatedAfter", (Object)this.createdAfter()).add("NameContains", (Object)this.nameContains()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("StatusEquals", (Object)this.statusEqualsAsString()).add("ModelArnEquals", (Object)this.modelArnEquals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "createdAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "nameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "statusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
            case "modelArnEquals": {
                return Optional.ofNullable(clazz.cast(this.modelArnEquals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdBefore", CREATED_BEFORE_FIELD);
        map.put("createdAfter", CREATED_AFTER_FIELD);
        map.put("nameContains", NAME_CONTAINS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("statusEquals", STATUS_EQUALS_FIELD);
        map.put("modelArnEquals", MODEL_ARN_EQUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomModelDeploymentsRequest, T> g) {
        return obj -> g.apply((ListCustomModelDeploymentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private Instant createdBefore;
        private Instant createdAfter;
        private String nameContains;
        private Integer maxResults;
        private String nextToken;
        private String sortBy;
        private String sortOrder;
        private String statusEquals;
        private String modelArnEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomModelDeploymentsRequest model) {
            super(model);
            this.createdBefore(model.createdBefore);
            this.createdAfter(model.createdAfter);
            this.nameContains(model.nameContains);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.statusEquals(model.statusEquals);
            this.modelArnEquals(model.modelArnEquals);
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortModelsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getStatusEquals() {
            return this.statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(CustomModelDeploymentStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getModelArnEquals() {
            return this.modelArnEquals;
        }

        public final void setModelArnEquals(String modelArnEquals) {
            this.modelArnEquals = modelArnEquals;
        }

        @Override
        public final Builder modelArnEquals(String modelArnEquals) {
            this.modelArnEquals = modelArnEquals;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomModelDeploymentsRequest build() {
            return new ListCustomModelDeploymentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomModelDeploymentsRequest> {
        public Builder createdBefore(Instant var1);

        public Builder createdAfter(Instant var1);

        public Builder nameContains(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(SortModelsBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder statusEquals(String var1);

        public Builder statusEquals(CustomModelDeploymentStatus var1);

        public Builder modelArnEquals(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

