/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the claims could be either true or false depending on additional assumptions not provided in the
 * input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningCheckSatisfiableFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningCheckSatisfiableFinding.Builder, AutomatedReasoningCheckSatisfiableFinding> {
    private static final SdkField<AutomatedReasoningCheckTranslation> TRANSLATION_FIELD = SdkField
            .<AutomatedReasoningCheckTranslation> builder(MarshallingType.SDK_POJO).memberName("translation")
            .getter(getter(AutomatedReasoningCheckSatisfiableFinding::translation)).setter(setter(Builder::translation))
            .constructor(AutomatedReasoningCheckTranslation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()).build();

    private static final SdkField<AutomatedReasoningCheckScenario> CLAIMS_TRUE_SCENARIO_FIELD = SdkField
            .<AutomatedReasoningCheckScenario> builder(MarshallingType.SDK_POJO).memberName("claimsTrueScenario")
            .getter(getter(AutomatedReasoningCheckSatisfiableFinding::claimsTrueScenario))
            .setter(setter(Builder::claimsTrueScenario)).constructor(AutomatedReasoningCheckScenario::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsTrueScenario").build())
            .build();

    private static final SdkField<AutomatedReasoningCheckScenario> CLAIMS_FALSE_SCENARIO_FIELD = SdkField
            .<AutomatedReasoningCheckScenario> builder(MarshallingType.SDK_POJO).memberName("claimsFalseScenario")
            .getter(getter(AutomatedReasoningCheckSatisfiableFinding::claimsFalseScenario))
            .setter(setter(Builder::claimsFalseScenario)).constructor(AutomatedReasoningCheckScenario::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsFalseScenario").build())
            .build();

    private static final SdkField<AutomatedReasoningCheckLogicWarning> LOGIC_WARNING_FIELD = SdkField
            .<AutomatedReasoningCheckLogicWarning> builder(MarshallingType.SDK_POJO).memberName("logicWarning")
            .getter(getter(AutomatedReasoningCheckSatisfiableFinding::logicWarning)).setter(setter(Builder::logicWarning))
            .constructor(AutomatedReasoningCheckLogicWarning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD,
            CLAIMS_TRUE_SCENARIO_FIELD, CLAIMS_FALSE_SCENARIO_FIELD, LOGIC_WARNING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningCheckTranslation translation;

    private final AutomatedReasoningCheckScenario claimsTrueScenario;

    private final AutomatedReasoningCheckScenario claimsFalseScenario;

    private final AutomatedReasoningCheckLogicWarning logicWarning;

    private AutomatedReasoningCheckSatisfiableFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.claimsTrueScenario = builder.claimsTrueScenario;
        this.claimsFalseScenario = builder.claimsFalseScenario;
        this.logicWarning = builder.logicWarning;
    }

    /**
     * <p>
     * The logical translation of the input that this finding evaluates.
     * </p>
     * 
     * @return The logical translation of the input that this finding evaluates.
     */
    public final AutomatedReasoningCheckTranslation translation() {
        return translation;
    }

    /**
     * <p>
     * An example scenario demonstrating how the claims could be logically true.
     * </p>
     * 
     * @return An example scenario demonstrating how the claims could be logically true.
     */
    public final AutomatedReasoningCheckScenario claimsTrueScenario() {
        return claimsTrueScenario;
    }

    /**
     * <p>
     * An example scenario demonstrating how the claims could be logically false.
     * </p>
     * 
     * @return An example scenario demonstrating how the claims could be logically false.
     */
    public final AutomatedReasoningCheckScenario claimsFalseScenario() {
        return claimsFalseScenario;
    }

    /**
     * <p>
     * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
     * rules.
     * </p>
     * 
     * @return Indication of a logic issue with the translation without needing to consider the automated reasoning
     *         policy rules.
     */
    public final AutomatedReasoningCheckLogicWarning logicWarning() {
        return logicWarning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(translation());
        hashCode = 31 * hashCode + Objects.hashCode(claimsTrueScenario());
        hashCode = 31 * hashCode + Objects.hashCode(claimsFalseScenario());
        hashCode = 31 * hashCode + Objects.hashCode(logicWarning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckSatisfiableFinding)) {
            return false;
        }
        AutomatedReasoningCheckSatisfiableFinding other = (AutomatedReasoningCheckSatisfiableFinding) obj;
        return Objects.equals(translation(), other.translation())
                && Objects.equals(claimsTrueScenario(), other.claimsTrueScenario())
                && Objects.equals(claimsFalseScenario(), other.claimsFalseScenario())
                && Objects.equals(logicWarning(), other.logicWarning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningCheckSatisfiableFinding").add("Translation", translation())
                .add("ClaimsTrueScenario", claimsTrueScenario()).add("ClaimsFalseScenario", claimsFalseScenario())
                .add("LogicWarning", logicWarning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "translation":
            return Optional.ofNullable(clazz.cast(translation()));
        case "claimsTrueScenario":
            return Optional.ofNullable(clazz.cast(claimsTrueScenario()));
        case "claimsFalseScenario":
            return Optional.ofNullable(clazz.cast(claimsFalseScenario()));
        case "logicWarning":
            return Optional.ofNullable(clazz.cast(logicWarning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("claimsTrueScenario", CLAIMS_TRUE_SCENARIO_FIELD);
        map.put("claimsFalseScenario", CLAIMS_FALSE_SCENARIO_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckSatisfiableFinding, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckSatisfiableFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningCheckSatisfiableFinding> {
        /**
         * <p>
         * The logical translation of the input that this finding evaluates.
         * </p>
         * 
         * @param translation
         *        The logical translation of the input that this finding evaluates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translation(AutomatedReasoningCheckTranslation translation);

        /**
         * <p>
         * The logical translation of the input that this finding evaluates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckTranslation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckTranslation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckTranslation.Builder#build()} is called
         * immediately and its result is passed to {@link #translation(AutomatedReasoningCheckTranslation)}.
         * 
         * @param translation
         *        a consumer that will call methods on {@link AutomatedReasoningCheckTranslation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #translation(AutomatedReasoningCheckTranslation)
         */
        default Builder translation(Consumer<AutomatedReasoningCheckTranslation.Builder> translation) {
            return translation(AutomatedReasoningCheckTranslation.builder().applyMutation(translation).build());
        }

        /**
         * <p>
         * An example scenario demonstrating how the claims could be logically true.
         * </p>
         * 
         * @param claimsTrueScenario
         *        An example scenario demonstrating how the claims could be logically true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimsTrueScenario(AutomatedReasoningCheckScenario claimsTrueScenario);

        /**
         * <p>
         * An example scenario demonstrating how the claims could be logically true.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedReasoningCheckScenario.Builder}
         * avoiding the need to create one manually via {@link AutomatedReasoningCheckScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckScenario.Builder#build()} is called
         * immediately and its result is passed to {@link #claimsTrueScenario(AutomatedReasoningCheckScenario)}.
         * 
         * @param claimsTrueScenario
         *        a consumer that will call methods on {@link AutomatedReasoningCheckScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #claimsTrueScenario(AutomatedReasoningCheckScenario)
         */
        default Builder claimsTrueScenario(Consumer<AutomatedReasoningCheckScenario.Builder> claimsTrueScenario) {
            return claimsTrueScenario(AutomatedReasoningCheckScenario.builder().applyMutation(claimsTrueScenario).build());
        }

        /**
         * <p>
         * An example scenario demonstrating how the claims could be logically false.
         * </p>
         * 
         * @param claimsFalseScenario
         *        An example scenario demonstrating how the claims could be logically false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimsFalseScenario(AutomatedReasoningCheckScenario claimsFalseScenario);

        /**
         * <p>
         * An example scenario demonstrating how the claims could be logically false.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedReasoningCheckScenario.Builder}
         * avoiding the need to create one manually via {@link AutomatedReasoningCheckScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckScenario.Builder#build()} is called
         * immediately and its result is passed to {@link #claimsFalseScenario(AutomatedReasoningCheckScenario)}.
         * 
         * @param claimsFalseScenario
         *        a consumer that will call methods on {@link AutomatedReasoningCheckScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #claimsFalseScenario(AutomatedReasoningCheckScenario)
         */
        default Builder claimsFalseScenario(Consumer<AutomatedReasoningCheckScenario.Builder> claimsFalseScenario) {
            return claimsFalseScenario(AutomatedReasoningCheckScenario.builder().applyMutation(claimsFalseScenario).build());
        }

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * 
         * @param logicWarning
         *        Indication of a logic issue with the translation without needing to consider the automated reasoning
         *        policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicWarning(AutomatedReasoningCheckLogicWarning logicWarning);

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckLogicWarning.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckLogicWarning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckLogicWarning.Builder#build()} is called
         * immediately and its result is passed to {@link #logicWarning(AutomatedReasoningCheckLogicWarning)}.
         * 
         * @param logicWarning
         *        a consumer that will call methods on {@link AutomatedReasoningCheckLogicWarning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logicWarning(AutomatedReasoningCheckLogicWarning)
         */
        default Builder logicWarning(Consumer<AutomatedReasoningCheckLogicWarning.Builder> logicWarning) {
            return logicWarning(AutomatedReasoningCheckLogicWarning.builder().applyMutation(logicWarning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningCheckTranslation translation;

        private AutomatedReasoningCheckScenario claimsTrueScenario;

        private AutomatedReasoningCheckScenario claimsFalseScenario;

        private AutomatedReasoningCheckLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckSatisfiableFinding model) {
            translation(model.translation);
            claimsTrueScenario(model.claimsTrueScenario);
            claimsFalseScenario(model.claimsFalseScenario);
            logicWarning(model.logicWarning);
        }

        public final AutomatedReasoningCheckTranslation.Builder getTranslation() {
            return translation != null ? translation.toBuilder() : null;
        }

        public final void setTranslation(AutomatedReasoningCheckTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(AutomatedReasoningCheckTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final AutomatedReasoningCheckScenario.Builder getClaimsTrueScenario() {
            return claimsTrueScenario != null ? claimsTrueScenario.toBuilder() : null;
        }

        public final void setClaimsTrueScenario(AutomatedReasoningCheckScenario.BuilderImpl claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario != null ? claimsTrueScenario.build() : null;
        }

        @Override
        public final Builder claimsTrueScenario(AutomatedReasoningCheckScenario claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario;
            return this;
        }

        public final AutomatedReasoningCheckScenario.Builder getClaimsFalseScenario() {
            return claimsFalseScenario != null ? claimsFalseScenario.toBuilder() : null;
        }

        public final void setClaimsFalseScenario(AutomatedReasoningCheckScenario.BuilderImpl claimsFalseScenario) {
            this.claimsFalseScenario = claimsFalseScenario != null ? claimsFalseScenario.build() : null;
        }

        @Override
        public final Builder claimsFalseScenario(AutomatedReasoningCheckScenario claimsFalseScenario) {
            this.claimsFalseScenario = claimsFalseScenario;
            return this;
        }

        public final AutomatedReasoningCheckLogicWarning.Builder getLogicWarning() {
            return logicWarning != null ? logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(AutomatedReasoningCheckLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(AutomatedReasoningCheckLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        @Override
        public AutomatedReasoningCheckSatisfiableFinding build() {
            return new AutomatedReasoningCheckSatisfiableFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
