/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a logical statement that can be expressed both in formal logic notation and natural language, providing
 * dual representations for better understanding and validation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningLogicStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningLogicStatement.Builder, AutomatedReasoningLogicStatement> {
    private static final SdkField<String> LOGIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logic")
            .getter(getter(AutomatedReasoningLogicStatement::logic)).setter(setter(Builder::logic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logic").build()).build();

    private static final SdkField<String> NATURAL_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("naturalLanguage").getter(getter(AutomatedReasoningLogicStatement::naturalLanguage))
            .setter(setter(Builder::naturalLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("naturalLanguage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGIC_FIELD,
            NATURAL_LANGUAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logic;

    private final String naturalLanguage;

    private AutomatedReasoningLogicStatement(BuilderImpl builder) {
        this.logic = builder.logic;
        this.naturalLanguage = builder.naturalLanguage;
    }

    /**
     * <p>
     * The formal logic representation of the statement using mathematical notation and logical operators.
     * </p>
     * 
     * @return The formal logic representation of the statement using mathematical notation and logical operators.
     */
    public final String logic() {
        return logic;
    }

    /**
     * <p>
     * The natural language representation of the logical statement, providing a human-readable interpretation of the
     * formal logic.
     * </p>
     * 
     * @return The natural language representation of the logical statement, providing a human-readable interpretation
     *         of the formal logic.
     */
    public final String naturalLanguage() {
        return naturalLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logic());
        hashCode = 31 * hashCode + Objects.hashCode(naturalLanguage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningLogicStatement)) {
            return false;
        }
        AutomatedReasoningLogicStatement other = (AutomatedReasoningLogicStatement) obj;
        return Objects.equals(logic(), other.logic()) && Objects.equals(naturalLanguage(), other.naturalLanguage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningLogicStatement")
                .add("Logic", logic() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NaturalLanguage", naturalLanguage() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logic":
            return Optional.ofNullable(clazz.cast(logic()));
        case "naturalLanguage":
            return Optional.ofNullable(clazz.cast(naturalLanguage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logic", LOGIC_FIELD);
        map.put("naturalLanguage", NATURAL_LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningLogicStatement, T> g) {
        return obj -> g.apply((AutomatedReasoningLogicStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningLogicStatement> {
        /**
         * <p>
         * The formal logic representation of the statement using mathematical notation and logical operators.
         * </p>
         * 
         * @param logic
         *        The formal logic representation of the statement using mathematical notation and logical operators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logic(String logic);

        /**
         * <p>
         * The natural language representation of the logical statement, providing a human-readable interpretation of
         * the formal logic.
         * </p>
         * 
         * @param naturalLanguage
         *        The natural language representation of the logical statement, providing a human-readable
         *        interpretation of the formal logic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder naturalLanguage(String naturalLanguage);
    }

    static final class BuilderImpl implements Builder {
        private String logic;

        private String naturalLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningLogicStatement model) {
            logic(model.logic);
            naturalLanguage(model.naturalLanguage);
        }

        public final String getLogic() {
            return logic;
        }

        public final void setLogic(String logic) {
            this.logic = logic;
        }

        @Override
        public final Builder logic(String logic) {
            this.logic = logic;
            return this;
        }

        public final String getNaturalLanguage() {
            return naturalLanguage;
        }

        public final void setNaturalLanguage(String naturalLanguage) {
            this.naturalLanguage = naturalLanguage;
        }

        @Override
        public final Builder naturalLanguage(String naturalLanguage) {
            this.naturalLanguage = naturalLanguage;
            return this;
        }

        @Override
        public AutomatedReasoningLogicStatement build() {
            return new AutomatedReasoningLogicStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
