/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mutation operation that adds a new rule to the policy definition during the build process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyAddRuleMutation implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyAddRuleMutation.Builder, AutomatedReasoningPolicyAddRuleMutation> {
    private static final SdkField<AutomatedReasoningPolicyDefinitionRule> RULE_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinitionRule> builder(MarshallingType.SDK_POJO).memberName("rule")
            .getter(getter(AutomatedReasoningPolicyAddRuleMutation::rule)).setter(setter(Builder::rule))
            .constructor(AutomatedReasoningPolicyDefinitionRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyDefinitionRule rule;

    private AutomatedReasoningPolicyAddRuleMutation(BuilderImpl builder) {
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The rule definition that specifies the formal logical expression and metadata for the new rule being added to the
     * policy.
     * </p>
     * 
     * @return The rule definition that specifies the formal logical expression and metadata for the new rule being
     *         added to the policy.
     */
    public final AutomatedReasoningPolicyDefinitionRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyAddRuleMutation)) {
            return false;
        }
        AutomatedReasoningPolicyAddRuleMutation other = (AutomatedReasoningPolicyAddRuleMutation) obj;
        return Objects.equals(rule(), other.rule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyAddRuleMutation").add("Rule", rule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rule":
            return Optional.ofNullable(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rule", RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyAddRuleMutation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyAddRuleMutation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyAddRuleMutation> {
        /**
         * <p>
         * The rule definition that specifies the formal logical expression and metadata for the new rule being added to
         * the policy.
         * </p>
         * 
         * @param rule
         *        The rule definition that specifies the formal logical expression and metadata for the new rule being
         *        added to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(AutomatedReasoningPolicyDefinitionRule rule);

        /**
         * <p>
         * The rule definition that specifies the formal logical expression and metadata for the new rule being added to
         * the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinitionRule.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinitionRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinitionRule.Builder#build()} is called
         * immediately and its result is passed to {@link #rule(AutomatedReasoningPolicyDefinitionRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinitionRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(AutomatedReasoningPolicyDefinitionRule)
         */
        default Builder rule(Consumer<AutomatedReasoningPolicyDefinitionRule.Builder> rule) {
            return rule(AutomatedReasoningPolicyDefinitionRule.builder().applyMutation(rule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyDefinitionRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyAddRuleMutation model) {
            rule(model.rule);
        }

        public final AutomatedReasoningPolicyDefinitionRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(AutomatedReasoningPolicyDefinitionRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(AutomatedReasoningPolicyDefinitionRule rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyAddRuleMutation build() {
            return new AutomatedReasoningPolicyAddRuleMutation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
