/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mutation operation that adds a new variable to the policy definition during the build process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyAddVariableMutation implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyAddVariableMutation.Builder, AutomatedReasoningPolicyAddVariableMutation> {
    private static final SdkField<AutomatedReasoningPolicyDefinitionVariable> VARIABLE_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinitionVariable> builder(MarshallingType.SDK_POJO).memberName("variable")
            .getter(getter(AutomatedReasoningPolicyAddVariableMutation::variable)).setter(setter(Builder::variable))
            .constructor(AutomatedReasoningPolicyDefinitionVariable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyDefinitionVariable variable;

    private AutomatedReasoningPolicyAddVariableMutation(BuilderImpl builder) {
        this.variable = builder.variable;
    }

    /**
     * <p>
     * The variable definition that specifies the name, type, and description for the new variable being added to the
     * policy.
     * </p>
     * 
     * @return The variable definition that specifies the name, type, and description for the new variable being added
     *         to the policy.
     */
    public final AutomatedReasoningPolicyDefinitionVariable variable() {
        return variable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(variable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyAddVariableMutation)) {
            return false;
        }
        AutomatedReasoningPolicyAddVariableMutation other = (AutomatedReasoningPolicyAddVariableMutation) obj;
        return Objects.equals(variable(), other.variable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyAddVariableMutation").add("Variable", variable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "variable":
            return Optional.ofNullable(clazz.cast(variable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("variable", VARIABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyAddVariableMutation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyAddVariableMutation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyAddVariableMutation> {
        /**
         * <p>
         * The variable definition that specifies the name, type, and description for the new variable being added to
         * the policy.
         * </p>
         * 
         * @param variable
         *        The variable definition that specifies the name, type, and description for the new variable being
         *        added to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variable(AutomatedReasoningPolicyDefinitionVariable variable);

        /**
         * <p>
         * The variable definition that specifies the name, type, and description for the new variable being added to
         * the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinitionVariable.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinitionVariable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinitionVariable.Builder#build()} is
         * called immediately and its result is passed to {@link #variable(AutomatedReasoningPolicyDefinitionVariable)}.
         * 
         * @param variable
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinitionVariable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variable(AutomatedReasoningPolicyDefinitionVariable)
         */
        default Builder variable(Consumer<AutomatedReasoningPolicyDefinitionVariable.Builder> variable) {
            return variable(AutomatedReasoningPolicyDefinitionVariable.builder().applyMutation(variable).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyDefinitionVariable variable;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyAddVariableMutation model) {
            variable(model.variable);
        }

        public final AutomatedReasoningPolicyDefinitionVariable.Builder getVariable() {
            return variable != null ? variable.toBuilder() : null;
        }

        public final void setVariable(AutomatedReasoningPolicyDefinitionVariable.BuilderImpl variable) {
            this.variable = variable != null ? variable.build() : null;
        }

        @Override
        public final Builder variable(AutomatedReasoningPolicyDefinitionVariable variable) {
            this.variable = variable;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyAddVariableMutation build() {
            return new AutomatedReasoningPolicyAddVariableMutation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
