/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the formal logic rules, variables, and custom variable types that define an Automated Reasoning policy. The
 * policy definition specifies the constraints used to validate foundation model responses for accuracy and logical
 * consistency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyDefinition.Builder, AutomatedReasoningPolicyDefinition> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(AutomatedReasoningPolicyDefinition::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyDefinitionType>> TYPES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyDefinitionType>> builder(MarshallingType.LIST)
            .memberName("types")
            .getter(getter(AutomatedReasoningPolicyDefinition::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyDefinitionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyDefinitionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyDefinitionRule>> RULES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyDefinitionRule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(AutomatedReasoningPolicyDefinition::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyDefinitionRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyDefinitionRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyDefinitionVariable>> VARIABLES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyDefinitionVariable>> builder(MarshallingType.LIST)
            .memberName("variables")
            .getter(getter(AutomatedReasoningPolicyDefinition::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyDefinitionVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyDefinitionVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, TYPES_FIELD,
            RULES_FIELD, VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String version;

    private final List<AutomatedReasoningPolicyDefinitionType> types;

    private final List<AutomatedReasoningPolicyDefinitionRule> rules;

    private final List<AutomatedReasoningPolicyDefinitionVariable> variables;

    private AutomatedReasoningPolicyDefinition(BuilderImpl builder) {
        this.version = builder.version;
        this.types = builder.types;
        this.rules = builder.rules;
        this.variables = builder.variables;
    }

    /**
     * <p>
     * The version of the policy definition format.
     * </p>
     * 
     * @return The version of the policy definition format.
     */
    public final String version() {
        return version;
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom user-defined vairable types used in the policy. Types are enum-based variable types that provide
     * additional context beyond the predefined variable types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The custom user-defined vairable types used in the policy. Types are enum-based variable types that
     *         provide additional context beyond the predefined variable types.
     */
    public final List<AutomatedReasoningPolicyDefinitionType> types() {
        return types;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The formal logic rules extracted from the source document. Rules define the logical constraints that determine
     * whether model responses are valid, invalid, or satisfiable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The formal logic rules extracted from the source document. Rules define the logical constraints that
     *         determine whether model responses are valid, invalid, or satisfiable.
     */
    public final List<AutomatedReasoningPolicyDefinitionRule> rules() {
        return rules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The variables that represent concepts in the policy. Variables can have values assigned when translating natural
     * language into formal logic. Their descriptions are crucial for accurate translation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return The variables that represent concepts in the policy. Variables can have values assigned when translating
     *         natural language into formal logic. Their descriptions are crucial for accurate translation.
     */
    public final List<AutomatedReasoningPolicyDefinitionVariable> variables() {
        return variables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDefinition)) {
            return false;
        }
        AutomatedReasoningPolicyDefinition other = (AutomatedReasoningPolicyDefinition) obj;
        return Objects.equals(version(), other.version()) && hasTypes() == other.hasTypes()
                && Objects.equals(types(), other.types()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && hasVariables() == other.hasVariables()
                && Objects.equals(variables(), other.variables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyDefinition").add("Version", version())
                .add("Types", hasTypes() ? types() : null).add("Rules", hasRules() ? rules() : null)
                .add("Variables", hasVariables() ? variables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "types":
            return Optional.ofNullable(clazz.cast(types()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("version", VERSION_FIELD);
        map.put("types", TYPES_FIELD);
        map.put("rules", RULES_FIELD);
        map.put("variables", VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDefinition, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyDefinition> {
        /**
         * <p>
         * The version of the policy definition format.
         * </p>
         * 
         * @param version
         *        The version of the policy definition format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The custom user-defined vairable types used in the policy. Types are enum-based variable types that provide
         * additional context beyond the predefined variable types.
         * </p>
         * 
         * @param types
         *        The custom user-defined vairable types used in the policy. Types are enum-based variable types that
         *        provide additional context beyond the predefined variable types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<AutomatedReasoningPolicyDefinitionType> types);

        /**
         * <p>
         * The custom user-defined vairable types used in the policy. Types are enum-based variable types that provide
         * additional context beyond the predefined variable types.
         * </p>
         * 
         * @param types
         *        The custom user-defined vairable types used in the policy. Types are enum-based variable types that
         *        provide additional context beyond the predefined variable types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(AutomatedReasoningPolicyDefinitionType... types);

        /**
         * <p>
         * The custom user-defined vairable types used in the policy. Types are enum-based variable types that provide
         * additional context beyond the predefined variable types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionType.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionType.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #types(List<AutomatedReasoningPolicyDefinitionType>)}.
         * 
         * @param types
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #types(java.util.Collection<AutomatedReasoningPolicyDefinitionType>)
         */
        Builder types(Consumer<AutomatedReasoningPolicyDefinitionType.Builder>... types);

        /**
         * <p>
         * The formal logic rules extracted from the source document. Rules define the logical constraints that
         * determine whether model responses are valid, invalid, or satisfiable.
         * </p>
         * 
         * @param rules
         *        The formal logic rules extracted from the source document. Rules define the logical constraints that
         *        determine whether model responses are valid, invalid, or satisfiable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<AutomatedReasoningPolicyDefinitionRule> rules);

        /**
         * <p>
         * The formal logic rules extracted from the source document. Rules define the logical constraints that
         * determine whether model responses are valid, invalid, or satisfiable.
         * </p>
         * 
         * @param rules
         *        The formal logic rules extracted from the source document. Rules define the logical constraints that
         *        determine whether model responses are valid, invalid, or satisfiable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(AutomatedReasoningPolicyDefinitionRule... rules);

        /**
         * <p>
         * The formal logic rules extracted from the source document. Rules define the logical constraints that
         * determine whether model responses are valid, invalid, or satisfiable.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionRule.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionRule.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #rules(List<AutomatedReasoningPolicyDefinitionRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<AutomatedReasoningPolicyDefinitionRule>)
         */
        Builder rules(Consumer<AutomatedReasoningPolicyDefinitionRule.Builder>... rules);

        /**
         * <p>
         * The variables that represent concepts in the policy. Variables can have values assigned when translating
         * natural language into formal logic. Their descriptions are crucial for accurate translation.
         * </p>
         * 
         * @param variables
         *        The variables that represent concepts in the policy. Variables can have values assigned when
         *        translating natural language into formal logic. Their descriptions are crucial for accurate
         *        translation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Collection<AutomatedReasoningPolicyDefinitionVariable> variables);

        /**
         * <p>
         * The variables that represent concepts in the policy. Variables can have values assigned when translating
         * natural language into formal logic. Their descriptions are crucial for accurate translation.
         * </p>
         * 
         * @param variables
         *        The variables that represent concepts in the policy. Variables can have values assigned when
         *        translating natural language into formal logic. Their descriptions are crucial for accurate
         *        translation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(AutomatedReasoningPolicyDefinitionVariable... variables);

        /**
         * <p>
         * The variables that represent concepts in the policy. Variables can have values assigned when translating
         * natural language into formal logic. Their descriptions are crucial for accurate translation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionVariable.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionVariable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionVariable.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #variables(List<AutomatedReasoningPolicyDefinitionVariable>)}.
         * 
         * @param variables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionVariable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variables(java.util.Collection<AutomatedReasoningPolicyDefinitionVariable>)
         */
        Builder variables(Consumer<AutomatedReasoningPolicyDefinitionVariable.Builder>... variables);
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private List<AutomatedReasoningPolicyDefinitionType> types = DefaultSdkAutoConstructList.getInstance();

        private List<AutomatedReasoningPolicyDefinitionRule> rules = DefaultSdkAutoConstructList.getInstance();

        private List<AutomatedReasoningPolicyDefinitionVariable> variables = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDefinition model) {
            version(model.version);
            types(model.types);
            rules(model.rules);
            variables(model.variables);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final List<AutomatedReasoningPolicyDefinitionType.Builder> getTypes() {
            List<AutomatedReasoningPolicyDefinitionType.Builder> result = AutomatedReasoningPolicyDefinitionTypeListCopier
                    .copyToBuilder(this.types);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTypes(Collection<AutomatedReasoningPolicyDefinitionType.BuilderImpl> types) {
            this.types = AutomatedReasoningPolicyDefinitionTypeListCopier.copyFromBuilder(types);
        }

        @Override
        public final Builder types(Collection<AutomatedReasoningPolicyDefinitionType> types) {
            this.types = AutomatedReasoningPolicyDefinitionTypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(AutomatedReasoningPolicyDefinitionType... types) {
            types(Arrays.asList(types));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(Consumer<AutomatedReasoningPolicyDefinitionType.Builder>... types) {
            types(Stream.of(types).map(c -> AutomatedReasoningPolicyDefinitionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningPolicyDefinitionRule.Builder> getRules() {
            List<AutomatedReasoningPolicyDefinitionRule.Builder> result = AutomatedReasoningPolicyDefinitionRuleListCopier
                    .copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AutomatedReasoningPolicyDefinitionRule.BuilderImpl> rules) {
            this.rules = AutomatedReasoningPolicyDefinitionRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AutomatedReasoningPolicyDefinitionRule> rules) {
            this.rules = AutomatedReasoningPolicyDefinitionRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AutomatedReasoningPolicyDefinitionRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AutomatedReasoningPolicyDefinitionRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> AutomatedReasoningPolicyDefinitionRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningPolicyDefinitionVariable.Builder> getVariables() {
            List<AutomatedReasoningPolicyDefinitionVariable.Builder> result = AutomatedReasoningPolicyDefinitionVariableListCopier
                    .copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<AutomatedReasoningPolicyDefinitionVariable.BuilderImpl> variables) {
            this.variables = AutomatedReasoningPolicyDefinitionVariableListCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<AutomatedReasoningPolicyDefinitionVariable> variables) {
            this.variables = AutomatedReasoningPolicyDefinitionVariableListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(AutomatedReasoningPolicyDefinitionVariable... variables) {
            variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<AutomatedReasoningPolicyDefinitionVariable.Builder>... variables) {
            variables(Stream.of(variables)
                    .map(c -> AutomatedReasoningPolicyDefinitionVariable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedReasoningPolicyDefinition build() {
            return new AutomatedReasoningPolicyDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
