/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single element in an Automated Reasoning policy definition, such as a rule, variable, or type
 * definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyDefinitionElement implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyDefinitionElement.Builder, AutomatedReasoningPolicyDefinitionElement> {
    private static final SdkField<AutomatedReasoningPolicyDefinitionVariable> POLICY_DEFINITION_VARIABLE_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinitionVariable> builder(MarshallingType.SDK_POJO)
            .memberName("policyDefinitionVariable")
            .getter(getter(AutomatedReasoningPolicyDefinitionElement::policyDefinitionVariable))
            .setter(setter(Builder::policyDefinitionVariable)).constructor(AutomatedReasoningPolicyDefinitionVariable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDefinitionVariable").build())
            .build();

    private static final SdkField<AutomatedReasoningPolicyDefinitionType> POLICY_DEFINITION_TYPE_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinitionType> builder(MarshallingType.SDK_POJO).memberName("policyDefinitionType")
            .getter(getter(AutomatedReasoningPolicyDefinitionElement::policyDefinitionType))
            .setter(setter(Builder::policyDefinitionType)).constructor(AutomatedReasoningPolicyDefinitionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDefinitionType").build())
            .build();

    private static final SdkField<AutomatedReasoningPolicyDefinitionRule> POLICY_DEFINITION_RULE_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinitionRule> builder(MarshallingType.SDK_POJO).memberName("policyDefinitionRule")
            .getter(getter(AutomatedReasoningPolicyDefinitionElement::policyDefinitionRule))
            .setter(setter(Builder::policyDefinitionRule)).constructor(AutomatedReasoningPolicyDefinitionRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDefinitionRule").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POLICY_DEFINITION_VARIABLE_FIELD, POLICY_DEFINITION_TYPE_FIELD, POLICY_DEFINITION_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyDefinitionVariable policyDefinitionVariable;

    private final AutomatedReasoningPolicyDefinitionType policyDefinitionType;

    private final AutomatedReasoningPolicyDefinitionRule policyDefinitionRule;

    private final Type type;

    private AutomatedReasoningPolicyDefinitionElement(BuilderImpl builder) {
        this.policyDefinitionVariable = builder.policyDefinitionVariable;
        this.policyDefinitionType = builder.policyDefinitionType;
        this.policyDefinitionRule = builder.policyDefinitionRule;
        this.type = builder.type;
    }

    /**
     * <p>
     * A variable element within the policy definition that represents a concept used in logical expressions and rules.
     * </p>
     * 
     * @return A variable element within the policy definition that represents a concept used in logical expressions and
     *         rules.
     */
    public final AutomatedReasoningPolicyDefinitionVariable policyDefinitionVariable() {
        return policyDefinitionVariable;
    }

    /**
     * <p>
     * A custom type element within the policy definition that defines a set of possible values for variables.
     * </p>
     * 
     * @return A custom type element within the policy definition that defines a set of possible values for variables.
     */
    public final AutomatedReasoningPolicyDefinitionType policyDefinitionType() {
        return policyDefinitionType;
    }

    /**
     * <p>
     * A rule element within the policy definition that contains a formal logical expression used for validation.
     * </p>
     * 
     * @return A rule element within the policy definition that contains a formal logical expression used for
     *         validation.
     */
    public final AutomatedReasoningPolicyDefinitionRule policyDefinitionRule() {
        return policyDefinitionRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyDefinitionVariable());
        hashCode = 31 * hashCode + Objects.hashCode(policyDefinitionType());
        hashCode = 31 * hashCode + Objects.hashCode(policyDefinitionRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDefinitionElement)) {
            return false;
        }
        AutomatedReasoningPolicyDefinitionElement other = (AutomatedReasoningPolicyDefinitionElement) obj;
        return Objects.equals(policyDefinitionVariable(), other.policyDefinitionVariable())
                && Objects.equals(policyDefinitionType(), other.policyDefinitionType())
                && Objects.equals(policyDefinitionRule(), other.policyDefinitionRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyDefinitionElement")
                .add("PolicyDefinitionVariable", policyDefinitionVariable()).add("PolicyDefinitionType", policyDefinitionType())
                .add("PolicyDefinitionRule", policyDefinitionRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyDefinitionVariable":
            return Optional.ofNullable(clazz.cast(policyDefinitionVariable()));
        case "policyDefinitionType":
            return Optional.ofNullable(clazz.cast(policyDefinitionType()));
        case "policyDefinitionRule":
            return Optional.ofNullable(clazz.cast(policyDefinitionRule()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #policyDefinitionVariable()} initialized to the given value.
     *
     * <p>
     * A variable element within the policy definition that represents a concept used in logical expressions and rules.
     * </p>
     * 
     * @param policyDefinitionVariable
     *        A variable element within the policy definition that represents a concept used in logical expressions and
     *        rules.
     */
    public static AutomatedReasoningPolicyDefinitionElement fromPolicyDefinitionVariable(
            AutomatedReasoningPolicyDefinitionVariable policyDefinitionVariable) {
        return builder().policyDefinitionVariable(policyDefinitionVariable).build();
    }

    /**
     * Create an instance of this class with {@link #policyDefinitionVariable()} initialized to the given value.
     *
     * <p>
     * A variable element within the policy definition that represents a concept used in logical expressions and rules.
     * </p>
     * 
     * @param policyDefinitionVariable
     *        A variable element within the policy definition that represents a concept used in logical expressions and
     *        rules.
     */
    public static AutomatedReasoningPolicyDefinitionElement fromPolicyDefinitionVariable(
            Consumer<AutomatedReasoningPolicyDefinitionVariable.Builder> policyDefinitionVariable) {
        AutomatedReasoningPolicyDefinitionVariable.Builder builder = AutomatedReasoningPolicyDefinitionVariable.builder();
        policyDefinitionVariable.accept(builder);
        return fromPolicyDefinitionVariable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #policyDefinitionType()} initialized to the given value.
     *
     * <p>
     * A custom type element within the policy definition that defines a set of possible values for variables.
     * </p>
     * 
     * @param policyDefinitionType
     *        A custom type element within the policy definition that defines a set of possible values for variables.
     */
    public static AutomatedReasoningPolicyDefinitionElement fromPolicyDefinitionType(
            AutomatedReasoningPolicyDefinitionType policyDefinitionType) {
        return builder().policyDefinitionType(policyDefinitionType).build();
    }

    /**
     * Create an instance of this class with {@link #policyDefinitionType()} initialized to the given value.
     *
     * <p>
     * A custom type element within the policy definition that defines a set of possible values for variables.
     * </p>
     * 
     * @param policyDefinitionType
     *        A custom type element within the policy definition that defines a set of possible values for variables.
     */
    public static AutomatedReasoningPolicyDefinitionElement fromPolicyDefinitionType(
            Consumer<AutomatedReasoningPolicyDefinitionType.Builder> policyDefinitionType) {
        AutomatedReasoningPolicyDefinitionType.Builder builder = AutomatedReasoningPolicyDefinitionType.builder();
        policyDefinitionType.accept(builder);
        return fromPolicyDefinitionType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #policyDefinitionRule()} initialized to the given value.
     *
     * <p>
     * A rule element within the policy definition that contains a formal logical expression used for validation.
     * </p>
     * 
     * @param policyDefinitionRule
     *        A rule element within the policy definition that contains a formal logical expression used for validation.
     */
    public static AutomatedReasoningPolicyDefinitionElement fromPolicyDefinitionRule(
            AutomatedReasoningPolicyDefinitionRule policyDefinitionRule) {
        return builder().policyDefinitionRule(policyDefinitionRule).build();
    }

    /**
     * Create an instance of this class with {@link #policyDefinitionRule()} initialized to the given value.
     *
     * <p>
     * A rule element within the policy definition that contains a formal logical expression used for validation.
     * </p>
     * 
     * @param policyDefinitionRule
     *        A rule element within the policy definition that contains a formal logical expression used for validation.
     */
    public static AutomatedReasoningPolicyDefinitionElement fromPolicyDefinitionRule(
            Consumer<AutomatedReasoningPolicyDefinitionRule.Builder> policyDefinitionRule) {
        AutomatedReasoningPolicyDefinitionRule.Builder builder = AutomatedReasoningPolicyDefinitionRule.builder();
        policyDefinitionRule.accept(builder);
        return fromPolicyDefinitionRule(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyDefinitionVariable", POLICY_DEFINITION_VARIABLE_FIELD);
        map.put("policyDefinitionType", POLICY_DEFINITION_TYPE_FIELD);
        map.put("policyDefinitionRule", POLICY_DEFINITION_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDefinitionElement, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDefinitionElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyDefinitionElement> {
        /**
         * <p>
         * A variable element within the policy definition that represents a concept used in logical expressions and
         * rules.
         * </p>
         * 
         * @param policyDefinitionVariable
         *        A variable element within the policy definition that represents a concept used in logical expressions
         *        and rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDefinitionVariable(AutomatedReasoningPolicyDefinitionVariable policyDefinitionVariable);

        /**
         * <p>
         * A variable element within the policy definition that represents a concept used in logical expressions and
         * rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinitionVariable.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinitionVariable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinitionVariable.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #policyDefinitionVariable(AutomatedReasoningPolicyDefinitionVariable)}.
         * 
         * @param policyDefinitionVariable
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinitionVariable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDefinitionVariable(AutomatedReasoningPolicyDefinitionVariable)
         */
        default Builder policyDefinitionVariable(
                Consumer<AutomatedReasoningPolicyDefinitionVariable.Builder> policyDefinitionVariable) {
            return policyDefinitionVariable(AutomatedReasoningPolicyDefinitionVariable.builder()
                    .applyMutation(policyDefinitionVariable).build());
        }

        /**
         * <p>
         * A custom type element within the policy definition that defines a set of possible values for variables.
         * </p>
         * 
         * @param policyDefinitionType
         *        A custom type element within the policy definition that defines a set of possible values for
         *        variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDefinitionType(AutomatedReasoningPolicyDefinitionType policyDefinitionType);

        /**
         * <p>
         * A custom type element within the policy definition that defines a set of possible values for variables.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinitionType.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinitionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinitionType.Builder#build()} is called
         * immediately and its result is passed to {@link #policyDefinitionType(AutomatedReasoningPolicyDefinitionType)}.
         * 
         * @param policyDefinitionType
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinitionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDefinitionType(AutomatedReasoningPolicyDefinitionType)
         */
        default Builder policyDefinitionType(Consumer<AutomatedReasoningPolicyDefinitionType.Builder> policyDefinitionType) {
            return policyDefinitionType(AutomatedReasoningPolicyDefinitionType.builder().applyMutation(policyDefinitionType)
                    .build());
        }

        /**
         * <p>
         * A rule element within the policy definition that contains a formal logical expression used for validation.
         * </p>
         * 
         * @param policyDefinitionRule
         *        A rule element within the policy definition that contains a formal logical expression used for
         *        validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDefinitionRule(AutomatedReasoningPolicyDefinitionRule policyDefinitionRule);

        /**
         * <p>
         * A rule element within the policy definition that contains a formal logical expression used for validation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinitionRule.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinitionRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinitionRule.Builder#build()} is called
         * immediately and its result is passed to {@link #policyDefinitionRule(AutomatedReasoningPolicyDefinitionRule)}.
         * 
         * @param policyDefinitionRule
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinitionRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDefinitionRule(AutomatedReasoningPolicyDefinitionRule)
         */
        default Builder policyDefinitionRule(Consumer<AutomatedReasoningPolicyDefinitionRule.Builder> policyDefinitionRule) {
            return policyDefinitionRule(AutomatedReasoningPolicyDefinitionRule.builder().applyMutation(policyDefinitionRule)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyDefinitionVariable policyDefinitionVariable;

        private AutomatedReasoningPolicyDefinitionType policyDefinitionType;

        private AutomatedReasoningPolicyDefinitionRule policyDefinitionRule;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDefinitionElement model) {
            policyDefinitionVariable(model.policyDefinitionVariable);
            policyDefinitionType(model.policyDefinitionType);
            policyDefinitionRule(model.policyDefinitionRule);
        }

        public final AutomatedReasoningPolicyDefinitionVariable.Builder getPolicyDefinitionVariable() {
            return policyDefinitionVariable != null ? policyDefinitionVariable.toBuilder() : null;
        }

        public final void setPolicyDefinitionVariable(
                AutomatedReasoningPolicyDefinitionVariable.BuilderImpl policyDefinitionVariable) {
            Object oldValue = this.policyDefinitionVariable;
            this.policyDefinitionVariable = policyDefinitionVariable != null ? policyDefinitionVariable.build() : null;
            handleUnionValueChange(Type.POLICY_DEFINITION_VARIABLE, oldValue, this.policyDefinitionVariable);
        }

        @Override
        public final Builder policyDefinitionVariable(AutomatedReasoningPolicyDefinitionVariable policyDefinitionVariable) {
            Object oldValue = this.policyDefinitionVariable;
            this.policyDefinitionVariable = policyDefinitionVariable;
            handleUnionValueChange(Type.POLICY_DEFINITION_VARIABLE, oldValue, this.policyDefinitionVariable);
            return this;
        }

        public final AutomatedReasoningPolicyDefinitionType.Builder getPolicyDefinitionType() {
            return policyDefinitionType != null ? policyDefinitionType.toBuilder() : null;
        }

        public final void setPolicyDefinitionType(AutomatedReasoningPolicyDefinitionType.BuilderImpl policyDefinitionType) {
            Object oldValue = this.policyDefinitionType;
            this.policyDefinitionType = policyDefinitionType != null ? policyDefinitionType.build() : null;
            handleUnionValueChange(Type.POLICY_DEFINITION_TYPE, oldValue, this.policyDefinitionType);
        }

        @Override
        public final Builder policyDefinitionType(AutomatedReasoningPolicyDefinitionType policyDefinitionType) {
            Object oldValue = this.policyDefinitionType;
            this.policyDefinitionType = policyDefinitionType;
            handleUnionValueChange(Type.POLICY_DEFINITION_TYPE, oldValue, this.policyDefinitionType);
            return this;
        }

        public final AutomatedReasoningPolicyDefinitionRule.Builder getPolicyDefinitionRule() {
            return policyDefinitionRule != null ? policyDefinitionRule.toBuilder() : null;
        }

        public final void setPolicyDefinitionRule(AutomatedReasoningPolicyDefinitionRule.BuilderImpl policyDefinitionRule) {
            Object oldValue = this.policyDefinitionRule;
            this.policyDefinitionRule = policyDefinitionRule != null ? policyDefinitionRule.build() : null;
            handleUnionValueChange(Type.POLICY_DEFINITION_RULE, oldValue, this.policyDefinitionRule);
        }

        @Override
        public final Builder policyDefinitionRule(AutomatedReasoningPolicyDefinitionRule policyDefinitionRule) {
            Object oldValue = this.policyDefinitionRule;
            this.policyDefinitionRule = policyDefinitionRule;
            handleUnionValueChange(Type.POLICY_DEFINITION_RULE, oldValue, this.policyDefinitionRule);
            return this;
        }

        @Override
        public AutomatedReasoningPolicyDefinitionElement build() {
            return new AutomatedReasoningPolicyDefinitionElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutomatedReasoningPolicyDefinitionElement#type()
     */
    public enum Type {
        POLICY_DEFINITION_VARIABLE,

        POLICY_DEFINITION_TYPE,

        POLICY_DEFINITION_RULE,

        UNKNOWN_TO_SDK_VERSION
    }
}
