/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a formal logic rule in an Automated Reasoning policy. For example, rules can be expressed as if-then
 * statements that define logical constraints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyDefinitionRule implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyDefinitionRule.Builder, AutomatedReasoningPolicyDefinitionRule> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AutomatedReasoningPolicyDefinitionRule::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(AutomatedReasoningPolicyDefinitionRule::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<String> ALTERNATE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alternateExpression").getter(getter(AutomatedReasoningPolicyDefinitionRule::alternateExpression))
            .setter(setter(Builder::alternateExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXPRESSION_FIELD,
            ALTERNATE_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String expression;

    private final String alternateExpression;

    private AutomatedReasoningPolicyDefinitionRule(BuilderImpl builder) {
        this.id = builder.id;
        this.expression = builder.expression;
        this.alternateExpression = builder.alternateExpression;
    }

    /**
     * <p>
     * The unique identifier of the rule within the policy.
     * </p>
     * 
     * @return The unique identifier of the rule within the policy.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The formal logic expression of the rule.
     * </p>
     * 
     * @return The formal logic expression of the rule.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * The human-readable form of the rule expression, often in natural language or simplified notation.
     * </p>
     * 
     * @return The human-readable form of the rule expression, often in natural language or simplified notation.
     */
    public final String alternateExpression() {
        return alternateExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(alternateExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDefinitionRule)) {
            return false;
        }
        AutomatedReasoningPolicyDefinitionRule other = (AutomatedReasoningPolicyDefinitionRule) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(expression(), other.expression())
                && Objects.equals(alternateExpression(), other.alternateExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyDefinitionRule").add("Id", id())
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AlternateExpression", alternateExpression() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "alternateExpression":
            return Optional.ofNullable(clazz.cast(alternateExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("expression", EXPRESSION_FIELD);
        map.put("alternateExpression", ALTERNATE_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDefinitionRule, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDefinitionRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyDefinitionRule> {
        /**
         * <p>
         * The unique identifier of the rule within the policy.
         * </p>
         * 
         * @param id
         *        The unique identifier of the rule within the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The formal logic expression of the rule.
         * </p>
         * 
         * @param expression
         *        The formal logic expression of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The human-readable form of the rule expression, often in natural language or simplified notation.
         * </p>
         * 
         * @param alternateExpression
         *        The human-readable form of the rule expression, often in natural language or simplified notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateExpression(String alternateExpression);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String expression;

        private String alternateExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDefinitionRule model) {
            id(model.id);
            expression(model.expression);
            alternateExpression(model.alternateExpression);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getAlternateExpression() {
            return alternateExpression;
        }

        public final void setAlternateExpression(String alternateExpression) {
            this.alternateExpression = alternateExpression;
        }

        @Override
        public final Builder alternateExpression(String alternateExpression) {
            this.alternateExpression = alternateExpression;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyDefinitionRule build() {
            return new AutomatedReasoningPolicyDefinitionRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
