/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a modification to a value within an existing custom type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyUpdateTypeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyUpdateTypeValue.Builder, AutomatedReasoningPolicyUpdateTypeValue> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(AutomatedReasoningPolicyUpdateTypeValue::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> NEW_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newValue").getter(getter(AutomatedReasoningPolicyUpdateTypeValue::newValue))
            .setter(setter(Builder::newValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AutomatedReasoningPolicyUpdateTypeValue::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, NEW_VALUE_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String newValue;

    private final String description;

    private AutomatedReasoningPolicyUpdateTypeValue(BuilderImpl builder) {
        this.value = builder.value;
        this.newValue = builder.newValue;
        this.description = builder.description;
    }

    /**
     * <p>
     * The current identifier or name of the type value to update.
     * </p>
     * 
     * @return The current identifier or name of the type value to update.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The new identifier or name for the type value, if you want to rename it.
     * </p>
     * 
     * @return The new identifier or name for the type value, if you want to rename it.
     */
    public final String newValue() {
        return newValue;
    }

    /**
     * <p>
     * The new description for the type value, replacing the previous description.
     * </p>
     * 
     * @return The new description for the type value, replacing the previous description.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(newValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyUpdateTypeValue)) {
            return false;
        }
        AutomatedReasoningPolicyUpdateTypeValue other = (AutomatedReasoningPolicyUpdateTypeValue) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(newValue(), other.newValue())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyUpdateTypeValue").add("Value", value()).add("NewValue", newValue())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "newValue":
            return Optional.ofNullable(clazz.cast(newValue()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("value", VALUE_FIELD);
        map.put("newValue", NEW_VALUE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyUpdateTypeValue, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyUpdateTypeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyUpdateTypeValue> {
        /**
         * <p>
         * The current identifier or name of the type value to update.
         * </p>
         * 
         * @param value
         *        The current identifier or name of the type value to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The new identifier or name for the type value, if you want to rename it.
         * </p>
         * 
         * @param newValue
         *        The new identifier or name for the type value, if you want to rename it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newValue(String newValue);

        /**
         * <p>
         * The new description for the type value, replacing the previous description.
         * </p>
         * 
         * @param description
         *        The new description for the type value, replacing the previous description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String newValue;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyUpdateTypeValue model) {
            value(model.value);
            newValue(model.newValue);
            description(model.description);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getNewValue() {
            return newValue;
        }

        public final void setNewValue(String newValue) {
            this.newValue = newValue;
        }

        @Override
        public final Builder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyUpdateTypeValue build() {
            return new AutomatedReasoningPolicyUpdateTypeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
