/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the content and configuration for different types of policy build workflows.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyWorkflowTypeContent implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyWorkflowTypeContent.Builder, AutomatedReasoningPolicyWorkflowTypeContent> {
    private static final SdkField<List<AutomatedReasoningPolicyBuildWorkflowDocument>> DOCUMENTS_FIELD = SdkField
            .<List<AutomatedReasoningPolicyBuildWorkflowDocument>> builder(MarshallingType.LIST)
            .memberName("documents")
            .getter(getter(AutomatedReasoningPolicyWorkflowTypeContent::documents))
            .setter(setter(Builder::documents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyBuildWorkflowDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyBuildWorkflowDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutomatedReasoningPolicyBuildWorkflowRepairContent> POLICY_REPAIR_ASSETS_FIELD = SdkField
            .<AutomatedReasoningPolicyBuildWorkflowRepairContent> builder(MarshallingType.SDK_POJO)
            .memberName("policyRepairAssets").getter(getter(AutomatedReasoningPolicyWorkflowTypeContent::policyRepairAssets))
            .setter(setter(Builder::policyRepairAssets)).constructor(AutomatedReasoningPolicyBuildWorkflowRepairContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyRepairAssets").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENTS_FIELD,
            POLICY_REPAIR_ASSETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AutomatedReasoningPolicyBuildWorkflowDocument> documents;

    private final AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets;

    private final Type type;

    private AutomatedReasoningPolicyWorkflowTypeContent(BuilderImpl builder) {
        this.documents = builder.documents;
        this.policyRepairAssets = builder.policyRepairAssets;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Documents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDocuments() {
        return documents != null && !(documents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of documents to be processed in a document ingestion workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocuments} method.
     * </p>
     * 
     * @return The list of documents to be processed in a document ingestion workflow.
     */
    public final List<AutomatedReasoningPolicyBuildWorkflowDocument> documents() {
        return documents;
    }

    /**
     * <p>
     * The assets and instructions needed for a policy repair workflow, including repair annotations and guidance.
     * </p>
     * 
     * @return The assets and instructions needed for a policy repair workflow, including repair annotations and
     *         guidance.
     */
    public final AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets() {
        return policyRepairAssets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDocuments() ? documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(policyRepairAssets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyWorkflowTypeContent)) {
            return false;
        }
        AutomatedReasoningPolicyWorkflowTypeContent other = (AutomatedReasoningPolicyWorkflowTypeContent) obj;
        return hasDocuments() == other.hasDocuments() && Objects.equals(documents(), other.documents())
                && Objects.equals(policyRepairAssets(), other.policyRepairAssets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyWorkflowTypeContent")
                .add("Documents", hasDocuments() ? documents() : null).add("PolicyRepairAssets", policyRepairAssets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "documents":
            return Optional.ofNullable(clazz.cast(documents()));
        case "policyRepairAssets":
            return Optional.ofNullable(clazz.cast(policyRepairAssets()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #documents()} initialized to the given value.
     *
     * <p>
     * The list of documents to be processed in a document ingestion workflow.
     * </p>
     * 
     * @param documents
     *        The list of documents to be processed in a document ingestion workflow.
     */
    public static AutomatedReasoningPolicyWorkflowTypeContent fromDocuments(
            List<AutomatedReasoningPolicyBuildWorkflowDocument> documents) {
        return builder().documents(documents).build();
    }

    /**
     * Create an instance of this class with {@link #policyRepairAssets()} initialized to the given value.
     *
     * <p>
     * The assets and instructions needed for a policy repair workflow, including repair annotations and guidance.
     * </p>
     * 
     * @param policyRepairAssets
     *        The assets and instructions needed for a policy repair workflow, including repair annotations and
     *        guidance.
     */
    public static AutomatedReasoningPolicyWorkflowTypeContent fromPolicyRepairAssets(
            AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets) {
        return builder().policyRepairAssets(policyRepairAssets).build();
    }

    /**
     * Create an instance of this class with {@link #policyRepairAssets()} initialized to the given value.
     *
     * <p>
     * The assets and instructions needed for a policy repair workflow, including repair annotations and guidance.
     * </p>
     * 
     * @param policyRepairAssets
     *        The assets and instructions needed for a policy repair workflow, including repair annotations and
     *        guidance.
     */
    public static AutomatedReasoningPolicyWorkflowTypeContent fromPolicyRepairAssets(
            Consumer<AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder> policyRepairAssets) {
        AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder builder = AutomatedReasoningPolicyBuildWorkflowRepairContent
                .builder();
        policyRepairAssets.accept(builder);
        return fromPolicyRepairAssets(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("documents", DOCUMENTS_FIELD);
        map.put("policyRepairAssets", POLICY_REPAIR_ASSETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyWorkflowTypeContent, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyWorkflowTypeContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyWorkflowTypeContent> {
        /**
         * <p>
         * The list of documents to be processed in a document ingestion workflow.
         * </p>
         * 
         * @param documents
         *        The list of documents to be processed in a document ingestion workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Collection<AutomatedReasoningPolicyBuildWorkflowDocument> documents);

        /**
         * <p>
         * The list of documents to be processed in a document ingestion workflow.
         * </p>
         * 
         * @param documents
         *        The list of documents to be processed in a document ingestion workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(AutomatedReasoningPolicyBuildWorkflowDocument... documents);

        /**
         * <p>
         * The list of documents to be processed in a document ingestion workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowDocument.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowDocument#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowDocument.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #documents(List<AutomatedReasoningPolicyBuildWorkflowDocument>)}.
         * 
         * @param documents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(java.util.Collection<AutomatedReasoningPolicyBuildWorkflowDocument>)
         */
        Builder documents(Consumer<AutomatedReasoningPolicyBuildWorkflowDocument.Builder>... documents);

        /**
         * <p>
         * The assets and instructions needed for a policy repair workflow, including repair annotations and guidance.
         * </p>
         * 
         * @param policyRepairAssets
         *        The assets and instructions needed for a policy repair workflow, including repair annotations and
         *        guidance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets);

        /**
         * <p>
         * The assets and instructions needed for a policy repair workflow, including repair annotations and guidance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder} avoiding the need to create one manually
         * via {@link AutomatedReasoningPolicyBuildWorkflowRepairContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder#build()} is called immediately and its
         * result is passed to {@link #policyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent)}.
         * 
         * @param policyRepairAssets
         *        a consumer that will call methods on
         *        {@link AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent)
         */
        default Builder policyRepairAssets(Consumer<AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder> policyRepairAssets) {
            return policyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent.builder()
                    .applyMutation(policyRepairAssets).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AutomatedReasoningPolicyBuildWorkflowDocument> documents = DefaultSdkAutoConstructList.getInstance();

        private AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyWorkflowTypeContent model) {
            documents(model.documents);
            policyRepairAssets(model.policyRepairAssets);
        }

        public final List<AutomatedReasoningPolicyBuildWorkflowDocument.Builder> getDocuments() {
            List<AutomatedReasoningPolicyBuildWorkflowDocument.Builder> result = AutomatedReasoningPolicyBuildWorkflowDocumentListCopier
                    .copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<AutomatedReasoningPolicyBuildWorkflowDocument.BuilderImpl> documents) {
            Object oldValue = this.documents;
            this.documents = AutomatedReasoningPolicyBuildWorkflowDocumentListCopier.copyFromBuilder(documents);
            handleUnionValueChange(Type.DOCUMENTS, oldValue, this.documents);
        }

        @Override
        public final Builder documents(Collection<AutomatedReasoningPolicyBuildWorkflowDocument> documents) {
            Object oldValue = this.documents;
            this.documents = AutomatedReasoningPolicyBuildWorkflowDocumentListCopier.copy(documents);
            handleUnionValueChange(Type.DOCUMENTS, oldValue, this.documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(AutomatedReasoningPolicyBuildWorkflowDocument... documents) {
            documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<AutomatedReasoningPolicyBuildWorkflowDocument.Builder>... documents) {
            documents(Stream.of(documents)
                    .map(c -> AutomatedReasoningPolicyBuildWorkflowDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder getPolicyRepairAssets() {
            return policyRepairAssets != null ? policyRepairAssets.toBuilder() : null;
        }

        public final void setPolicyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent.BuilderImpl policyRepairAssets) {
            Object oldValue = this.policyRepairAssets;
            this.policyRepairAssets = policyRepairAssets != null ? policyRepairAssets.build() : null;
            handleUnionValueChange(Type.POLICY_REPAIR_ASSETS, oldValue, this.policyRepairAssets);
        }

        @Override
        public final Builder policyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets) {
            Object oldValue = this.policyRepairAssets;
            this.policyRepairAssets = policyRepairAssets;
            handleUnionValueChange(Type.POLICY_REPAIR_ASSETS, oldValue, this.policyRepairAssets);
            return this;
        }

        @Override
        public AutomatedReasoningPolicyWorkflowTypeContent build() {
            return new AutomatedReasoningPolicyWorkflowTypeContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutomatedReasoningPolicyWorkflowTypeContent#type()
     */
    public enum Type {
        DOCUMENTS,

        POLICY_REPAIR_ASSETS,

        UNKNOWN_TO_SDK_VERSION
    }
}
