/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutomatedReasoningPolicyTestCaseRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateAutomatedReasoningPolicyTestCaseRequest.Builder, CreateAutomatedReasoningPolicyTestCaseRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(CreateAutomatedReasoningPolicyTestCaseRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()).build();

    private static final SdkField<String> GUARD_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardContent").getter(getter(CreateAutomatedReasoningPolicyTestCaseRequest::guardContent))
            .setter(setter(Builder::guardContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()).build();

    private static final SdkField<String> QUERY_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryContent").getter(getter(CreateAutomatedReasoningPolicyTestCaseRequest::queryContent))
            .setter(setter(Builder::queryContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryContent").build()).build();

    private static final SdkField<String> EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("expectedAggregatedFindingsResult")
            .getter(getter(CreateAutomatedReasoningPolicyTestCaseRequest::expectedAggregatedFindingsResultAsString))
            .setter(setter(Builder::expectedAggregatedFindingsResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedAggregatedFindingsResult")
                    .build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateAutomatedReasoningPolicyTestCaseRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Double> CONFIDENCE_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("confidenceThreshold").getter(getter(CreateAutomatedReasoningPolicyTestCaseRequest::confidenceThreshold))
            .setter(setter(Builder::confidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            GUARD_CONTENT_FIELD, QUERY_CONTENT_FIELD, EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD, CLIENT_REQUEST_TOKEN_FIELD,
            CONFIDENCE_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String guardContent;

    private final String queryContent;

    private final String expectedAggregatedFindingsResult;

    private final String clientRequestToken;

    private final Double confidenceThreshold;

    private CreateAutomatedReasoningPolicyTestCaseRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.guardContent = builder.guardContent;
        this.queryContent = builder.queryContent;
        this.expectedAggregatedFindingsResult = builder.expectedAggregatedFindingsResult;
        this.clientRequestToken = builder.clientRequestToken;
        this.confidenceThreshold = builder.confidenceThreshold;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to create the test.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to create the test.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The output content that's validated by the Automated Reasoning policy. This represents the foundation model
     * response that will be checked for accuracy.
     * </p>
     * 
     * @return The output content that's validated by the Automated Reasoning policy. This represents the foundation
     *         model response that will be checked for accuracy.
     */
    public final String guardContent() {
        return guardContent;
    }

    /**
     * <p>
     * The input query or prompt that generated the content. This provides context for the validation.
     * </p>
     * 
     * @return The input query or prompt that generated the content. This provides context for the validation.
     */
    public final String queryContent() {
        return queryContent;
    }

    /**
     * <p>
     * The expected result of the Automated Reasoning check. Valid values include: , TOO_COMPLEX, and NO_TRANSLATIONS.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated Reasoning
     * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false. In
     * other words, there are no alternative answers that are true that contradict the claims.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated Reasoning
     * policy. Furthermore, there exists different claims that are consistent with the premises and Automated Reasoning
     * policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for the claim
     * to be implied from the premises and Automated Reasoning policy rules. In this situation, different assumptions
     * can make input claims false and alternative claims true.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if the
     * premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRANSLATION_AMBIGUOUS</code> - Detected an ambiguity in the translation meant it would be unsound to
     * continue with validity checking. Additional context or follow-up questions might be needed to get translation to
     * succeed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOO_COMPLEX</code> - The input contains too much information for Automated Reasoning to process within its
     * latency limits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_TRANSLATIONS</code> - Identifies that some or all of the input prompt wasn't translated into logic. This
     * can happen if the input isn't relevant to the Automated Reasoning policy, or if the policy doesn't have variables
     * to model relevant input. If Automated Reasoning can't translate anything, you get a single
     * <code>NO_TRANSLATIONS</code> finding. You might also see a <code>NO_TRANSLATIONS</code> (along with other
     * findings) if some part of the validation isn't translated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedAggregatedFindingsResult} will return
     * {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expectedAggregatedFindingsResultAsString}.
     * </p>
     * 
     * @return The expected result of the Automated Reasoning check. Valid values include: , TOO_COMPLEX, and
     *         NO_TRANSLATIONS.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated
     *         Reasoning policy. Given the Automated Reasoning policy and premises, it is not possible for these claims
     *         to be false. In other words, there are no alternative answers that are true that contradict the claims.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
     *         Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
     *         Automated Reasoning policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for
     *         the claim to be implied from the premises and Automated Reasoning policy rules. In this situation,
     *         different assumptions can make input claims false and alternative claims true.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if
     *         the premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy
     *         itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRANSLATION_AMBIGUOUS</code> - Detected an ambiguity in the translation meant it would be unsound
     *         to continue with validity checking. Additional context or follow-up questions might be needed to get
     *         translation to succeed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOO_COMPLEX</code> - The input contains too much information for Automated Reasoning to process
     *         within its latency limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_TRANSLATIONS</code> - Identifies that some or all of the input prompt wasn't translated into
     *         logic. This can happen if the input isn't relevant to the Automated Reasoning policy, or if the policy
     *         doesn't have variables to model relevant input. If Automated Reasoning can't translate anything, you get
     *         a single <code>NO_TRANSLATIONS</code> finding. You might also see a <code>NO_TRANSLATIONS</code> (along
     *         with other findings) if some part of the validation isn't translated.
     *         </p>
     *         </li>
     * @see AutomatedReasoningCheckResult
     */
    public final AutomatedReasoningCheckResult expectedAggregatedFindingsResult() {
        return AutomatedReasoningCheckResult.fromValue(expectedAggregatedFindingsResult);
    }

    /**
     * <p>
     * The expected result of the Automated Reasoning check. Valid values include: , TOO_COMPLEX, and NO_TRANSLATIONS.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated Reasoning
     * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false. In
     * other words, there are no alternative answers that are true that contradict the claims.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated Reasoning
     * policy. Furthermore, there exists different claims that are consistent with the premises and Automated Reasoning
     * policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for the claim
     * to be implied from the premises and Automated Reasoning policy rules. In this situation, different assumptions
     * can make input claims false and alternative claims true.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if the
     * premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRANSLATION_AMBIGUOUS</code> - Detected an ambiguity in the translation meant it would be unsound to
     * continue with validity checking. Additional context or follow-up questions might be needed to get translation to
     * succeed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOO_COMPLEX</code> - The input contains too much information for Automated Reasoning to process within its
     * latency limits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_TRANSLATIONS</code> - Identifies that some or all of the input prompt wasn't translated into logic. This
     * can happen if the input isn't relevant to the Automated Reasoning policy, or if the policy doesn't have variables
     * to model relevant input. If Automated Reasoning can't translate anything, you get a single
     * <code>NO_TRANSLATIONS</code> finding. You might also see a <code>NO_TRANSLATIONS</code> (along with other
     * findings) if some part of the validation isn't translated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedAggregatedFindingsResult} will return
     * {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expectedAggregatedFindingsResultAsString}.
     * </p>
     * 
     * @return The expected result of the Automated Reasoning check. Valid values include: , TOO_COMPLEX, and
     *         NO_TRANSLATIONS.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated
     *         Reasoning policy. Given the Automated Reasoning policy and premises, it is not possible for these claims
     *         to be false. In other words, there are no alternative answers that are true that contradict the claims.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
     *         Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
     *         Automated Reasoning policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for
     *         the claim to be implied from the premises and Automated Reasoning policy rules. In this situation,
     *         different assumptions can make input claims false and alternative claims true.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if
     *         the premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy
     *         itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRANSLATION_AMBIGUOUS</code> - Detected an ambiguity in the translation meant it would be unsound
     *         to continue with validity checking. Additional context or follow-up questions might be needed to get
     *         translation to succeed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOO_COMPLEX</code> - The input contains too much information for Automated Reasoning to process
     *         within its latency limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_TRANSLATIONS</code> - Identifies that some or all of the input prompt wasn't translated into
     *         logic. This can happen if the input isn't relevant to the Automated Reasoning policy, or if the policy
     *         doesn't have variables to model relevant input. If Automated Reasoning can't translate anything, you get
     *         a single <code>NO_TRANSLATIONS</code> finding. You might also see a <code>NO_TRANSLATIONS</code> (along
     *         with other findings) if some part of the validation isn't translated.
     *         </p>
     *         </li>
     * @see AutomatedReasoningCheckResult
     */
    public final String expectedAggregatedFindingsResultAsString() {
        return expectedAggregatedFindingsResult;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
     *         token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The minimum confidence level for logic validation. Content that meets the threshold is considered a
     * high-confidence finding that can be validated.
     * </p>
     * 
     * @return The minimum confidence level for logic validation. Content that meets the threshold is considered a
     *         high-confidence finding that can be validated.
     */
    public final Double confidenceThreshold() {
        return confidenceThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(queryContent());
        hashCode = 31 * hashCode + Objects.hashCode(expectedAggregatedFindingsResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(confidenceThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutomatedReasoningPolicyTestCaseRequest)) {
            return false;
        }
        CreateAutomatedReasoningPolicyTestCaseRequest other = (CreateAutomatedReasoningPolicyTestCaseRequest) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(guardContent(), other.guardContent())
                && Objects.equals(queryContent(), other.queryContent())
                && Objects.equals(expectedAggregatedFindingsResultAsString(), other.expectedAggregatedFindingsResultAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(confidenceThreshold(), other.confidenceThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAutomatedReasoningPolicyTestCaseRequest").add("PolicyArn", policyArn())
                .add("GuardContent", guardContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QueryContent", queryContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExpectedAggregatedFindingsResult", expectedAggregatedFindingsResultAsString())
                .add("ClientRequestToken", clientRequestToken()).add("ConfidenceThreshold", confidenceThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "guardContent":
            return Optional.ofNullable(clazz.cast(guardContent()));
        case "queryContent":
            return Optional.ofNullable(clazz.cast(queryContent()));
        case "expectedAggregatedFindingsResult":
            return Optional.ofNullable(clazz.cast(expectedAggregatedFindingsResultAsString()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "confidenceThreshold":
            return Optional.ofNullable(clazz.cast(confidenceThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("queryContent", QUERY_CONTENT_FIELD);
        map.put("expectedAggregatedFindingsResult", EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAutomatedReasoningPolicyTestCaseRequest, T> g) {
        return obj -> g.apply((CreateAutomatedReasoningPolicyTestCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAutomatedReasoningPolicyTestCaseRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to create the test.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to create the test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The output content that's validated by the Automated Reasoning policy. This represents the foundation model
         * response that will be checked for accuracy.
         * </p>
         * 
         * @param guardContent
         *        The output content that's validated by the Automated Reasoning policy. This represents the foundation
         *        model response that will be checked for accuracy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardContent(String guardContent);

        /**
         * <p>
         * The input query or prompt that generated the content. This provides context for the validation.
         * </p>
         * 
         * @param queryContent
         *        The input query or prompt that generated the content. This provides context for the validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryContent(String queryContent);

        /**
         * <p>
         * The expected result of the Automated Reasoning check. Valid values include: , TOO_COMPLEX, and
         * NO_TRANSLATIONS.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated Reasoning
         * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false.
         * In other words, there are no alternative answers that are true that contradict the claims.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
         * Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
         * Automated Reasoning policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for the
         * claim to be implied from the premises and Automated Reasoning policy rules. In this situation, different
         * assumptions can make input claims false and alternative claims true.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if the
         * premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRANSLATION_AMBIGUOUS</code> - Detected an ambiguity in the translation meant it would be unsound to
         * continue with validity checking. Additional context or follow-up questions might be needed to get translation
         * to succeed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOO_COMPLEX</code> - The input contains too much information for Automated Reasoning to process within
         * its latency limits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_TRANSLATIONS</code> - Identifies that some or all of the input prompt wasn't translated into logic.
         * This can happen if the input isn't relevant to the Automated Reasoning policy, or if the policy doesn't have
         * variables to model relevant input. If Automated Reasoning can't translate anything, you get a single
         * <code>NO_TRANSLATIONS</code> finding. You might also see a <code>NO_TRANSLATIONS</code> (along with other
         * findings) if some part of the validation isn't translated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param expectedAggregatedFindingsResult
         *        The expected result of the Automated Reasoning check. Valid values include: , TOO_COMPLEX, and
         *        NO_TRANSLATIONS.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated
         *        Reasoning policy. Given the Automated Reasoning policy and premises, it is not possible for these
         *        claims to be false. In other words, there are no alternative answers that are true that contradict the
         *        claims.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
         *        Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
         *        Automated Reasoning policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made
         *        for the claim to be implied from the premises and Automated Reasoning policy rules. In this situation,
         *        different assumptions can make input claims false and alternative claims true.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen
         *        if the premises are logically incorrect, or if there is a conflict within the Automated Reasoning
         *        policy itself.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRANSLATION_AMBIGUOUS</code> - Detected an ambiguity in the translation meant it would be
         *        unsound to continue with validity checking. Additional context or follow-up questions might be needed
         *        to get translation to succeed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOO_COMPLEX</code> - The input contains too much information for Automated Reasoning to process
         *        within its latency limits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_TRANSLATIONS</code> - Identifies that some or all of the input prompt wasn't translated into
         *        logic. This can happen if the input isn't relevant to the Automated Reasoning policy, or if the policy
         *        doesn't have variables to model relevant input. If Automated Reasoning can't translate anything, you
         *        get a single <code>NO_TRANSLATIONS</code> finding. You might also see a <code>NO_TRANSLATIONS</code>
         *        (along with other findings) if some part of the validation isn't translated.
         *        </p>
         *        </li>
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult);

        /**
         * <p>
         * The expected result of the Automated Reasoning check. Valid values include: , TOO_COMPLEX, and
         * NO_TRANSLATIONS.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated Reasoning
         * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false.
         * In other words, there are no alternative answers that are true that contradict the claims.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
         * Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
         * Automated Reasoning policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for the
         * claim to be implied from the premises and Automated Reasoning policy rules. In this situation, different
         * assumptions can make input claims false and alternative claims true.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if the
         * premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRANSLATION_AMBIGUOUS</code> - Detected an ambiguity in the translation meant it would be unsound to
         * continue with validity checking. Additional context or follow-up questions might be needed to get translation
         * to succeed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOO_COMPLEX</code> - The input contains too much information for Automated Reasoning to process within
         * its latency limits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_TRANSLATIONS</code> - Identifies that some or all of the input prompt wasn't translated into logic.
         * This can happen if the input isn't relevant to the Automated Reasoning policy, or if the policy doesn't have
         * variables to model relevant input. If Automated Reasoning can't translate anything, you get a single
         * <code>NO_TRANSLATIONS</code> finding. You might also see a <code>NO_TRANSLATIONS</code> (along with other
         * findings) if some part of the validation isn't translated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param expectedAggregatedFindingsResult
         *        The expected result of the Automated Reasoning check. Valid values include: , TOO_COMPLEX, and
         *        NO_TRANSLATIONS.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated
         *        Reasoning policy. Given the Automated Reasoning policy and premises, it is not possible for these
         *        claims to be false. In other words, there are no alternative answers that are true that contradict the
         *        claims.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
         *        Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
         *        Automated Reasoning policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made
         *        for the claim to be implied from the premises and Automated Reasoning policy rules. In this situation,
         *        different assumptions can make input claims false and alternative claims true.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen
         *        if the premises are logically incorrect, or if there is a conflict within the Automated Reasoning
         *        policy itself.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRANSLATION_AMBIGUOUS</code> - Detected an ambiguity in the translation meant it would be
         *        unsound to continue with validity checking. Additional context or follow-up questions might be needed
         *        to get translation to succeed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOO_COMPLEX</code> - The input contains too much information for Automated Reasoning to process
         *        within its latency limits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_TRANSLATIONS</code> - Identifies that some or all of the input prompt wasn't translated into
         *        logic. This can happen if the input isn't relevant to the Automated Reasoning policy, or if the policy
         *        doesn't have variables to model relevant input. If Automated Reasoning can't translate anything, you
         *        get a single <code>NO_TRANSLATIONS</code> finding. You might also see a <code>NO_TRANSLATIONS</code>
         *        (along with other findings) if some part of the validation isn't translated.
         *        </p>
         *        </li>
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The minimum confidence level for logic validation. Content that meets the threshold is considered a
         * high-confidence finding that can be validated.
         * </p>
         * 
         * @param confidenceThreshold
         *        The minimum confidence level for logic validation. Content that meets the threshold is considered a
         *        high-confidence finding that can be validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidenceThreshold(Double confidenceThreshold);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String policyArn;

        private String guardContent;

        private String queryContent;

        private String expectedAggregatedFindingsResult;

        private String clientRequestToken;

        private Double confidenceThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutomatedReasoningPolicyTestCaseRequest model) {
            super(model);
            policyArn(model.policyArn);
            guardContent(model.guardContent);
            queryContent(model.queryContent);
            expectedAggregatedFindingsResult(model.expectedAggregatedFindingsResult);
            clientRequestToken(model.clientRequestToken);
            confidenceThreshold(model.confidenceThreshold);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getGuardContent() {
            return guardContent;
        }

        public final void setGuardContent(String guardContent) {
            this.guardContent = guardContent;
        }

        @Override
        public final Builder guardContent(String guardContent) {
            this.guardContent = guardContent;
            return this;
        }

        public final String getQueryContent() {
            return queryContent;
        }

        public final void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        @Override
        public final Builder queryContent(String queryContent) {
            this.queryContent = queryContent;
            return this;
        }

        public final String getExpectedAggregatedFindingsResult() {
            return expectedAggregatedFindingsResult;
        }

        public final void setExpectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
            return this;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult(expectedAggregatedFindingsResult == null ? null
                    : expectedAggregatedFindingsResult.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Double getConfidenceThreshold() {
            return confidenceThreshold;
        }

        public final void setConfidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutomatedReasoningPolicyTestCaseRequest build() {
            return new CreateAutomatedReasoningPolicyTestCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
