/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomModelRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateCustomModelRequest.Builder, CreateCustomModelRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelName").getter(getter(CreateCustomModelRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()).build();

    private static final SdkField<ModelDataSource> MODEL_SOURCE_CONFIG_FIELD = SdkField
            .<ModelDataSource> builder(MarshallingType.SDK_POJO).memberName("modelSourceConfig")
            .getter(getter(CreateCustomModelRequest::modelSourceConfig)).setter(setter(Builder::modelSourceConfig))
            .constructor(ModelDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSourceConfig").build()).build();

    private static final SdkField<String> MODEL_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelKmsKeyArn").getter(getter(CreateCustomModelRequest::modelKmsKeyArn))
            .setter(setter(Builder::modelKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelKmsKeyArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateCustomModelRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<Tag>> MODEL_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("modelTags")
            .getter(getter(CreateCustomModelRequest::modelTags))
            .setter(setter(Builder::modelTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateCustomModelRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_SOURCE_CONFIG_FIELD, MODEL_KMS_KEY_ARN_FIELD, ROLE_ARN_FIELD, MODEL_TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelName;

    private final ModelDataSource modelSourceConfig;

    private final String modelKmsKeyArn;

    private final String roleArn;

    private final List<Tag> modelTags;

    private final String clientRequestToken;

    private CreateCustomModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelSourceConfig = builder.modelSourceConfig;
        this.modelKmsKeyArn = builder.modelKmsKeyArn;
        this.roleArn = builder.roleArn;
        this.modelTags = builder.modelTags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * A unique name for the custom model.
     * </p>
     * 
     * @return A unique name for the custom model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The data source for the model. The Amazon S3 URI in the model source must be for the Amazon-managed Amazon S3
     * bucket containing your model artifacts.
     * </p>
     * 
     * @return The data source for the model. The Amazon S3 URI in the model source must be for the Amazon-managed
     *         Amazon S3 bucket containing your model artifacts.
     */
    public final ModelDataSource modelSourceConfig() {
        return modelSourceConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the customer managed KMS key to encrypt the custom model. If you don't provide
     * a KMS key, Amazon Bedrock uses an Amazon Web Services-managed KMS key to encrypt the model.
     * </p>
     * <p>
     * If you provide a customer managed KMS key, your Amazon Bedrock service role must have permissions to use it. For
     * more information see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/encryption-import-model.html">Encryption of imported
     * models</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the customer managed KMS key to encrypt the custom model. If you don't
     *         provide a KMS key, Amazon Bedrock uses an Amazon Web Services-managed KMS key to encrypt the model. </p>
     *         <p>
     *         If you provide a customer managed KMS key, your Amazon Bedrock service role must have permissions to use
     *         it. For more information see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/encryption-import-model.html">Encryption of
     *         imported models</a>.
     */
    public final String modelKmsKeyArn() {
        return modelKmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock assumes to perform tasks on your
     * behalf. This role must have permissions to access the Amazon S3 bucket containing your model artifacts and the
     * KMS key (if specified). For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-import-iam-role.html">Setting up an IAM service
     * role for importing models</a> in the Amazon Bedrock User Guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock assumes to perform tasks on
     *         your behalf. This role must have permissions to access the Amazon S3 bucket containing your model
     *         artifacts and the KMS key (if specified). For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-import-iam-role.html">Setting up an IAM
     *         service role for importing models</a> in the Amazon Bedrock User Guide.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModelTags() {
        return modelTags != null && !(modelTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs to associate with the custom model resource. You can use these tags to organize and
     * identify your resources.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging
     * resources</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon
     * Bedrock User Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to associate with the custom model resource. You can use these tags to organize
     *         and identify your resources.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources</a> in the <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     *         Guide</a>.
     */
    public final List<Tag> modelTags() {
        return modelTags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelTags() ? modelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomModelRequest)) {
            return false;
        }
        CreateCustomModelRequest other = (CreateCustomModelRequest) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelSourceConfig(), other.modelSourceConfig())
                && Objects.equals(modelKmsKeyArn(), other.modelKmsKeyArn()) && Objects.equals(roleArn(), other.roleArn())
                && hasModelTags() == other.hasModelTags() && Objects.equals(modelTags(), other.modelTags())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomModelRequest").add("ModelName", modelName())
                .add("ModelSourceConfig", modelSourceConfig()).add("ModelKmsKeyArn", modelKmsKeyArn()).add("RoleArn", roleArn())
                .add("ModelTags", hasModelTags() ? modelTags() : null).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "modelSourceConfig":
            return Optional.ofNullable(clazz.cast(modelSourceConfig()));
        case "modelKmsKeyArn":
            return Optional.ofNullable(clazz.cast(modelKmsKeyArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "modelTags":
            return Optional.ofNullable(clazz.cast(modelTags()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelName", MODEL_NAME_FIELD);
        map.put("modelSourceConfig", MODEL_SOURCE_CONFIG_FIELD);
        map.put("modelKmsKeyArn", MODEL_KMS_KEY_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("modelTags", MODEL_TAGS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomModelRequest, T> g) {
        return obj -> g.apply((CreateCustomModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomModelRequest> {
        /**
         * <p>
         * A unique name for the custom model.
         * </p>
         * 
         * @param modelName
         *        A unique name for the custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The data source for the model. The Amazon S3 URI in the model source must be for the Amazon-managed Amazon S3
         * bucket containing your model artifacts.
         * </p>
         * 
         * @param modelSourceConfig
         *        The data source for the model. The Amazon S3 URI in the model source must be for the Amazon-managed
         *        Amazon S3 bucket containing your model artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSourceConfig(ModelDataSource modelSourceConfig);

        /**
         * <p>
         * The data source for the model. The Amazon S3 URI in the model source must be for the Amazon-managed Amazon S3
         * bucket containing your model artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDataSource.Builder} avoiding the
         * need to create one manually via {@link ModelDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #modelSourceConfig(ModelDataSource)}.
         * 
         * @param modelSourceConfig
         *        a consumer that will call methods on {@link ModelDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelSourceConfig(ModelDataSource)
         */
        default Builder modelSourceConfig(Consumer<ModelDataSource.Builder> modelSourceConfig) {
            return modelSourceConfig(ModelDataSource.builder().applyMutation(modelSourceConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the customer managed KMS key to encrypt the custom model. If you don't
         * provide a KMS key, Amazon Bedrock uses an Amazon Web Services-managed KMS key to encrypt the model.
         * </p>
         * <p>
         * If you provide a customer managed KMS key, your Amazon Bedrock service role must have permissions to use it.
         * For more information see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/encryption-import-model.html">Encryption of
         * imported models</a>.
         * </p>
         * 
         * @param modelKmsKeyArn
         *        The Amazon Resource Name (ARN) of the customer managed KMS key to encrypt the custom model. If you
         *        don't provide a KMS key, Amazon Bedrock uses an Amazon Web Services-managed KMS key to encrypt the
         *        model. </p>
         *        <p>
         *        If you provide a customer managed KMS key, your Amazon Bedrock service role must have permissions to
         *        use it. For more information see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/encryption-import-model.html">Encryption of
         *        imported models</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelKmsKeyArn(String modelKmsKeyArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock assumes to perform tasks on your
         * behalf. This role must have permissions to access the Amazon S3 bucket containing your model artifacts and
         * the KMS key (if specified). For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-import-iam-role.html">Setting up an IAM
         * service role for importing models</a> in the Amazon Bedrock User Guide.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock assumes to perform tasks on
         *        your behalf. This role must have permissions to access the Amazon S3 bucket containing your model
         *        artifacts and the KMS key (if specified). For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-import-iam-role.html">Setting up an
         *        IAM service role for importing models</a> in the Amazon Bedrock User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of key-value pairs to associate with the custom model resource. You can use these tags to organize and
         * identify your resources.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging
         * resources</a> in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
         * Guide</a>.
         * </p>
         * 
         * @param modelTags
         *        A list of key-value pairs to associate with the custom model resource. You can use these tags to
         *        organize and identify your resources.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources</a> in the
         *        <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock
         *        User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelTags(Collection<Tag> modelTags);

        /**
         * <p>
         * A list of key-value pairs to associate with the custom model resource. You can use these tags to organize and
         * identify your resources.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging
         * resources</a> in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
         * Guide</a>.
         * </p>
         * 
         * @param modelTags
         *        A list of key-value pairs to associate with the custom model resource. You can use these tags to
         *        organize and identify your resources.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources</a> in the
         *        <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock
         *        User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelTags(Tag... modelTags);

        /**
         * <p>
         * A list of key-value pairs to associate with the custom model resource. You can use these tags to organize and
         * identify your resources.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging
         * resources</a> in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
         * Guide</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #modelTags(List<Tag>)}.
         * 
         * @param modelTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelTags(java.util.Collection<Tag>)
         */
        Builder modelTags(Consumer<Tag.Builder>... modelTags);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String modelName;

        private ModelDataSource modelSourceConfig;

        private String modelKmsKeyArn;

        private String roleArn;

        private List<Tag> modelTags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomModelRequest model) {
            super(model);
            modelName(model.modelName);
            modelSourceConfig(model.modelSourceConfig);
            modelKmsKeyArn(model.modelKmsKeyArn);
            roleArn(model.roleArn);
            modelTags(model.modelTags);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final ModelDataSource.Builder getModelSourceConfig() {
            return modelSourceConfig != null ? modelSourceConfig.toBuilder() : null;
        }

        public final void setModelSourceConfig(ModelDataSource.BuilderImpl modelSourceConfig) {
            this.modelSourceConfig = modelSourceConfig != null ? modelSourceConfig.build() : null;
        }

        @Override
        public final Builder modelSourceConfig(ModelDataSource modelSourceConfig) {
            this.modelSourceConfig = modelSourceConfig;
            return this;
        }

        public final String getModelKmsKeyArn() {
            return modelKmsKeyArn;
        }

        public final void setModelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
        }

        @Override
        public final Builder modelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.modelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelTags(Collection<Tag.BuilderImpl> modelTags) {
            this.modelTags = TagListCopier.copyFromBuilder(modelTags);
        }

        @Override
        public final Builder modelTags(Collection<Tag> modelTags) {
            this.modelTags = TagListCopier.copy(modelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelTags(Tag... modelTags) {
            modelTags(Arrays.asList(modelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelTags(Consumer<Tag.Builder>... modelTags) {
            modelTags(Stream.of(modelTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomModelRequest build() {
            return new CreateCustomModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
