/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFoundationModelAgreementResponse extends BedrockResponse implements
        ToCopyableBuilder<CreateFoundationModelAgreementResponse.Builder, CreateFoundationModelAgreementResponse> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(CreateFoundationModelAgreementResponse::modelId))
            .setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelId;

    private CreateFoundationModelAgreementResponse(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
    }

    /**
     * <p>
     * Model Id of the model for the access request.
     * </p>
     * 
     * @return Model Id of the model for the access request.
     */
    public final String modelId() {
        return modelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFoundationModelAgreementResponse)) {
            return false;
        }
        CreateFoundationModelAgreementResponse other = (CreateFoundationModelAgreementResponse) obj;
        return Objects.equals(modelId(), other.modelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFoundationModelAgreementResponse").add("ModelId", modelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelId", MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFoundationModelAgreementResponse, T> g) {
        return obj -> g.apply((CreateFoundationModelAgreementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateFoundationModelAgreementResponse> {
        /**
         * <p>
         * Model Id of the model for the access request.
         * </p>
         * 
         * @param modelId
         *        Model Id of the model for the access request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String modelId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFoundationModelAgreementResponse model) {
            super(model);
            modelId(model.modelId);
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        public CreateFoundationModelAgreementResponse build() {
            return new CreateFoundationModelAgreementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
