/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePromptRouterRequest extends BedrockRequest implements
        ToCopyableBuilder<CreatePromptRouterRequest.Builder, CreatePromptRouterRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreatePromptRouterRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> PROMPT_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptRouterName").getter(getter(CreatePromptRouterRequest::promptRouterName))
            .setter(setter(Builder::promptRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptRouterName").build()).build();

    private static final SdkField<List<PromptRouterTargetModel>> MODELS_FIELD = SdkField
            .<List<PromptRouterTargetModel>> builder(MarshallingType.LIST)
            .memberName("models")
            .getter(getter(CreatePromptRouterRequest::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptRouterTargetModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptRouterTargetModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreatePromptRouterRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<RoutingCriteria> ROUTING_CRITERIA_FIELD = SdkField
            .<RoutingCriteria> builder(MarshallingType.SDK_POJO).memberName("routingCriteria")
            .getter(getter(CreatePromptRouterRequest::routingCriteria)).setter(setter(Builder::routingCriteria))
            .constructor(RoutingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingCriteria").build()).build();

    private static final SdkField<PromptRouterTargetModel> FALLBACK_MODEL_FIELD = SdkField
            .<PromptRouterTargetModel> builder(MarshallingType.SDK_POJO).memberName("fallbackModel")
            .getter(getter(CreatePromptRouterRequest::fallbackModel)).setter(setter(Builder::fallbackModel))
            .constructor(PromptRouterTargetModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackModel").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreatePromptRouterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            PROMPT_ROUTER_NAME_FIELD, MODELS_FIELD, DESCRIPTION_FIELD, ROUTING_CRITERIA_FIELD, FALLBACK_MODEL_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientRequestToken;

    private final String promptRouterName;

    private final List<PromptRouterTargetModel> models;

    private final String description;

    private final RoutingCriteria routingCriteria;

    private final PromptRouterTargetModel fallbackModel;

    private final List<Tag> tags;

    private CreatePromptRouterRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.promptRouterName = builder.promptRouterName;
        this.models = builder.models;
        this.description = builder.description;
        this.routingCriteria = builder.routingCriteria;
        this.fallbackModel = builder.fallbackModel;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure idempotency of your requests. If not specified,
     * the Amazon Web Services SDK automatically generates one for you.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure idempotency of your requests. If not
     *         specified, the Amazon Web Services SDK automatically generates one for you.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The name of the prompt router. The name must be unique within your Amazon Web Services account in the current
     * region.
     * </p>
     * 
     * @return The name of the prompt router. The name must be unique within your Amazon Web Services account in the
     *         current region.
     */
    public final String promptRouterName() {
        return promptRouterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of foundation models that the prompt router can route requests to. At least one model must be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return A list of foundation models that the prompt router can route requests to. At least one model must be
     *         specified.
     */
    public final List<PromptRouterTargetModel> models() {
        return models;
    }

    /**
     * <p>
     * An optional description of the prompt router to help identify its purpose.
     * </p>
     * 
     * @return An optional description of the prompt router to help identify its purpose.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The criteria, which is the response quality difference, used to determine how incoming requests are routed to
     * different models.
     * </p>
     * 
     * @return The criteria, which is the response quality difference, used to determine how incoming requests are
     *         routed to different models.
     */
    public final RoutingCriteria routingCriteria() {
        return routingCriteria;
    }

    /**
     * <p>
     * The default model to use when the routing criteria is not met.
     * </p>
     * 
     * @return The default model to use when the routing criteria is not met.
     */
    public final PromptRouterTargetModel fallbackModel() {
        return fallbackModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs to apply to this resource as tags. You can use tags to categorize and manage your
     * Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs to apply to this resource as tags. You can use tags to categorize and manage
     *         your Amazon Web Services resources.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(promptRouterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(routingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(fallbackModel());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePromptRouterRequest)) {
            return false;
        }
        CreatePromptRouterRequest other = (CreatePromptRouterRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(promptRouterName(), other.promptRouterName()) && hasModels() == other.hasModels()
                && Objects.equals(models(), other.models()) && Objects.equals(description(), other.description())
                && Objects.equals(routingCriteria(), other.routingCriteria())
                && Objects.equals(fallbackModel(), other.fallbackModel()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePromptRouterRequest").add("ClientRequestToken", clientRequestToken())
                .add("PromptRouterName", promptRouterName()).add("Models", hasModels() ? models() : null)
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RoutingCriteria", routingCriteria()).add("FallbackModel", fallbackModel())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "promptRouterName":
            return Optional.ofNullable(clazz.cast(promptRouterName()));
        case "models":
            return Optional.ofNullable(clazz.cast(models()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "routingCriteria":
            return Optional.ofNullable(clazz.cast(routingCriteria()));
        case "fallbackModel":
            return Optional.ofNullable(clazz.cast(fallbackModel()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("promptRouterName", PROMPT_ROUTER_NAME_FIELD);
        map.put("models", MODELS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("routingCriteria", ROUTING_CRITERIA_FIELD);
        map.put("fallbackModel", FALLBACK_MODEL_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePromptRouterRequest, T> g) {
        return obj -> g.apply((CreatePromptRouterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePromptRouterRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure idempotency of your requests. If not
         * specified, the Amazon Web Services SDK automatically generates one for you.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure idempotency of your requests. If not
         *        specified, the Amazon Web Services SDK automatically generates one for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The name of the prompt router. The name must be unique within your Amazon Web Services account in the current
         * region.
         * </p>
         * 
         * @param promptRouterName
         *        The name of the prompt router. The name must be unique within your Amazon Web Services account in the
         *        current region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptRouterName(String promptRouterName);

        /**
         * <p>
         * A list of foundation models that the prompt router can route requests to. At least one model must be
         * specified.
         * </p>
         * 
         * @param models
         *        A list of foundation models that the prompt router can route requests to. At least one model must be
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<PromptRouterTargetModel> models);

        /**
         * <p>
         * A list of foundation models that the prompt router can route requests to. At least one model must be
         * specified.
         * </p>
         * 
         * @param models
         *        A list of foundation models that the prompt router can route requests to. At least one model must be
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(PromptRouterTargetModel... models);

        /**
         * <p>
         * A list of foundation models that the prompt router can route requests to. At least one model must be
         * specified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel.Builder#build()} is called
         * immediately and its result is passed to {@link #models(List<PromptRouterTargetModel>)}.
         * 
         * @param models
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.PromptRouterTargetModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(java.util.Collection<PromptRouterTargetModel>)
         */
        Builder models(Consumer<PromptRouterTargetModel.Builder>... models);

        /**
         * <p>
         * An optional description of the prompt router to help identify its purpose.
         * </p>
         * 
         * @param description
         *        An optional description of the prompt router to help identify its purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The criteria, which is the response quality difference, used to determine how incoming requests are routed to
         * different models.
         * </p>
         * 
         * @param routingCriteria
         *        The criteria, which is the response quality difference, used to determine how incoming requests are
         *        routed to different models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingCriteria(RoutingCriteria routingCriteria);

        /**
         * <p>
         * The criteria, which is the response quality difference, used to determine how incoming requests are routed to
         * different models.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingCriteria.Builder} avoiding the
         * need to create one manually via {@link RoutingCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #routingCriteria(RoutingCriteria)}.
         * 
         * @param routingCriteria
         *        a consumer that will call methods on {@link RoutingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingCriteria(RoutingCriteria)
         */
        default Builder routingCriteria(Consumer<RoutingCriteria.Builder> routingCriteria) {
            return routingCriteria(RoutingCriteria.builder().applyMutation(routingCriteria).build());
        }

        /**
         * <p>
         * The default model to use when the routing criteria is not met.
         * </p>
         * 
         * @param fallbackModel
         *        The default model to use when the routing criteria is not met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fallbackModel(PromptRouterTargetModel fallbackModel);

        /**
         * <p>
         * The default model to use when the routing criteria is not met.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptRouterTargetModel.Builder} avoiding
         * the need to create one manually via {@link PromptRouterTargetModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptRouterTargetModel.Builder#build()} is called immediately
         * and its result is passed to {@link #fallbackModel(PromptRouterTargetModel)}.
         * 
         * @param fallbackModel
         *        a consumer that will call methods on {@link PromptRouterTargetModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fallbackModel(PromptRouterTargetModel)
         */
        default Builder fallbackModel(Consumer<PromptRouterTargetModel.Builder> fallbackModel) {
            return fallbackModel(PromptRouterTargetModel.builder().applyMutation(fallbackModel).build());
        }

        /**
         * <p>
         * An array of key-value pairs to apply to this resource as tags. You can use tags to categorize and manage your
         * Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs to apply to this resource as tags. You can use tags to categorize and
         *        manage your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs to apply to this resource as tags. You can use tags to categorize and manage your
         * Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs to apply to this resource as tags. You can use tags to categorize and
         *        manage your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs to apply to this resource as tags. You can use tags to categorize and manage your
         * Amazon Web Services resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String promptRouterName;

        private List<PromptRouterTargetModel> models = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private RoutingCriteria routingCriteria;

        private PromptRouterTargetModel fallbackModel;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePromptRouterRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            promptRouterName(model.promptRouterName);
            models(model.models);
            description(model.description);
            routingCriteria(model.routingCriteria);
            fallbackModel(model.fallbackModel);
            tags(model.tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getPromptRouterName() {
            return promptRouterName;
        }

        public final void setPromptRouterName(String promptRouterName) {
            this.promptRouterName = promptRouterName;
        }

        @Override
        public final Builder promptRouterName(String promptRouterName) {
            this.promptRouterName = promptRouterName;
            return this;
        }

        public final List<PromptRouterTargetModel.Builder> getModels() {
            List<PromptRouterTargetModel.Builder> result = PromptRouterTargetModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<PromptRouterTargetModel.BuilderImpl> models) {
            this.models = PromptRouterTargetModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<PromptRouterTargetModel> models) {
            this.models = PromptRouterTargetModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(PromptRouterTargetModel... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<PromptRouterTargetModel.Builder>... models) {
            models(Stream.of(models).map(c -> PromptRouterTargetModel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RoutingCriteria.Builder getRoutingCriteria() {
            return routingCriteria != null ? routingCriteria.toBuilder() : null;
        }

        public final void setRoutingCriteria(RoutingCriteria.BuilderImpl routingCriteria) {
            this.routingCriteria = routingCriteria != null ? routingCriteria.build() : null;
        }

        @Override
        public final Builder routingCriteria(RoutingCriteria routingCriteria) {
            this.routingCriteria = routingCriteria;
            return this;
        }

        public final PromptRouterTargetModel.Builder getFallbackModel() {
            return fallbackModel != null ? fallbackModel.toBuilder() : null;
        }

        public final void setFallbackModel(PromptRouterTargetModel.BuilderImpl fallbackModel) {
            this.fallbackModel = fallbackModel != null ? fallbackModel.build() : null;
        }

        @Override
        public final Builder fallbackModel(PromptRouterTargetModel fallbackModel) {
            this.fallbackModel = fallbackModel;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePromptRouterRequest build() {
            return new CreatePromptRouterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
