/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the models, Knowledge Bases, or other RAG sources evaluated in a model or Knowledge Base evaluation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationInferenceConfigSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationInferenceConfigSummary.Builder, EvaluationInferenceConfigSummary> {
    private static final SdkField<EvaluationModelConfigSummary> MODEL_CONFIG_SUMMARY_FIELD = SdkField
            .<EvaluationModelConfigSummary> builder(MarshallingType.SDK_POJO).memberName("modelConfigSummary")
            .getter(getter(EvaluationInferenceConfigSummary::modelConfigSummary)).setter(setter(Builder::modelConfigSummary))
            .constructor(EvaluationModelConfigSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelConfigSummary").build())
            .build();

    private static final SdkField<EvaluationRagConfigSummary> RAG_CONFIG_SUMMARY_FIELD = SdkField
            .<EvaluationRagConfigSummary> builder(MarshallingType.SDK_POJO).memberName("ragConfigSummary")
            .getter(getter(EvaluationInferenceConfigSummary::ragConfigSummary)).setter(setter(Builder::ragConfigSummary))
            .constructor(EvaluationRagConfigSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ragConfigSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CONFIG_SUMMARY_FIELD,
            RAG_CONFIG_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationModelConfigSummary modelConfigSummary;

    private final EvaluationRagConfigSummary ragConfigSummary;

    private EvaluationInferenceConfigSummary(BuilderImpl builder) {
        this.modelConfigSummary = builder.modelConfigSummary;
        this.ragConfigSummary = builder.ragConfigSummary;
    }

    /**
     * <p>
     * A summary of the models used in an Amazon Bedrock model evaluation job. These resources can be models in Amazon
     * Bedrock or models outside of Amazon Bedrock that you use to generate your own inference response data.
     * </p>
     * 
     * @return A summary of the models used in an Amazon Bedrock model evaluation job. These resources can be models in
     *         Amazon Bedrock or models outside of Amazon Bedrock that you use to generate your own inference response
     *         data.
     */
    public final EvaluationModelConfigSummary modelConfigSummary() {
        return modelConfigSummary;
    }

    /**
     * <p>
     * A summary of the RAG resources used in an Amazon Bedrock Knowledge Base evaluation job. These resources can be
     * Knowledge Bases in Amazon Bedrock or RAG sources outside of Amazon Bedrock that you use to generate your own
     * inference response data.
     * </p>
     * 
     * @return A summary of the RAG resources used in an Amazon Bedrock Knowledge Base evaluation job. These resources
     *         can be Knowledge Bases in Amazon Bedrock or RAG sources outside of Amazon Bedrock that you use to
     *         generate your own inference response data.
     */
    public final EvaluationRagConfigSummary ragConfigSummary() {
        return ragConfigSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelConfigSummary());
        hashCode = 31 * hashCode + Objects.hashCode(ragConfigSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationInferenceConfigSummary)) {
            return false;
        }
        EvaluationInferenceConfigSummary other = (EvaluationInferenceConfigSummary) obj;
        return Objects.equals(modelConfigSummary(), other.modelConfigSummary())
                && Objects.equals(ragConfigSummary(), other.ragConfigSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationInferenceConfigSummary").add("ModelConfigSummary", modelConfigSummary())
                .add("RagConfigSummary", ragConfigSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelConfigSummary":
            return Optional.ofNullable(clazz.cast(modelConfigSummary()));
        case "ragConfigSummary":
            return Optional.ofNullable(clazz.cast(ragConfigSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelConfigSummary", MODEL_CONFIG_SUMMARY_FIELD);
        map.put("ragConfigSummary", RAG_CONFIG_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationInferenceConfigSummary, T> g) {
        return obj -> g.apply((EvaluationInferenceConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationInferenceConfigSummary> {
        /**
         * <p>
         * A summary of the models used in an Amazon Bedrock model evaluation job. These resources can be models in
         * Amazon Bedrock or models outside of Amazon Bedrock that you use to generate your own inference response data.
         * </p>
         * 
         * @param modelConfigSummary
         *        A summary of the models used in an Amazon Bedrock model evaluation job. These resources can be models
         *        in Amazon Bedrock or models outside of Amazon Bedrock that you use to generate your own inference
         *        response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelConfigSummary(EvaluationModelConfigSummary modelConfigSummary);

        /**
         * <p>
         * A summary of the models used in an Amazon Bedrock model evaluation job. These resources can be models in
         * Amazon Bedrock or models outside of Amazon Bedrock that you use to generate your own inference response data.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationModelConfigSummary.Builder}
         * avoiding the need to create one manually via {@link EvaluationModelConfigSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationModelConfigSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #modelConfigSummary(EvaluationModelConfigSummary)}.
         * 
         * @param modelConfigSummary
         *        a consumer that will call methods on {@link EvaluationModelConfigSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelConfigSummary(EvaluationModelConfigSummary)
         */
        default Builder modelConfigSummary(Consumer<EvaluationModelConfigSummary.Builder> modelConfigSummary) {
            return modelConfigSummary(EvaluationModelConfigSummary.builder().applyMutation(modelConfigSummary).build());
        }

        /**
         * <p>
         * A summary of the RAG resources used in an Amazon Bedrock Knowledge Base evaluation job. These resources can
         * be Knowledge Bases in Amazon Bedrock or RAG sources outside of Amazon Bedrock that you use to generate your
         * own inference response data.
         * </p>
         * 
         * @param ragConfigSummary
         *        A summary of the RAG resources used in an Amazon Bedrock Knowledge Base evaluation job. These
         *        resources can be Knowledge Bases in Amazon Bedrock or RAG sources outside of Amazon Bedrock that you
         *        use to generate your own inference response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ragConfigSummary(EvaluationRagConfigSummary ragConfigSummary);

        /**
         * <p>
         * A summary of the RAG resources used in an Amazon Bedrock Knowledge Base evaluation job. These resources can
         * be Knowledge Bases in Amazon Bedrock or RAG sources outside of Amazon Bedrock that you use to generate your
         * own inference response data.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationRagConfigSummary.Builder}
         * avoiding the need to create one manually via {@link EvaluationRagConfigSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationRagConfigSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #ragConfigSummary(EvaluationRagConfigSummary)}.
         * 
         * @param ragConfigSummary
         *        a consumer that will call methods on {@link EvaluationRagConfigSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ragConfigSummary(EvaluationRagConfigSummary)
         */
        default Builder ragConfigSummary(Consumer<EvaluationRagConfigSummary.Builder> ragConfigSummary) {
            return ragConfigSummary(EvaluationRagConfigSummary.builder().applyMutation(ragConfigSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EvaluationModelConfigSummary modelConfigSummary;

        private EvaluationRagConfigSummary ragConfigSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationInferenceConfigSummary model) {
            modelConfigSummary(model.modelConfigSummary);
            ragConfigSummary(model.ragConfigSummary);
        }

        public final EvaluationModelConfigSummary.Builder getModelConfigSummary() {
            return modelConfigSummary != null ? modelConfigSummary.toBuilder() : null;
        }

        public final void setModelConfigSummary(EvaluationModelConfigSummary.BuilderImpl modelConfigSummary) {
            this.modelConfigSummary = modelConfigSummary != null ? modelConfigSummary.build() : null;
        }

        @Override
        public final Builder modelConfigSummary(EvaluationModelConfigSummary modelConfigSummary) {
            this.modelConfigSummary = modelConfigSummary;
            return this;
        }

        public final EvaluationRagConfigSummary.Builder getRagConfigSummary() {
            return ragConfigSummary != null ? ragConfigSummary.toBuilder() : null;
        }

        public final void setRagConfigSummary(EvaluationRagConfigSummary.BuilderImpl ragConfigSummary) {
            this.ragConfigSummary = ragConfigSummary != null ? ragConfigSummary.build() : null;
        }

        @Override
        public final Builder ragConfigSummary(EvaluationRagConfigSummary ragConfigSummary) {
            this.ragConfigSummary = ragConfigSummary;
            return this;
        }

        @Override
        public EvaluationInferenceConfigSummary build() {
            return new EvaluationInferenceConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
