/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for integrating Automated Reasoning policies with Amazon Bedrock Guardrails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailAutomatedReasoningPolicyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailAutomatedReasoningPolicyConfig.Builder, GuardrailAutomatedReasoningPolicyConfig> {
    private static final SdkField<List<String>> POLICIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("policies")
            .getter(getter(GuardrailAutomatedReasoningPolicyConfig::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> CONFIDENCE_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("confidenceThreshold").getter(getter(GuardrailAutomatedReasoningPolicyConfig::confidenceThreshold))
            .setter(setter(Builder::confidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD,
            CONFIDENCE_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> policies;

    private final Double confidenceThreshold;

    private GuardrailAutomatedReasoningPolicyConfig(BuilderImpl builder) {
        this.policies = builder.policies;
        this.confidenceThreshold = builder.confidenceThreshold;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Automated Reasoning policy ARNs to include in the guardrail configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return The list of Automated Reasoning policy ARNs to include in the guardrail configuration.
     */
    public final List<String> policies() {
        return policies;
    }

    /**
     * <p>
     * The confidence threshold for triggering guardrail actions based on Automated Reasoning policy violations.
     * </p>
     * 
     * @return The confidence threshold for triggering guardrail actions based on Automated Reasoning policy violations.
     */
    public final Double confidenceThreshold() {
        return confidenceThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(confidenceThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningPolicyConfig)) {
            return false;
        }
        GuardrailAutomatedReasoningPolicyConfig other = (GuardrailAutomatedReasoningPolicyConfig) obj;
        return hasPolicies() == other.hasPolicies() && Objects.equals(policies(), other.policies())
                && Objects.equals(confidenceThreshold(), other.confidenceThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailAutomatedReasoningPolicyConfig").add("Policies", hasPolicies() ? policies() : null)
                .add("ConfidenceThreshold", confidenceThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "confidenceThreshold":
            return Optional.ofNullable(clazz.cast(confidenceThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policies", POLICIES_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningPolicyConfig, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningPolicyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailAutomatedReasoningPolicyConfig> {
        /**
         * <p>
         * The list of Automated Reasoning policy ARNs to include in the guardrail configuration.
         * </p>
         * 
         * @param policies
         *        The list of Automated Reasoning policy ARNs to include in the guardrail configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<String> policies);

        /**
         * <p>
         * The list of Automated Reasoning policy ARNs to include in the guardrail configuration.
         * </p>
         * 
         * @param policies
         *        The list of Automated Reasoning policy ARNs to include in the guardrail configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(String... policies);

        /**
         * <p>
         * The confidence threshold for triggering guardrail actions based on Automated Reasoning policy violations.
         * </p>
         * 
         * @param confidenceThreshold
         *        The confidence threshold for triggering guardrail actions based on Automated Reasoning policy
         *        violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidenceThreshold(Double confidenceThreshold);
    }

    static final class BuilderImpl implements Builder {
        private List<String> policies = DefaultSdkAutoConstructList.getInstance();

        private Double confidenceThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningPolicyConfig model) {
            policies(model.policies);
            confidenceThreshold(model.confidenceThreshold);
        }

        public final Collection<String> getPolicies() {
            if (policies instanceof SdkAutoConstructList) {
                return null;
            }
            return policies;
        }

        public final void setPolicies(Collection<String> policies) {
            this.policies = GuardrailAutomatedReasoningPolicyConfigPoliciesListCopier.copy(policies);
        }

        @Override
        public final Builder policies(Collection<String> policies) {
            this.policies = GuardrailAutomatedReasoningPolicyConfigPoliciesListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(String... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        public final Double getConfidenceThreshold() {
            return confidenceThreshold;
        }

        public final void setConfidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        @Override
        public GuardrailAutomatedReasoningPolicyConfig build() {
            return new GuardrailAutomatedReasoningPolicyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
