/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for using invocation logs to customize a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvocationLogsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InvocationLogsConfig.Builder, InvocationLogsConfig> {
    private static final SdkField<Boolean> USE_PROMPT_RESPONSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("usePromptResponse").getter(getter(InvocationLogsConfig::usePromptResponse))
            .setter(setter(Builder::usePromptResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usePromptResponse").build()).build();

    private static final SdkField<InvocationLogSource> INVOCATION_LOG_SOURCE_FIELD = SdkField
            .<InvocationLogSource> builder(MarshallingType.SDK_POJO).memberName("invocationLogSource")
            .getter(getter(InvocationLogsConfig::invocationLogSource)).setter(setter(Builder::invocationLogSource))
            .constructor(InvocationLogSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationLogSource").build())
            .build();

    private static final SdkField<RequestMetadataFilters> REQUEST_METADATA_FILTERS_FIELD = SdkField
            .<RequestMetadataFilters> builder(MarshallingType.SDK_POJO).memberName("requestMetadataFilters")
            .getter(getter(InvocationLogsConfig::requestMetadataFilters)).setter(setter(Builder::requestMetadataFilters))
            .constructor(RequestMetadataFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMetadataFilters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_PROMPT_RESPONSE_FIELD,
            INVOCATION_LOG_SOURCE_FIELD, REQUEST_METADATA_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean usePromptResponse;

    private final InvocationLogSource invocationLogSource;

    private final RequestMetadataFilters requestMetadataFilters;

    private InvocationLogsConfig(BuilderImpl builder) {
        this.usePromptResponse = builder.usePromptResponse;
        this.invocationLogSource = builder.invocationLogSource;
        this.requestMetadataFilters = builder.requestMetadataFilters;
    }

    /**
     * <p>
     * Whether to use the model's response for training, or just the prompt. The default value is <code>False</code>.
     * </p>
     * 
     * @return Whether to use the model's response for training, or just the prompt. The default value is
     *         <code>False</code>.
     */
    public final Boolean usePromptResponse() {
        return usePromptResponse;
    }

    /**
     * <p>
     * The source of the invocation logs.
     * </p>
     * 
     * @return The source of the invocation logs.
     */
    public final InvocationLogSource invocationLogSource() {
        return invocationLogSource;
    }

    /**
     * <p>
     * Rules for filtering invocation logs based on request metadata.
     * </p>
     * 
     * @return Rules for filtering invocation logs based on request metadata.
     */
    public final RequestMetadataFilters requestMetadataFilters() {
        return requestMetadataFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usePromptResponse());
        hashCode = 31 * hashCode + Objects.hashCode(invocationLogSource());
        hashCode = 31 * hashCode + Objects.hashCode(requestMetadataFilters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationLogsConfig)) {
            return false;
        }
        InvocationLogsConfig other = (InvocationLogsConfig) obj;
        return Objects.equals(usePromptResponse(), other.usePromptResponse())
                && Objects.equals(invocationLogSource(), other.invocationLogSource())
                && Objects.equals(requestMetadataFilters(), other.requestMetadataFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvocationLogsConfig").add("UsePromptResponse", usePromptResponse())
                .add("InvocationLogSource", invocationLogSource()).add("RequestMetadataFilters", requestMetadataFilters())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usePromptResponse":
            return Optional.ofNullable(clazz.cast(usePromptResponse()));
        case "invocationLogSource":
            return Optional.ofNullable(clazz.cast(invocationLogSource()));
        case "requestMetadataFilters":
            return Optional.ofNullable(clazz.cast(requestMetadataFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("usePromptResponse", USE_PROMPT_RESPONSE_FIELD);
        map.put("invocationLogSource", INVOCATION_LOG_SOURCE_FIELD);
        map.put("requestMetadataFilters", REQUEST_METADATA_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationLogsConfig, T> g) {
        return obj -> g.apply((InvocationLogsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvocationLogsConfig> {
        /**
         * <p>
         * Whether to use the model's response for training, or just the prompt. The default value is <code>False</code>
         * .
         * </p>
         * 
         * @param usePromptResponse
         *        Whether to use the model's response for training, or just the prompt. The default value is
         *        <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePromptResponse(Boolean usePromptResponse);

        /**
         * <p>
         * The source of the invocation logs.
         * </p>
         * 
         * @param invocationLogSource
         *        The source of the invocation logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationLogSource(InvocationLogSource invocationLogSource);

        /**
         * <p>
         * The source of the invocation logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvocationLogSource.Builder} avoiding the
         * need to create one manually via {@link InvocationLogSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvocationLogSource.Builder#build()} is called immediately and
         * its result is passed to {@link #invocationLogSource(InvocationLogSource)}.
         * 
         * @param invocationLogSource
         *        a consumer that will call methods on {@link InvocationLogSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationLogSource(InvocationLogSource)
         */
        default Builder invocationLogSource(Consumer<InvocationLogSource.Builder> invocationLogSource) {
            return invocationLogSource(InvocationLogSource.builder().applyMutation(invocationLogSource).build());
        }

        /**
         * <p>
         * Rules for filtering invocation logs based on request metadata.
         * </p>
         * 
         * @param requestMetadataFilters
         *        Rules for filtering invocation logs based on request metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMetadataFilters(RequestMetadataFilters requestMetadataFilters);

        /**
         * <p>
         * Rules for filtering invocation logs based on request metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link RequestMetadataFilters.Builder} avoiding
         * the need to create one manually via {@link RequestMetadataFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestMetadataFilters.Builder#build()} is called immediately and
         * its result is passed to {@link #requestMetadataFilters(RequestMetadataFilters)}.
         * 
         * @param requestMetadataFilters
         *        a consumer that will call methods on {@link RequestMetadataFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestMetadataFilters(RequestMetadataFilters)
         */
        default Builder requestMetadataFilters(Consumer<RequestMetadataFilters.Builder> requestMetadataFilters) {
            return requestMetadataFilters(RequestMetadataFilters.builder().applyMutation(requestMetadataFilters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean usePromptResponse;

        private InvocationLogSource invocationLogSource;

        private RequestMetadataFilters requestMetadataFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationLogsConfig model) {
            usePromptResponse(model.usePromptResponse);
            invocationLogSource(model.invocationLogSource);
            requestMetadataFilters(model.requestMetadataFilters);
        }

        public final Boolean getUsePromptResponse() {
            return usePromptResponse;
        }

        public final void setUsePromptResponse(Boolean usePromptResponse) {
            this.usePromptResponse = usePromptResponse;
        }

        @Override
        public final Builder usePromptResponse(Boolean usePromptResponse) {
            this.usePromptResponse = usePromptResponse;
            return this;
        }

        public final InvocationLogSource.Builder getInvocationLogSource() {
            return invocationLogSource != null ? invocationLogSource.toBuilder() : null;
        }

        public final void setInvocationLogSource(InvocationLogSource.BuilderImpl invocationLogSource) {
            this.invocationLogSource = invocationLogSource != null ? invocationLogSource.build() : null;
        }

        @Override
        public final Builder invocationLogSource(InvocationLogSource invocationLogSource) {
            this.invocationLogSource = invocationLogSource;
            return this;
        }

        public final RequestMetadataFilters.Builder getRequestMetadataFilters() {
            return requestMetadataFilters != null ? requestMetadataFilters.toBuilder() : null;
        }

        public final void setRequestMetadataFilters(RequestMetadataFilters.BuilderImpl requestMetadataFilters) {
            this.requestMetadataFilters = requestMetadataFilters != null ? requestMetadataFilters.build() : null;
        }

        @Override
        public final Builder requestMetadataFilters(RequestMetadataFilters requestMetadataFilters) {
            this.requestMetadataFilters = requestMetadataFilters;
            return this;
        }

        @Override
        public InvocationLogsConfig build() {
            return new InvocationLogsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
