/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAutomatedReasoningPolicyAnnotationsRequest extends BedrockRequest
        implements
        ToCopyableBuilder<UpdateAutomatedReasoningPolicyAnnotationsRequest.Builder, UpdateAutomatedReasoningPolicyAnnotationsRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(UpdateAutomatedReasoningPolicyAnnotationsRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()).build();

    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildWorkflowId").getter(getter(UpdateAutomatedReasoningPolicyAnnotationsRequest::buildWorkflowId))
            .setter(setter(Builder::buildWorkflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("buildWorkflowId").build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyAnnotation>> ANNOTATIONS_FIELD = SdkField
            .<List<AutomatedReasoningPolicyAnnotation>> builder(MarshallingType.LIST)
            .memberName("annotations")
            .getter(getter(UpdateAutomatedReasoningPolicyAnnotationsRequest::annotations))
            .setter(setter(Builder::annotations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyAnnotation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyAnnotation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_UPDATED_ANNOTATION_SET_HASH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedAnnotationSetHash")
            .getter(getter(UpdateAutomatedReasoningPolicyAnnotationsRequest::lastUpdatedAnnotationSetHash))
            .setter(setter(Builder::lastUpdatedAnnotationSetHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAnnotationSetHash")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            BUILD_WORKFLOW_ID_FIELD, ANNOTATIONS_FIELD, LAST_UPDATED_ANNOTATION_SET_HASH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String buildWorkflowId;

    private final List<AutomatedReasoningPolicyAnnotation> annotations;

    private final String lastUpdatedAnnotationSetHash;

    private UpdateAutomatedReasoningPolicyAnnotationsRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowId = builder.buildWorkflowId;
        this.annotations = builder.annotations;
        this.lastUpdatedAnnotationSetHash = builder.lastUpdatedAnnotationSetHash;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy whose annotations you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy whose annotations you want to update.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The unique identifier of the build workflow whose annotations you want to update.
     * </p>
     * 
     * @return The unique identifier of the build workflow whose annotations you want to update.
     */
    public final String buildWorkflowId() {
        return buildWorkflowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Annotations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnnotations() {
        return annotations != null && !(annotations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated annotations containing modified rules, variables, and types for the policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotations} method.
     * </p>
     * 
     * @return The updated annotations containing modified rules, variables, and types for the policy.
     */
    public final List<AutomatedReasoningPolicyAnnotation> annotations() {
        return annotations;
    }

    /**
     * <p>
     * The hash value of the annotation set that you're updating. This is used for optimistic concurrency control to
     * prevent conflicting updates.
     * </p>
     * 
     * @return The hash value of the annotation set that you're updating. This is used for optimistic concurrency
     *         control to prevent conflicting updates.
     */
    public final String lastUpdatedAnnotationSetHash() {
        return lastUpdatedAnnotationSetHash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(buildWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotations() ? annotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAnnotationSetHash());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedReasoningPolicyAnnotationsRequest)) {
            return false;
        }
        UpdateAutomatedReasoningPolicyAnnotationsRequest other = (UpdateAutomatedReasoningPolicyAnnotationsRequest) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(buildWorkflowId(), other.buildWorkflowId())
                && hasAnnotations() == other.hasAnnotations() && Objects.equals(annotations(), other.annotations())
                && Objects.equals(lastUpdatedAnnotationSetHash(), other.lastUpdatedAnnotationSetHash());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAutomatedReasoningPolicyAnnotationsRequest").add("PolicyArn", policyArn())
                .add("BuildWorkflowId", buildWorkflowId()).add("Annotations", hasAnnotations() ? annotations() : null)
                .add("LastUpdatedAnnotationSetHash", lastUpdatedAnnotationSetHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "buildWorkflowId":
            return Optional.ofNullable(clazz.cast(buildWorkflowId()));
        case "annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        case "lastUpdatedAnnotationSetHash":
            return Optional.ofNullable(clazz.cast(lastUpdatedAnnotationSetHash()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        map.put("annotations", ANNOTATIONS_FIELD);
        map.put("lastUpdatedAnnotationSetHash", LAST_UPDATED_ANNOTATION_SET_HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedReasoningPolicyAnnotationsRequest, T> g) {
        return obj -> g.apply((UpdateAutomatedReasoningPolicyAnnotationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAutomatedReasoningPolicyAnnotationsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy whose annotations you want to update.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy whose annotations you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The unique identifier of the build workflow whose annotations you want to update.
         * </p>
         * 
         * @param buildWorkflowId
         *        The unique identifier of the build workflow whose annotations you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildWorkflowId(String buildWorkflowId);

        /**
         * <p>
         * The updated annotations containing modified rules, variables, and types for the policy.
         * </p>
         * 
         * @param annotations
         *        The updated annotations containing modified rules, variables, and types for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(Collection<AutomatedReasoningPolicyAnnotation> annotations);

        /**
         * <p>
         * The updated annotations containing modified rules, variables, and types for the policy.
         * </p>
         * 
         * @param annotations
         *        The updated annotations containing modified rules, variables, and types for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(AutomatedReasoningPolicyAnnotation... annotations);

        /**
         * <p>
         * The updated annotations containing modified rules, variables, and types for the policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation.Builder#build()} is
         * called immediately and its result is passed to {@link #annotations(List<AutomatedReasoningPolicyAnnotation>)}.
         * 
         * @param annotations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotations(java.util.Collection<AutomatedReasoningPolicyAnnotation>)
         */
        Builder annotations(Consumer<AutomatedReasoningPolicyAnnotation.Builder>... annotations);

        /**
         * <p>
         * The hash value of the annotation set that you're updating. This is used for optimistic concurrency control to
         * prevent conflicting updates.
         * </p>
         * 
         * @param lastUpdatedAnnotationSetHash
         *        The hash value of the annotation set that you're updating. This is used for optimistic concurrency
         *        control to prevent conflicting updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAnnotationSetHash(String lastUpdatedAnnotationSetHash);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String policyArn;

        private String buildWorkflowId;

        private List<AutomatedReasoningPolicyAnnotation> annotations = DefaultSdkAutoConstructList.getInstance();

        private String lastUpdatedAnnotationSetHash;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedReasoningPolicyAnnotationsRequest model) {
            super(model);
            policyArn(model.policyArn);
            buildWorkflowId(model.buildWorkflowId);
            annotations(model.annotations);
            lastUpdatedAnnotationSetHash(model.lastUpdatedAnnotationSetHash);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowId() {
            return buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        public final List<AutomatedReasoningPolicyAnnotation.Builder> getAnnotations() {
            List<AutomatedReasoningPolicyAnnotation.Builder> result = AutomatedReasoningPolicyAnnotationListCopier
                    .copyToBuilder(this.annotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotations(Collection<AutomatedReasoningPolicyAnnotation.BuilderImpl> annotations) {
            this.annotations = AutomatedReasoningPolicyAnnotationListCopier.copyFromBuilder(annotations);
        }

        @Override
        public final Builder annotations(Collection<AutomatedReasoningPolicyAnnotation> annotations) {
            this.annotations = AutomatedReasoningPolicyAnnotationListCopier.copy(annotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(AutomatedReasoningPolicyAnnotation... annotations) {
            annotations(Arrays.asList(annotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(Consumer<AutomatedReasoningPolicyAnnotation.Builder>... annotations) {
            annotations(Stream.of(annotations).map(c -> AutomatedReasoningPolicyAnnotation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getLastUpdatedAnnotationSetHash() {
            return lastUpdatedAnnotationSetHash;
        }

        public final void setLastUpdatedAnnotationSetHash(String lastUpdatedAnnotationSetHash) {
            this.lastUpdatedAnnotationSetHash = lastUpdatedAnnotationSetHash;
        }

        @Override
        public final Builder lastUpdatedAnnotationSetHash(String lastUpdatedAnnotationSetHash) {
            this.lastUpdatedAnnotationSetHash = lastUpdatedAnnotationSetHash;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomatedReasoningPolicyAnnotationsRequest build() {
            return new UpdateAutomatedReasoningPolicyAnnotationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
