/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the API Schema for the Action Group
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class APISchema implements SdkPojo, Serializable, ToCopyableBuilder<APISchema.Builder, APISchema> {
    private static final SdkField<S3Identifier> S3_FIELD = SdkField.<S3Identifier> builder(MarshallingType.SDK_POJO)
            .memberName("s3").getter(getter(APISchema::s3)).setter(setter(Builder::s3)).constructor(S3Identifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final SdkField<String> PAYLOAD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("payload")
            .getter(getter(APISchema::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD, PAYLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Identifier s3;

    private final String payload;

    private final Type type;

    private APISchema(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.payload = builder.payload;
        this.type = builder.type;
    }

    /**
     * Returns the value of the S3 property for this object.
     * 
     * @return The value of the S3 property for this object.
     */
    public final S3Identifier s3() {
        return s3;
    }

    /**
     * Returns the value of the Payload property for this object.
     * 
     * @return The value of the Payload property for this object.
     */
    public final String payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APISchema)) {
            return false;
        }
        APISchema other = (APISchema) obj;
        return Objects.equals(s3(), other.s3()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("APISchema").add("S3", s3())
                .add("Payload", payload() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * Sets the value of the S3 property for this object.
     *
     * @param s3
     *        The new value for the S3 property for this object.
     */
    public static APISchema fromS3(S3Identifier s3) {
        return builder().s3(s3).build();
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * Sets the value of the S3 property for this object.
     *
     * @param s3
     *        The new value for the S3 property for this object.
     */
    public static APISchema fromS3(Consumer<S3Identifier.Builder> s3) {
        S3Identifier.Builder builder = S3Identifier.builder();
        s3.accept(builder);
        return fromS3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #payload()} initialized to the given value.
     *
     * Sets the value of the Payload property for this object.
     *
     * @param payload
     *        The new value for the Payload property for this object.
     */
    public static APISchema fromPayload(String payload) {
        return builder().payload(payload).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<APISchema, T> g) {
        return obj -> g.apply((APISchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, APISchema> {
        /**
         * Sets the value of the S3 property for this object.
         *
         * @param s3
         *        The new value for the S3 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3Identifier s3);

        /**
         * Sets the value of the S3 property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Identifier.Builder} avoiding the need
         * to create one manually via {@link S3Identifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Identifier.Builder#build()} is called immediately and its
         * result is passed to {@link #s3(S3Identifier)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3Identifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3Identifier)
         */
        default Builder s3(Consumer<S3Identifier.Builder> s3) {
            return s3(S3Identifier.builder().applyMutation(s3).build());
        }

        /**
         * Sets the value of the Payload property for this object.
         *
         * @param payload
         *        The new value for the Payload property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(String payload);
    }

    static final class BuilderImpl implements Builder {
        private S3Identifier s3;

        private String payload;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(APISchema model) {
            s3(model.s3);
            payload(model.payload);
        }

        public final S3Identifier.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3Identifier.BuilderImpl s3) {
            Object oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(S3Identifier s3) {
            Object oldValue = this.s3;
            this.s3 = s3;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public final String getPayload() {
            return payload;
        }

        public final void setPayload(String payload) {
            Object oldValue = this.payload;
            this.payload = payload;
            handleUnionValueChange(Type.PAYLOAD, oldValue, this.payload);
        }

        @Override
        public final Builder payload(String payload) {
            Object oldValue = this.payload;
            this.payload = payload;
            handleUnionValueChange(Type.PAYLOAD, oldValue, this.payload);
            return this;
        }

        @Override
        public APISchema build() {
            return new APISchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see APISchema#type()
     */
    public enum Type {
        S3,

        PAYLOAD,

        UNKNOWN_TO_SDK_VERSION
    }
}
