/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ActionGroup Summary
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionGroupSummary.Builder, ActionGroupSummary> {
    private static final SdkField<String> ACTION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupId").getter(getter(ActionGroupSummary::actionGroupId)).setter(setter(Builder::actionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupId").build()).build();

    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupName").getter(getter(ActionGroupSummary::actionGroupName))
            .setter(setter(Builder::actionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()).build();

    private static final SdkField<String> ACTION_GROUP_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupState").getter(getter(ActionGroupSummary::actionGroupStateAsString))
            .setter(setter(Builder::actionGroupState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupState").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ActionGroupSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(ActionGroupSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_ID_FIELD,
            ACTION_GROUP_NAME_FIELD, ACTION_GROUP_STATE_FIELD, DESCRIPTION_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionGroupId;

    private final String actionGroupName;

    private final String actionGroupState;

    private final String description;

    private final Instant updatedAt;

    private ActionGroupSummary(BuilderImpl builder) {
        this.actionGroupId = builder.actionGroupId;
        this.actionGroupName = builder.actionGroupName;
        this.actionGroupState = builder.actionGroupState;
        this.description = builder.description;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * Returns the value of the ActionGroupId property for this object.
     * 
     * @return The value of the ActionGroupId property for this object.
     */
    public final String actionGroupId() {
        return actionGroupId;
    }

    /**
     * Returns the value of the ActionGroupName property for this object.
     * 
     * @return The value of the ActionGroupName property for this object.
     */
    public final String actionGroupName() {
        return actionGroupName;
    }

    /**
     * Returns the value of the ActionGroupState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroupState}
     * will return {@link ActionGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionGroupStateAsString}.
     * </p>
     * 
     * @return The value of the ActionGroupState property for this object.
     * @see ActionGroupState
     */
    public final ActionGroupState actionGroupState() {
        return ActionGroupState.fromValue(actionGroupState);
    }

    /**
     * Returns the value of the ActionGroupState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroupState}
     * will return {@link ActionGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionGroupStateAsString}.
     * </p>
     * 
     * @return The value of the ActionGroupState property for this object.
     * @see ActionGroupState
     */
    public final String actionGroupStateAsString() {
        return actionGroupState;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionGroupSummary)) {
            return false;
        }
        ActionGroupSummary other = (ActionGroupSummary) obj;
        return Objects.equals(actionGroupId(), other.actionGroupId())
                && Objects.equals(actionGroupName(), other.actionGroupName())
                && Objects.equals(actionGroupStateAsString(), other.actionGroupStateAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionGroupSummary").add("ActionGroupId", actionGroupId())
                .add("ActionGroupName", actionGroupName()).add("ActionGroupState", actionGroupStateAsString())
                .add("Description", description()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroupId":
            return Optional.ofNullable(clazz.cast(actionGroupId()));
        case "actionGroupName":
            return Optional.ofNullable(clazz.cast(actionGroupName()));
        case "actionGroupState":
            return Optional.ofNullable(clazz.cast(actionGroupStateAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionGroupSummary, T> g) {
        return obj -> g.apply((ActionGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionGroupSummary> {
        /**
         * Sets the value of the ActionGroupId property for this object.
         *
         * @param actionGroupId
         *        The new value for the ActionGroupId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupId(String actionGroupId);

        /**
         * Sets the value of the ActionGroupName property for this object.
         *
         * @param actionGroupName
         *        The new value for the ActionGroupName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupName(String actionGroupName);

        /**
         * Sets the value of the ActionGroupState property for this object.
         *
         * @param actionGroupState
         *        The new value for the ActionGroupState property for this object.
         * @see ActionGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupState
         */
        Builder actionGroupState(String actionGroupState);

        /**
         * Sets the value of the ActionGroupState property for this object.
         *
         * @param actionGroupState
         *        The new value for the ActionGroupState property for this object.
         * @see ActionGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupState
         */
        Builder actionGroupState(ActionGroupState actionGroupState);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String actionGroupId;

        private String actionGroupName;

        private String actionGroupState;

        private String description;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionGroupSummary model) {
            actionGroupId(model.actionGroupId);
            actionGroupName(model.actionGroupName);
            actionGroupState(model.actionGroupState);
            description(model.description);
            updatedAt(model.updatedAt);
        }

        public final String getActionGroupId() {
            return actionGroupId;
        }

        public final void setActionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
        }

        @Override
        public final Builder actionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
            return this;
        }

        public final String getActionGroupName() {
            return actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final String getActionGroupState() {
            return actionGroupState;
        }

        public final void setActionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
        }

        @Override
        public final Builder actionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
            return this;
        }

        @Override
        public final Builder actionGroupState(ActionGroupState actionGroupState) {
            this.actionGroupState(actionGroupState == null ? null : actionGroupState.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ActionGroupSummary build() {
            return new ActionGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
