/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of agent version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentVersionSummary.Builder, AgentVersionSummary> {
    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentName").getter(getter(AgentVersionSummary::agentName)).setter(setter(Builder::agentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()).build();

    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentStatus").getter(getter(AgentVersionSummary::agentStatusAsString))
            .setter(setter(Builder::agentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(AgentVersionSummary::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AgentVersionSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AgentVersionSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentVersionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_NAME_FIELD,
            AGENT_STATUS_FIELD, AGENT_VERSION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentName;

    private final String agentStatus;

    private final String agentVersion;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String description;

    private AgentVersionSummary(BuilderImpl builder) {
        this.agentName = builder.agentName;
        this.agentStatus = builder.agentStatus;
        this.agentVersion = builder.agentVersion;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.description = builder.description;
    }

    /**
     * Returns the value of the AgentName property for this object.
     * 
     * @return The value of the AgentName property for this object.
     */
    public final String agentName() {
        return agentName;
    }

    /**
     * Returns the value of the AgentStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return The value of the AgentStatus property for this object.
     * @see AgentStatus
     */
    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(agentStatus);
    }

    /**
     * Returns the value of the AgentStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return The value of the AgentStatus property for this object.
     * @see AgentStatus
     */
    public final String agentStatusAsString() {
        return agentStatus;
    }

    /**
     * Returns the value of the AgentVersion property for this object.
     * 
     * @return The value of the AgentVersion property for this object.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentName());
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentVersionSummary)) {
            return false;
        }
        AgentVersionSummary other = (AgentVersionSummary) obj;
        return Objects.equals(agentName(), other.agentName())
                && Objects.equals(agentStatusAsString(), other.agentStatusAsString())
                && Objects.equals(agentVersion(), other.agentVersion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentVersionSummary").add("AgentName", agentName()).add("AgentStatus", agentStatusAsString())
                .add("AgentVersion", agentVersion()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentName":
            return Optional.ofNullable(clazz.cast(agentName()));
        case "agentStatus":
            return Optional.ofNullable(clazz.cast(agentStatusAsString()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentVersionSummary, T> g) {
        return obj -> g.apply((AgentVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentVersionSummary> {
        /**
         * Sets the value of the AgentName property for this object.
         *
         * @param agentName
         *        The new value for the AgentName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentName(String agentName);

        /**
         * Sets the value of the AgentStatus property for this object.
         *
         * @param agentStatus
         *        The new value for the AgentStatus property for this object.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(String agentStatus);

        /**
         * Sets the value of the AgentStatus property for this object.
         *
         * @param agentStatus
         *        The new value for the AgentStatus property for this object.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(AgentStatus agentStatus);

        /**
         * Sets the value of the AgentVersion property for this object.
         *
         * @param agentVersion
         *        The new value for the AgentVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String agentName;

        private String agentStatus;

        private String agentVersion;

        private Instant createdAt;

        private Instant updatedAt;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentVersionSummary model) {
            agentName(model.agentName);
            agentStatus(model.agentStatus);
            agentVersion(model.agentVersion);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            description(model.description);
        }

        public final String getAgentName() {
            return agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final String getAgentStatus() {
            return agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public AgentVersionSummary build() {
            return new AgentVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
