/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Create Action Group Response
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAgentActionGroupResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<CreateAgentActionGroupResponse.Builder, CreateAgentActionGroupResponse> {
    private static final SdkField<AgentActionGroup> AGENT_ACTION_GROUP_FIELD = SdkField
            .<AgentActionGroup> builder(MarshallingType.SDK_POJO).memberName("agentActionGroup")
            .getter(getter(CreateAgentActionGroupResponse::agentActionGroup)).setter(setter(Builder::agentActionGroup))
            .constructor(AgentActionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentActionGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ACTION_GROUP_FIELD));

    private final AgentActionGroup agentActionGroup;

    private CreateAgentActionGroupResponse(BuilderImpl builder) {
        super(builder);
        this.agentActionGroup = builder.agentActionGroup;
    }

    /**
     * Returns the value of the AgentActionGroup property for this object.
     * 
     * @return The value of the AgentActionGroup property for this object.
     */
    public final AgentActionGroup agentActionGroup() {
        return agentActionGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentActionGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentActionGroupResponse)) {
            return false;
        }
        CreateAgentActionGroupResponse other = (CreateAgentActionGroupResponse) obj;
        return Objects.equals(agentActionGroup(), other.agentActionGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAgentActionGroupResponse").add("AgentActionGroup", agentActionGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentActionGroup":
            return Optional.ofNullable(clazz.cast(agentActionGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentActionGroupResponse, T> g) {
        return obj -> g.apply((CreateAgentActionGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAgentActionGroupResponse> {
        /**
         * Sets the value of the AgentActionGroup property for this object.
         *
         * @param agentActionGroup
         *        The new value for the AgentActionGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentActionGroup(AgentActionGroup agentActionGroup);

        /**
         * Sets the value of the AgentActionGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AgentActionGroup.Builder} avoiding the
         * need to create one manually via {@link AgentActionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentActionGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #agentActionGroup(AgentActionGroup)}.
         * 
         * @param agentActionGroup
         *        a consumer that will call methods on {@link AgentActionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentActionGroup(AgentActionGroup)
         */
        default Builder agentActionGroup(Consumer<AgentActionGroup.Builder> agentActionGroup) {
            return agentActionGroup(AgentActionGroup.builder().applyMutation(agentActionGroup).build());
        }
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private AgentActionGroup agentActionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentActionGroupResponse model) {
            super(model);
            agentActionGroup(model.agentActionGroup);
        }

        public final AgentActionGroup.Builder getAgentActionGroup() {
            return agentActionGroup != null ? agentActionGroup.toBuilder() : null;
        }

        public final void setAgentActionGroup(AgentActionGroup.BuilderImpl agentActionGroup) {
            this.agentActionGroup = agentActionGroup != null ? agentActionGroup.build() : null;
        }

        @Override
        public final Builder agentActionGroup(AgentActionGroup agentActionGroup) {
            this.agentActionGroup = agentActionGroup;
            return this;
        }

        @Override
        public CreateAgentActionGroupResponse build() {
            return new CreateAgentActionGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
