/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a raw data source location to ingest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfiguration.Builder, DataSourceConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DataSourceConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<S3DataSourceConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3Configuration")
            .getter(getter(DataSourceConfiguration::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            S3_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final S3DataSourceConfiguration s3Configuration;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Configuration = builder.s3Configuration;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see DataSourceType
     */
    public final DataSourceType type() {
        return DataSourceType.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see DataSourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the S3Configuration property for this object.
     * 
     * @return The value of the S3Configuration property for this object.
     */
    public final S3DataSourceConfiguration s3Configuration() {
        return s3Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(s3Configuration(), other.s3Configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceConfiguration").add("Type", typeAsString()).add("S3Configuration", s3Configuration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "s3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfiguration> {
        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(DataSourceType type);

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * @param s3Configuration
         *        The new value for the S3Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DataSourceConfiguration s3Configuration);

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3DataSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Configuration(S3DataSourceConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3DataSourceConfiguration)
         */
        default Builder s3Configuration(Consumer<S3DataSourceConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3DataSourceConfiguration.builder().applyMutation(s3Configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private S3DataSourceConfiguration s3Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            type(model.type);
            s3Configuration(model.s3Configuration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final S3DataSourceConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DataSourceConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DataSourceConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        @Override
        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
