/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information of an ingestion job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestionJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestionJobSummary.Builder, IngestionJobSummary> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(IngestionJobSummary::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(IngestionJobSummary::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()).build();

    private static final SdkField<String> INGESTION_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionJobId").getter(getter(IngestionJobSummary::ingestionJobId))
            .setter(setter(Builder::ingestionJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionJobId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(IngestionJobSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(IngestionJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(IngestionJobSummary::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(IngestionJobSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<IngestionJobStatistics> STATISTICS_FIELD = SdkField
            .<IngestionJobStatistics> builder(MarshallingType.SDK_POJO).memberName("statistics")
            .getter(getter(IngestionJobSummary::statistics)).setter(setter(Builder::statistics))
            .constructor(IngestionJobStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            DATA_SOURCE_ID_FIELD, INGESTION_JOB_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STARTED_AT_FIELD, UPDATED_AT_FIELD,
            STATISTICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String dataSourceId;

    private final String ingestionJobId;

    private final String description;

    private final String status;

    private final Instant startedAt;

    private final Instant updatedAt;

    private final IngestionJobStatistics statistics;

    private IngestionJobSummary(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.dataSourceId = builder.dataSourceId;
        this.ingestionJobId = builder.ingestionJobId;
        this.description = builder.description;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.updatedAt = builder.updatedAt;
        this.statistics = builder.statistics;
    }

    /**
     * Returns the value of the KnowledgeBaseId property for this object.
     * 
     * @return The value of the KnowledgeBaseId property for this object.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * Returns the value of the DataSourceId property for this object.
     * 
     * @return The value of the DataSourceId property for this object.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * Returns the value of the IngestionJobId property for this object.
     * 
     * @return The value of the IngestionJobId property for this object.
     */
    public final String ingestionJobId() {
        return ingestionJobId;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see IngestionJobStatus
     */
    public final IngestionJobStatus status() {
        return IngestionJobStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see IngestionJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the StartedAt property for this object.
     * 
     * @return The value of the StartedAt property for this object.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * Returns the value of the Statistics property for this object.
     * 
     * @return The value of the Statistics property for this object.
     */
    public final IngestionJobStatistics statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionJobId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionJobSummary)) {
            return false;
        }
        IngestionJobSummary other = (IngestionJobSummary) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(ingestionJobId(), other.ingestionJobId()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestionJobSummary").add("KnowledgeBaseId", knowledgeBaseId())
                .add("DataSourceId", dataSourceId()).add("IngestionJobId", ingestionJobId()).add("Description", description())
                .add("Status", statusAsString()).add("StartedAt", startedAt()).add("UpdatedAt", updatedAt())
                .add("Statistics", statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "ingestionJobId":
            return Optional.ofNullable(clazz.cast(ingestionJobId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestionJobSummary, T> g) {
        return obj -> g.apply((IngestionJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestionJobSummary> {
        /**
         * Sets the value of the KnowledgeBaseId property for this object.
         *
         * @param knowledgeBaseId
         *        The new value for the KnowledgeBaseId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * Sets the value of the DataSourceId property for this object.
         *
         * @param dataSourceId
         *        The new value for the DataSourceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * Sets the value of the IngestionJobId property for this object.
         *
         * @param ingestionJobId
         *        The new value for the IngestionJobId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionJobId(String ingestionJobId);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see IngestionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionJobStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see IngestionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionJobStatus
         */
        Builder status(IngestionJobStatus status);

        /**
         * Sets the value of the StartedAt property for this object.
         *
         * @param startedAt
         *        The new value for the StartedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the Statistics property for this object.
         *
         * @param statistics
         *        The new value for the Statistics property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(IngestionJobStatistics statistics);

        /**
         * Sets the value of the Statistics property for this object.
         *
         * This is a convenience method that creates an instance of the {@link IngestionJobStatistics.Builder} avoiding
         * the need to create one manually via {@link IngestionJobStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestionJobStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #statistics(IngestionJobStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link IngestionJobStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(IngestionJobStatistics)
         */
        default Builder statistics(Consumer<IngestionJobStatistics.Builder> statistics) {
            return statistics(IngestionJobStatistics.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String dataSourceId;

        private String ingestionJobId;

        private String description;

        private String status;

        private Instant startedAt;

        private Instant updatedAt;

        private IngestionJobStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionJobSummary model) {
            knowledgeBaseId(model.knowledgeBaseId);
            dataSourceId(model.dataSourceId);
            ingestionJobId(model.ingestionJobId);
            description(model.description);
            status(model.status);
            startedAt(model.startedAt);
            updatedAt(model.updatedAt);
            statistics(model.statistics);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getIngestionJobId() {
            return ingestionJobId;
        }

        public final void setIngestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
        }

        @Override
        public final Builder ingestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngestionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final IngestionJobStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(IngestionJobStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(IngestionJobStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public IngestionJobSummary build() {
            return new IngestionJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
